/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.common.Requests;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class Tools {
    private static final Logger log = LoggerFactory.getLogger(Tools.class);
    public static String localIp = Tools.getLocalIp();

    public static <T> T execExpression(String key, Map<String, Object> params, String expression, Class<T> tClass) throws Exception {
        try {
            log.info(">>>Tools|execExpression|enter|key={}, expression={}", (Object)key, (Object)expression);
            SpelExpressionParser parser = new SpelExpressionParser();
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setVariables(params);
            Object result = parser.parseExpression(expression).getValue((EvaluationContext)context, tClass);
            log.info(">>>Tools|execExpression|exit|key={}, result={}", (Object)key, result);
            return (T)result;
        }
        catch (Exception e) {
            throw new Exception("params: " + JSONObject.toJSONString(params) + "\nexpression: " + expression + "\nclass: " + tClass.getTypeName(), e);
        }
    }

    public static List<String> findAllMatch(String source, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(source);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            list.add(matcher.group());
        }
        return list;
    }

    public static boolean onlyHave(List<String> statusList, List<String> subStatusList) {
        for (String s : statusList) {
            if (subStatusList.contains(s)) continue;
            return false;
        }
        return true;
    }

    public static String timeStamp2Date(Long seconds, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(seconds * 1000L));
    }

    public static String timeStamp2Date(Integer seconds, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date((long)seconds.intValue() * 1000L));
    }

    public static String timeStamp2Date(Integer seconds) {
        return Tools.timeStamp2Date(seconds, "yyyy-MM-dd HH:mm:ss");
    }

    public static String timeStamp2Date(Long seconds) {
        return Tools.timeStamp2Date(seconds, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getLocalIp() {
        String ip;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            ip = addr.getHostAddress();
        }
        catch (Exception ex) {
            ip = "";
        }
        return ip;
    }

    public static ThreadPoolExecutor createThreadPool(int maxPoolSize, String threadPoolName) {
        LinkedBlockingQueue<Runnable> blockingQueue = new LinkedBlockingQueue<Runnable>();
        return Tools.createThreadPoolWithQueue(maxPoolSize, threadPoolName, blockingQueue);
    }

    public static ThreadPoolExecutor createThreadPoolWithQueue(int maxPoolSize, String threadPoolName, BlockingQueue<Runnable> blockingQueue) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(String.format("%s-%s", threadPoolName, maxPoolSize) + "-%d").build();
        return new ThreadPoolExecutor(maxPoolSize, maxPoolSize, 0L, TimeUnit.MILLISECONDS, blockingQueue, threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    public static String jsonObjectGetString(JSONObject jsonObject, String key) {
        Object value = JSONObject.toJSON((Object)jsonObject.get((Object)key));
        if (value instanceof JSON) {
            return JSONObject.toJSONString((Object)value);
        }
        return jsonObject.getString(key);
    }

    public static List<String> classNameList(File file) throws IOException {
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
        ArrayList<String> classNameList = new ArrayList<String>();
        while (jarEntryEnumeration.hasMoreElements()) {
            String name;
            JarEntry jarEntry = jarEntryEnumeration.nextElement();
            if (jarEntry.isDirectory() || !(name = jarEntry.getName()).endsWith(".class") || name.contains("$")) continue;
            name = name.replace(".class", "").replace("/", ".");
            classNameList.add(name);
        }
        return classNameList;
    }

    public static JSONObject userInfo(String empid) throws Exception {
        JSONObject userInfo = Requests.get("http://connector.mw.tesla.alibaba-inc.com/buc/user/" + empid, JSONObject.class);
        return userInfo.getJSONObject("data");
    }

    public static void randomSleep(int bound) {
        try {
            Thread.sleep(new Random().nextInt(bound));
        }
        catch (InterruptedException e) {
            log.error("", (Throwable)e);
        }
    }

    public static void randomSleep() {
        Tools.randomSleep(1000);
    }

    public static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static void main(String[] args) throws Exception {
        ImmutableMap params = ImmutableMap.of((Object)"check_dam_status_a5e8560d47c341afb45a6dd297db2805", (Object)ImmutableMap.of((Object)"result", (Object)ImmutableMap.of((Object)"status", (Object)"CRITICAL")));
        String expression = "#check_dam_status_a5e8560d47c341afb45a6dd297db2805['result']['status'] != 'OK'";
        Tools.execExpression("", (Map<String, Object>)params, expression, Boolean.class);
        Boolean result = Tools.execExpression("", new HashMap<String, Object>(), "1==1", Boolean.class);
        System.out.println(result);
    }
}

