/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class DagAsyncConfig {
    private static final Logger log = LoggerFactory.getLogger(DagAsyncConfig.class);
    @Value(value="${dag.scheduling.maxPoolSize:50}")
    public int dagSchedulingMaxPoolSize;
    @Value(value="${dag.monitor.maxPoolSize:100}")
    public int dagMonitorMaxPoolSize;

    @Bean(value={"instAsyncTaskExecutor"})
    public ThreadPoolTaskExecutor instAsyncTaskExecutor() {
        ThreadPoolTaskExecutor instAsyncTaskExecutor = new ThreadPoolTaskExecutor();
        instAsyncTaskExecutor.setMaxPoolSize(this.dagSchedulingMaxPoolSize);
        instAsyncTaskExecutor.setCorePoolSize(this.dagSchedulingMaxPoolSize);
        instAsyncTaskExecutor.setThreadNamePrefix("dag-scheduling-thread-pool-");
        instAsyncTaskExecutor.initialize();
        return instAsyncTaskExecutor;
    }

    @Bean(value={"nodeAsyncTaskExecutor"})
    public ThreadPoolTaskExecutor nodeAsyncTaskExecutor() {
        ThreadPoolTaskExecutor nodeAsyncTaskExecutor = new ThreadPoolTaskExecutor();
        nodeAsyncTaskExecutor.setMaxPoolSize(this.dagMonitorMaxPoolSize);
        nodeAsyncTaskExecutor.setCorePoolSize(this.dagMonitorMaxPoolSize);
        nodeAsyncTaskExecutor.setThreadNamePrefix("dag-monitor-thread-pool-");
        nodeAsyncTaskExecutor.initialize();
        return nodeAsyncTaskExecutor;
    }
}

