/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.dispatch;

import com.alibaba.tesla.dag.dispatch.IDagInstDispatcher;
import com.alibaba.tesla.dag.notify.DagInstDispatch;
import com.alibaba.tesla.dag.notify.IDagInstNotify;
import com.alibaba.tesla.dag.repository.dao.DagInstDAO;
import com.alibaba.tesla.dag.repository.domain.DagInstDO;
import com.alibaba.tesla.dag.schedule.evaluation.EvaluationService;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;
import com.alibaba.tesla.dag.services.DagInstNewService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitDagInstDispatcher
implements IDagInstDispatcher {
    private static final Logger log = LoggerFactory.getLogger(InitDagInstDispatcher.class);
    @Autowired
    private DagInstDAO dagInstDAO;
    @Autowired
    private IDagInstNotify dagInstNotify;
    @Autowired
    private DagInstNewService dagInstNewService;
    @Autowired
    private EvaluationService evaluationService;

    @Override
    public DagInstStatus registerType() {
        return DagInstStatus.INIT;
    }

    @Override
    public void dispatch(DagInstDO dagInstDO) {
        Long dagInstId = dagInstDO.getId();
        log.info(">>>[Init]|dispatch|dagInstId={}", (Object)dagInstId);
        if (StringUtils.isEmpty((CharSequence)dagInstDO.getEvaluationCreateRet())) {
            DagInstDO update = DagInstDO.builder().id(dagInstId).build();
            update.setEvaluationCreateRet(this.evaluationService.create(dagInstDO));
            this.dagInstDAO.update(update);
        }
        DagInstDispatch dagInstDispatch = this.dagInstNewService.initInst(dagInstDO, this.registerType());
        this.dagInstNotify.sendDagInstDispatch(dagInstDispatch);
    }
}

