/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.dispatch;

import com.alibaba.tesla.dag.dispatch.IDagInstDispatcher;
import com.alibaba.tesla.dag.notify.DagInstNodeTask;
import com.alibaba.tesla.dag.notify.IDagInstNodeTaskNotify;
import com.alibaba.tesla.dag.notify.NodeTaskType;
import com.alibaba.tesla.dag.repository.dao.DagInstNodeDAO;
import com.alibaba.tesla.dag.repository.domain.DagInstDO;
import com.alibaba.tesla.dag.repository.domain.DagInstNodeDO;
import com.alibaba.tesla.dag.schedule.status.DagInstNodeStatus;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;
import com.alibaba.tesla.dag.services.DagInstNewService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PostRunningDagInstDispatcher
implements IDagInstDispatcher {
    private static final Logger log = LoggerFactory.getLogger(PostRunningDagInstDispatcher.class);
    @Autowired
    private DagInstNodeDAO dagInstNodeDAO;
    @Autowired
    private IDagInstNodeTaskNotify dagInstNodeTaskNotify;
    @Autowired
    private DagInstNewService dagInstNewService;

    @Override
    public DagInstStatus registerType() {
        return DagInstStatus.POST_RUNNING;
    }

    @Override
    public void dispatch(DagInstDO dagInstDO) {
        Long dagInstId = dagInstDO.getId();
        log.info(">>>postRunningDagInstDispatcher|dispatch|dagInstId={}", (Object)dagInstId);
        DagInstNodeDO postNode = this.dagInstNodeDAO.getDagInstNode(dagInstId, "__post_node__");
        if (Objects.isNull(postNode)) {
            log.warn(">>>postRunningDagInstDispatcher|dispatch|postNode is not exist|dagInstId={}", (Object)dagInstId);
            return;
        }
        DagInstNodeStatus status = postNode.fetchNodeStatus();
        switch (status) {
            case STOPPED: 
            case SKIP: 
            case SKIP_CAUSE_BY_STOPPED: 
            case SKIP_CAUSE_BY_EXCEPTION: 
            case EXCEPTION: {
                this.dagInstNewService.freshInstStatusWithDetail(dagInstDO, this.registerType(), DagInstStatus.EXCEPTION, String.format("run post node exception -- status: %s; detail: %s", new Object[]{status, postNode.getStatusDetail()}));
                break;
            }
            case INIT: 
            case STOPPING: 
            case RUNNING: 
            case WAIT_STOP: {
                DagInstNodeTask dagInstNodeTask = DagInstNodeTask.builder().dagInstId(dagInstId).nodeId(postNode.getNodeId()).nodeTaskType(NodeTaskType.START).build();
                this.dagInstNodeTaskNotify.sendDagInstNodeTask(dagInstNodeTask);
                break;
            }
            case SUCCESS: {
                this.dagInstNewService.freshInstStatus(dagInstDO, this.registerType(), DagInstStatus.SUCCESS);
                break;
            }
        }
    }
}

