/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.dispatch;

import com.alibaba.tesla.dag.dispatch.IDagInstDispatcher;
import com.alibaba.tesla.dag.notify.DagInstDispatch;
import com.alibaba.tesla.dag.notify.DagInstNodeTask;
import com.alibaba.tesla.dag.notify.IDagInstNodeTaskNotify;
import com.alibaba.tesla.dag.notify.IDagInstNotify;
import com.alibaba.tesla.dag.notify.NodeTaskType;
import com.alibaba.tesla.dag.repository.dao.DagInstNodeDAO;
import com.alibaba.tesla.dag.repository.domain.DagInstDO;
import com.alibaba.tesla.dag.repository.domain.DagInstNodeDO;
import com.alibaba.tesla.dag.schedule.status.DagInstNodeStatus;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;
import com.alibaba.tesla.dag.services.DagInstNewService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PreRunningDagInstDispatcher
implements IDagInstDispatcher {
    private static final Logger log = LoggerFactory.getLogger(PreRunningDagInstDispatcher.class);
    @Autowired
    private DagInstNodeDAO dagInstNodeDAO;
    @Autowired
    private IDagInstNotify dagInstNotify;
    @Autowired
    private IDagInstNodeTaskNotify dagInstNodeTaskNotify;
    @Autowired
    private DagInstNewService dagInstNewService;

    @Override
    public DagInstStatus registerType() {
        return DagInstStatus.PRE_RUNNING;
    }

    @Override
    public void dispatch(DagInstDO dagInstDO) {
        Long dagInstId = dagInstDO.getId();
        log.info(">>>[PreRunning]|dispatch|dagInstId={}", (Object)dagInstId);
        DagInstNodeDO preNode = this.dagInstNodeDAO.getDagInstNode(dagInstId, "__pre_node__");
        if (Objects.isNull(preNode)) {
            log.warn(">>>preRunningDagInstDispatcher|dispatch|preNode is not exist|dagInstId={}", (Object)dagInstId);
            return;
        }
        DagInstNodeStatus status = preNode.fetchNodeStatus();
        switch (status) {
            case EXCEPTION: 
            case SKIP_CAUSE_BY_EXCEPTION: 
            case WAIT_STOP: 
            case SKIP_CAUSE_BY_STOPPED: {
                this.dagInstNewService.freshInstStatusWithDetail(dagInstDO, this.registerType(), DagInstStatus.EXCEPTION, String.format("run pre node exception -- status: %s; detail: %s", new Object[]{status, preNode.getStatusDetail()}));
                break;
            }
            case RUNNING: 
            case STOPPING: 
            case INIT: {
                DagInstNodeTask dagInstNodeTask = DagInstNodeTask.builder().dagInstId(dagInstId).nodeId(preNode.getNodeId()).nodeTaskType(NodeTaskType.START).build();
                this.dagInstNodeTaskNotify.sendDagInstNodeTask(dagInstNodeTask);
                break;
            }
            case SUCCESS: 
            case SKIP: 
            case STOPPED: {
                this.dagInstNewService.freshInstStatus(dagInstDO, this.registerType(), DagInstStatus.RUNNING);
                DagInstDispatch dagInstDispatch = DagInstDispatch.builder().dagInstId(dagInstId).nodeId(preNode.getNodeId()).dagInstStatus(DagInstStatus.RUNNING).build();
                this.dagInstNotify.sendDagInstDispatch(dagInstDispatch);
                break;
            }
        }
    }
}

