/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.local;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.common.BeanUtil;
import com.alibaba.tesla.dag.local.AbstractLocalBase;
import com.alibaba.tesla.dag.local.DagAddNodeReq;
import com.alibaba.tesla.dag.model.domain.TcDag;
import com.alibaba.tesla.dag.model.domain.TcDagNode;
import com.alibaba.tesla.dag.model.domain.dag.DagInputParam;
import com.alibaba.tesla.dag.model.domain.dagnode.DagInstNodeType;
import com.alibaba.tesla.dag.model.repository.TcDagNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagRepository;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLocalDagBase
extends AbstractLocalBase {
    private static final Logger log = LoggerFactory.getLogger(AbstractLocalDagBase.class);
    public static String creator = "local";
    public static String appId = "tesla";
    public static String name = null;
    public static String alias = null;
    public static Integer hasFeedback = 0;
    public static Integer hasHistory = 1;
    public static String description = "";
    public static List<DagInputParam> inputParams = new ArrayList<DagInputParam>();
    public Map<String, Map<String, Object>> nodeMap = new HashMap<String, Map<String, Object>>(0);
    public Map<String, Map<String, Object>> edgeMap = new HashMap<String, Map<String, Object>>(0);

    public void node(String name) throws Exception {
        this.node(appId, name, name, false, -1);
    }

    public void node(String name, Integer index) throws Exception {
        this.node(appId, name, name, false, index);
    }

    public void node(String name, String nodeId) throws Exception {
        this.node(appId, name, nodeId, false, -1);
    }

    public void node(String name, Boolean isDag) throws Exception {
        this.node(appId, name, name, isDag, -1);
    }

    public void node(String appId, String name, String nodeId) throws Exception {
        this.node(appId, name, nodeId, false, -1);
    }

    public void node(String appId, String name, String nodeId, Boolean isDag, Integer index) throws Exception {
        this.node(DagAddNodeReq.builder().appId(appId).name(name).nodeId(nodeId).isDag(isDag).index(index).build());
    }

    public void node(DagAddNodeReq req) throws Exception {
        long defId;
        if (this.nodeMap.containsKey(req.nodeId)) {
            throw new Exception("nodeId must be unique in dag");
        }
        if (req.isDag.booleanValue()) {
            TcDag dag = BeanUtil.getBean(TcDagRepository.class).findFirstByAppIdAndName(req.appId, req.name);
            if (dag == null) {
                log.warn(String.format("dag with appId: %s name: %s not exists", req.appId, req.name));
                defId = -1L;
            } else {
                defId = dag.getId();
            }
        } else {
            TcDagNode dagNode = BeanUtil.getBean(TcDagNodeRepository.class).findFirstByAppIdAndName(req.appId, req.name);
            if (dagNode == null) {
                throw new Exception(String.format("dagNode with appId: %s name: %s not exists", req.appId, req.name));
            }
            defId = dagNode.getId();
        }
        ImmutableMap.Builder dataBuilder = new ImmutableMap.Builder().put((Object)"type", (Object)(req.isDag != false ? DagInstNodeType.DAG.name() : DagInstNodeType.NODE.name())).put((Object)"id", (Object)req.nodeId).put((Object)"label", (Object)req.name).put((Object)"inputParams", new ArrayList()).put((Object)"defId", (Object)defId);
        if (req.retryExpression != null) {
            dataBuilder.put((Object)"retryExpression", (Object)req.retryExpression);
        }
        if (req.maxRetryTimes != null) {
            dataBuilder.put((Object)"maxRetryTimes", (Object)req.maxRetryTimes);
        }
        this.nodeMap.put(req.nodeId, (Map<String, Object>)ImmutableMap.of((Object)"index", (Object)req.index, (Object)"id", (Object)req.nodeId, (Object)"label", (Object)req.name, (Object)"shape", (Object)"rect", (Object)"data", (Object)dataBuilder.build()));
    }

    public void edge(String nodeId1, String nodeId2) throws Exception {
        this.edge(nodeId1, nodeId2, "");
    }

    public void edge(String nodeId1, String nodeId2, String expression) throws Exception {
        String name = JSONObject.toJSONString((Object)ImmutableList.of((Object)nodeId1, (Object)nodeId2));
        if (this.edgeMap.containsKey(name)) {
            throw new Exception("edge must be unique within two nodes");
        }
        this.edgeMap.put(name, (Map<String, Object>)ImmutableMap.of((Object)"source", (Object)nodeId1, (Object)"target", (Object)nodeId2, (Object)"shape", (Object)"QuadraticEdge", (Object)"data", (Object)ImmutableMap.of((Object)"expression", (Object)expression), (Object)"style", (Object)ImmutableMap.of((Object)"endArrow", (Object)true, (Object)"stroke", (Object)"#fdad", (Object)"lineWidth", (Object)2)));
    }

    public abstract void draw() throws Exception;
}

