/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.local;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.ApplicationProperties;
import com.alibaba.tesla.dag.common.Tools;
import com.alibaba.tesla.dag.local.AbstractLocalDagBase;
import com.alibaba.tesla.dag.local.ClassService;
import com.alibaba.tesla.dag.model.domain.TcDag;
import com.alibaba.tesla.dag.model.domain.TcDagNode;
import com.alibaba.tesla.dag.model.domain.TcDagServiceNode;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeDetailLocal;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeFormatType;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeType;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeStdRepository;
import com.alibaba.tesla.dag.model.repository.TcDagNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagRepository;
import com.alibaba.tesla.dag.model.repository.TcDagServiceNodeRepository;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"beanUtil"})
public class LocalService {
    private static final Logger log = LoggerFactory.getLogger(LocalService.class);
    @Autowired
    ClassService classService;
    @Autowired
    TcDagNodeRepository dagNodeRepository;
    @Autowired
    TcDagRepository dagRepository;
    @Autowired
    TcDagInstNodeStdRepository dagInstNodeStdRepository;
    @Autowired
    TcDagInstNodeRepository dagInstNodeRepository;
    @Autowired
    ApplicationProperties ap;
    @Autowired
    TcDagServiceNodeRepository dagServiceNodeRepository;
    public static String LAST_UPDATE_BY = "LOCAL";
    private ThreadPoolExecutor executor = null;

    @PostConstruct
    public void postConstruct() {
        this.executor = Tools.createThreadPool(this.ap.teslaDagLocalnodeRunMaxSize, "localNodeRun");
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(2, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("%d").daemon(true).build());
        executor.scheduleAtFixedRate(this::run, 0L, 10L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void preDestroy() throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    public void run() {
        try {
            TcDagServiceNode tcDagServiceNode = this.dagServiceNodeRepository.findFirstByIp(Tools.localIp);
            if (Objects.isNull(tcDagServiceNode)) {
                return;
            }
            boolean enable = tcDagServiceNode.enable();
            if (!enable) {
                return;
            }
            if (this.classService.dagMap == null || this.classService.nodeMap == null) {
                return;
            }
            this.registerNodeList();
            this.registerDagList();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public void cleanInvalidDag(JSONArray appIdNameArray) {
        List<TcDag> dagList = this.dagRepository.findAllByLastUpdateBy(LAST_UPDATE_BY);
        for (TcDag dag : dagList) {
            String key = JSONObject.toJSONString(Arrays.asList(dag.getAppId(), dag.getName()));
            if (appIdNameArray.contains((Object)key)) continue;
            log.info("delete dag: " + dag.getName());
            this.dagRepository.delete(dag);
        }
    }

    public void cleanInvalidNode(JSONArray appIdNameArray) {
        List<TcDagNode> dagNodeList = this.dagNodeRepository.findAllByLastUpdateBy(LAST_UPDATE_BY);
        for (TcDagNode dagNode : dagNodeList) {
            String key = JSONObject.toJSONString(Arrays.asList(dagNode.getAppId(), dagNode.getName()));
            if (appIdNameArray.contains((Object)key)) continue;
            log.info("delete node: " + dagNode.getName());
            this.dagNodeRepository.delete(dagNode);
        }
    }

    public List<String> registerNode(String name, Class nodeClass) throws Exception {
        String appId = (String)nodeClass.getField("appId").get(nodeClass);
        String alias = (String)nodeClass.getField("alias").get(nodeClass);
        String description = (String)nodeClass.getField("description").get(nodeClass);
        Integer isShare = (Integer)nodeClass.getField("isShare").get(nodeClass);
        Integer isShow = (Integer)nodeClass.getField("isShow").get(nodeClass);
        Object inputParams = nodeClass.getField("inputParams").get(nodeClass);
        Object outputParams = nodeClass.getField("outputParams").get(nodeClass);
        DagNodeType nodeType = (DagNodeType)((Object)nodeClass.getField("nodeType").get(nodeClass));
        DagNodeFormatType formatType = (DagNodeFormatType)((Object)nodeClass.getField("formatType").get(nodeClass));
        String formatDetail = (String)nodeClass.getField("formatDetail").get(nodeClass);
        String creator = (String)nodeClass.getField("creator").get(nodeClass);
        Integer runTimeout = (Integer)nodeClass.getField("runTimeout").get(nodeClass);
        Long maxRetryTimes = (Long)nodeClass.getField("maxRetryTimes").get(nodeClass);
        String retryExpression = (String)nodeClass.getField("retryExpression").get(nodeClass);
        TcDagNode dagNode = TcDagNode.builder().gmtCreate(System.currentTimeMillis() / 1000L).gmtModified(System.currentTimeMillis() / 1000L).appId(appId).name(name).alias(StringUtils.isEmpty((CharSequence)alias) ? name : alias).description(description).isShare(isShare).isShow(isShow).inputParams(JSONObject.toJSONString((Object)inputParams)).outputParams(JSONObject.toJSONString((Object)outputParams)).type(nodeType.name()).detail(DagNodeDetailLocal.builder().appId(appId).name(name).build().toJson()).formatType(formatType.name()).formatDetail(formatDetail).creator(creator).modifier(creator).runTimeout(runTimeout).maxRetryTimes(maxRetryTimes).retryExpression(retryExpression).lastUpdateBy(LAST_UPDATE_BY).build();
        dagNode.upsertByAppIdAndName();
        dagNode.updateOptions();
        return Arrays.asList(appId, name);
    }

    public void registerNodeList() {
        JSONArray appIdNameArray = new JSONArray();
        for (Map.Entry<String, Class> entry : this.classService.nodeMap.entrySet()) {
            List<String> appIdAndName;
            String name = entry.getKey();
            Class nodeClass = entry.getValue();
            try {
                appIdAndName = this.registerNode(name, nodeClass);
            }
            catch (Exception e) {
                log.error(String.format("registerNode ERROR; name: %s, nodeClass: %s", name, nodeClass.getName()), (Throwable)e);
                continue;
            }
            appIdNameArray.add((Object)JSONObject.toJSONString(appIdAndName));
        }
        this.cleanInvalidNode(appIdNameArray);
    }

    public List<String> registerDag(String name, Class dagClass) throws Exception {
        String appId = (String)dagClass.getField("appId").get(dagClass);
        String alias = (String)dagClass.getField("alias").get(dagClass);
        Object inputParams = dagClass.getField("inputParams").get(dagClass);
        Integer hasFeedback = (Integer)dagClass.getField("hasFeedback").get(dagClass);
        Integer hasHistory = (Integer)dagClass.getField("hasHistory").get(dagClass);
        String creator = (String)dagClass.getField("creator").get(dagClass);
        AbstractLocalDagBase localDag = (AbstractLocalDagBase)dagClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        localDag.draw();
        TcDag dag = TcDag.builder().gmtCreate(System.currentTimeMillis() / 1000L).gmtModified(System.currentTimeMillis() / 1000L).appId(appId).name(name).alias(StringUtils.isEmpty((CharSequence)alias) ? name : alias).content(JSONObject.toJSONString((Object)ImmutableMap.of((Object)"nodes", localDag.nodeMap.values(), (Object)"edges", localDag.edgeMap.values()))).inputParams(JSONObject.toJSONString((Object)inputParams)).hasFeedback(hasFeedback).hasHistory(hasHistory).creator(creator).modifier(creator).lastUpdateBy(LAST_UPDATE_BY).build();
        dag.upsertByAppIdAndName();
        dag.updateOptions();
        return Arrays.asList(appId, name);
    }

    public JSONArray registerDagList(Set<Map.Entry<String, Class>> dagClassEntrySet, JSONArray appIdNameArray) {
        HashSet<Map.Entry<String, Class>> failedDagClassEntrySet = new HashSet<Map.Entry<String, Class>>();
        ArrayList<String> logList = new ArrayList<String>();
        for (Map.Entry<String, Class> entry : dagClassEntrySet) {
            List<String> appIdAndName;
            String name = entry.getKey();
            Class dagClass = entry.getValue();
            try {
                appIdAndName = this.registerDag(name, dagClass);
            }
            catch (Exception e) {
                logList.add(String.format("registerDag ERROR; name: %s, dagClass: %s, detail: %s", name, dagClass.getName(), e.getMessage()));
                failedDagClassEntrySet.add(entry);
                continue;
            }
            appIdNameArray.add((Object)JSONObject.toJSONString(appIdAndName));
        }
        if (failedDagClassEntrySet.size() != dagClassEntrySet.size()) {
            this.registerDagList(failedDagClassEntrySet, appIdNameArray);
        } else {
            logList.forEach(arg_0 -> ((Logger)log).warn(arg_0));
        }
        return appIdNameArray;
    }

    public void registerDagList() {
        this.cleanInvalidDag(this.registerDagList(this.classService.dagMap.entrySet(), new JSONArray()));
    }
}

