/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.local;

import com.alibaba.tesla.dag.ApplicationProperties;
import com.alibaba.tesla.dag.local.FileDetail;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.GetObjectRequest;
import io.minio.MinioClient;
import io.minio.messages.Item;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteJarService {
    private static final Logger log = LoggerFactory.getLogger(RemoteJarService.class);
    @Autowired
    private ApplicationProperties ap;
    private OSS ossClient;
    private MinioClient minioClient;
    private File rootDirFile;
    private Map<String, Date> jarFileLastDownloadDate = new Hashtable<String, Date>();
    private List<String> sourceList = Arrays.asList("oss", "minio");
    ScheduledThreadPoolExecutor executor;

    private void init() throws Exception {
        File rootFile = new File(this.ap.teslaDagLocalnodeJarPath);
        rootFile.mkdirs();
        if (!rootFile.exists()) {
            throw new Exception(this.ap.teslaDagLocalnodeJarPath + " is not exists");
        }
        for (String source : this.sourceList) {
            File sourceFile = new File(this.ap.teslaDagLocalnodeJarPath + "/" + source);
            sourceFile.mkdirs();
            if (rootFile.exists()) continue;
            throw new Exception(this.ap.teslaDagLocalnodeJarPath + "/" + source + " is not exists");
        }
    }

    private OSS ossClient() {
        if (this.ossClient == null && StringUtils.isNotEmpty((CharSequence)this.ap.dagHotLoadJarOssEndpoint) && StringUtils.isNotEmpty((CharSequence)this.ap.dagHotLoadJarOssAccessKeyId) && StringUtils.isNotEmpty((CharSequence)this.ap.dagHotLoadJarOssAccessKeySecret) && StringUtils.isNotEmpty((CharSequence)this.ap.dagHotLoadJarOssBucketName)) {
            this.ossClient = new OSSClientBuilder().build(this.ap.dagHotLoadJarOssEndpoint, this.ap.dagHotLoadJarOssAccessKeyId, this.ap.dagHotLoadJarOssAccessKeySecret);
        }
        return this.ossClient;
    }

    private MinioClient minioClient() throws Exception {
        if (this.minioClient == null && StringUtils.isNotEmpty((CharSequence)this.ap.dagHotLoadJarMinioEndpoint) && StringUtils.isNotEmpty((CharSequence)this.ap.dagHotLoadJarMinioAccessKeyId) && StringUtils.isNotEmpty((CharSequence)this.ap.dagHotLoadJarMinioAccessKeySecret) && StringUtils.isNotEmpty((CharSequence)this.ap.dagHotLoadJarMinioBucketName)) {
            this.minioClient = new MinioClient(this.ap.dagHotLoadJarMinioEndpoint, this.ap.dagHotLoadJarMinioAccessKeyId, this.ap.dagHotLoadJarMinioAccessKeySecret);
        }
        return this.minioClient;
    }

    private List<FileDetail> getOssFileList() {
        return this.ossClient() == null ? new ArrayList<FileDetail>() : this.ossClient().listObjects(this.ap.dagHotLoadJarOssBucketName).getObjectSummaries().stream().map(x -> FileDetail.builder().name(x.getKey()).lastModified(x.getLastModified()).source("oss").build()).collect(Collectors.toList());
    }

    private List<FileDetail> getMinioFileList() throws Exception {
        if (this.minioClient() == null) {
            return new ArrayList<FileDetail>();
        }
        ArrayList<FileDetail> fileDetailList = new ArrayList<FileDetail>();
        try {
            this.minioClient().listObjects(this.ap.dagHotLoadJarMinioBucketName).forEach(x -> {
                try {
                    Item item = (Item)x.get();
                    fileDetailList.add(FileDetail.builder().name(item.objectName()).lastModified(item.lastModified()).source("minio").build());
                }
                catch (Exception e) {
                    log.warn(e.getLocalizedMessage());
                }
            });
        }
        catch (Exception e) {
            log.warn(e.getLocalizedMessage());
        }
        return fileDetailList;
    }

    private List<FileDetail> getFileList() throws Exception {
        return Stream.of(this.getOssFileList(), this.getMinioFileList()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<FileDetail> listShouldDownloadFileName() throws Exception {
        return this.getFileList().stream().filter(x -> !this.jarFileLastDownloadDate.containsKey(x.source + "/" + x.name) || this.jarFileLastDownloadDate.get(x.source + "/" + x.name).before(x.lastModified) || !new File(String.format("%s/%s/%s", this.ap.teslaDagLocalnodeJarPath, x.source, x.name)).exists()).collect(Collectors.toList());
    }

    private void download() throws Exception {
        for (FileDetail x : this.listShouldDownloadFileName()) {
            log.info(String.format("start download file: %s from %s ", x.name, x.source));
            String filePath = this.ap.teslaDagLocalnodeJarPath + "/" + x.source + "/" + x.name;
            String tmpFilePath = "/tmp/" + UUID.randomUUID();
            switch (x.source) {
                case "oss": {
                    if (this.ossClient() == null) break;
                    this.ossClient().getObject(new GetObjectRequest(this.ap.dagHotLoadJarOssBucketName, x.name), new File(tmpFilePath));
                    break;
                }
                case "minio": {
                    if (this.minioClient() == null) break;
                    this.minioClient().getObject(this.ap.dagHotLoadJarMinioBucketName, x.name, tmpFilePath);
                    break;
                }
            }
            Files.move(Paths.get(tmpFilePath, new String[0]), Paths.get(filePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            this.jarFileLastDownloadDate.put(x.source + "/" + x.name, new Date());
            log.info(String.format("end download file: %s from %s ", x.name, x.source));
        }
    }

    private void cleanDeleted() throws Exception {
        List fileSourceNameList = this.getFileList().stream().map(x -> String.format("%s/%s", x.source, x.name)).collect(Collectors.toList());
        for (String source : Arrays.asList("oss", "minio")) {
            for (File file : Objects.requireNonNull(new File(this.ap.teslaDagLocalnodeJarPath + "/" + source).listFiles())) {
                if (fileSourceNameList.contains(source + "/" + file.getName())) continue;
                boolean isDelete = file.delete();
                log.info(String.format("delete local file: %s with result: %s", file.getPath(), isDelete));
            }
        }
    }

    private void run() {
        try {
            this.init();
            this.download();
            this.cleanDeleted();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    @PostConstruct
    public void postConstruct() {
        log.info("start schedule rsync local hot jar from remote");
        this.executor = new ScheduledThreadPoolExecutor(2, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("%d").daemon(true).build());
        this.executor.scheduleAtFixedRate(this::run, 0L, this.ap.dagHotLoadJarIntervalSecond, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void preDestroy() throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    public ApplicationProperties getAp() {
        return this.ap;
    }

    public OSS getOssClient() {
        return this.ossClient;
    }

    public MinioClient getMinioClient() {
        return this.minioClient;
    }

    public File getRootDirFile() {
        return this.rootDirFile;
    }

    public Map<String, Date> getJarFileLastDownloadDate() {
        return this.jarFileLastDownloadDate;
    }

    public List<String> getSourceList() {
        return this.sourceList;
    }

    public ScheduledThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    public void setAp(ApplicationProperties ap) {
        this.ap = ap;
    }

    public void setOssClient(OSS ossClient) {
        this.ossClient = ossClient;
    }

    public void setMinioClient(MinioClient minioClient) {
        this.minioClient = minioClient;
    }

    public void setRootDirFile(File rootDirFile) {
        this.rootDirFile = rootDirFile;
    }

    public void setJarFileLastDownloadDate(Map<String, Date> jarFileLastDownloadDate) {
        this.jarFileLastDownloadDate = jarFileLastDownloadDate;
    }

    public void setSourceList(List<String> sourceList) {
        this.sourceList = sourceList;
    }

    public void setExecutor(ScheduledThreadPoolExecutor executor) {
        this.executor = executor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteJarService)) {
            return false;
        }
        RemoteJarService other = (RemoteJarService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApplicationProperties this$ap = this.getAp();
        ApplicationProperties other$ap = other.getAp();
        if (this$ap == null ? other$ap != null : !this$ap.equals(other$ap)) {
            return false;
        }
        OSS this$ossClient = this.getOssClient();
        OSS other$ossClient = other.getOssClient();
        if (this$ossClient == null ? other$ossClient != null : !this$ossClient.equals(other$ossClient)) {
            return false;
        }
        MinioClient this$minioClient = this.getMinioClient();
        MinioClient other$minioClient = other.getMinioClient();
        if (this$minioClient == null ? other$minioClient != null : !this$minioClient.equals(other$minioClient)) {
            return false;
        }
        File this$rootDirFile = this.getRootDirFile();
        File other$rootDirFile = other.getRootDirFile();
        if (this$rootDirFile == null ? other$rootDirFile != null : !((Object)this$rootDirFile).equals(other$rootDirFile)) {
            return false;
        }
        Map<String, Date> this$jarFileLastDownloadDate = this.getJarFileLastDownloadDate();
        Map<String, Date> other$jarFileLastDownloadDate = other.getJarFileLastDownloadDate();
        if (this$jarFileLastDownloadDate == null ? other$jarFileLastDownloadDate != null : !((Object)this$jarFileLastDownloadDate).equals(other$jarFileLastDownloadDate)) {
            return false;
        }
        List<String> this$sourceList = this.getSourceList();
        List<String> other$sourceList = other.getSourceList();
        if (this$sourceList == null ? other$sourceList != null : !((Object)this$sourceList).equals(other$sourceList)) {
            return false;
        }
        ScheduledThreadPoolExecutor this$executor = this.getExecutor();
        ScheduledThreadPoolExecutor other$executor = other.getExecutor();
        return !(this$executor == null ? other$executor != null : !this$executor.equals(other$executor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoteJarService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApplicationProperties $ap = this.getAp();
        result = result * 59 + ($ap == null ? 43 : $ap.hashCode());
        OSS $ossClient = this.getOssClient();
        result = result * 59 + ($ossClient == null ? 43 : $ossClient.hashCode());
        MinioClient $minioClient = this.getMinioClient();
        result = result * 59 + ($minioClient == null ? 43 : $minioClient.hashCode());
        File $rootDirFile = this.getRootDirFile();
        result = result * 59 + ($rootDirFile == null ? 43 : ((Object)$rootDirFile).hashCode());
        Map<String, Date> $jarFileLastDownloadDate = this.getJarFileLastDownloadDate();
        result = result * 59 + ($jarFileLastDownloadDate == null ? 43 : ((Object)$jarFileLastDownloadDate).hashCode());
        List<String> $sourceList = this.getSourceList();
        result = result * 59 + ($sourceList == null ? 43 : ((Object)$sourceList).hashCode());
        ScheduledThreadPoolExecutor $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        return result;
    }

    public String toString() {
        return "RemoteJarService(ap=" + this.getAp() + ", ossClient=" + this.getOssClient() + ", minioClient=" + this.getMinioClient() + ", rootDirFile=" + this.getRootDirFile() + ", jarFileLastDownloadDate=" + this.getJarFileLastDownloadDate() + ", sourceList=" + this.getSourceList() + ", executor=" + this.getExecutor() + ")";
    }
}

