/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.model.domain;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.common.BeanUtil;
import com.alibaba.tesla.dag.model.domain.AbstractTcDag;
import com.alibaba.tesla.dag.model.domain.TcDagNode;
import com.alibaba.tesla.dag.model.domain.TcDagOptions;
import com.alibaba.tesla.dag.model.domain.dag.DagInputParam;
import com.alibaba.tesla.dag.model.repository.TcDagNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagOptionsRepository;
import com.alibaba.tesla.dag.model.repository.TcDagRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.springframework.util.CollectionUtils;

@Table(uniqueConstraints={@UniqueConstraint(columnNames={"appId", "name"})})
@Entity
@EntityListeners(value={AuditingEntityListener.class})
public class TcDag
extends AbstractTcDag {
    private static final Logger log = LoggerFactory.getLogger(TcDag.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    private Long gmtCreate;
    @Column
    private Long gmtModified;
    @Column
    private String appId;
    @Column
    private String name;
    @Column
    private String alias;
    @Column(columnDefinition="longtext")
    private String content;
    @Column(columnDefinition="longtext")
    private String inputParams;
    @Column(columnDefinition="longtext")
    private Integer hasFeedback;
    @Column(columnDefinition="longtext")
    private Integer hasHistory;
    @Column(columnDefinition="longtext")
    private String description;
    @Column(columnDefinition="longtext")
    private String entity;
    @Column
    private String notice;
    @Column
    private String creator;
    @Column
    private String modifier;
    @Column
    private String lastUpdateBy;
    @Column
    private String exScheduleTaskId;
    @Column
    private Integer defaultShowHistory;

    public boolean defaultShowHistory() {
        return this.defaultShowHistory != null && 1 == this.defaultShowHistory;
    }

    public String alias() {
        return StringUtils.isEmpty((CharSequence)this.alias) ? this.name : this.alias;
    }

    public JSONObject contentJson() {
        JSONObject contentJson = JSONObject.parseObject((String)this.content);
        if (CollectionUtils.isEmpty((Map)contentJson)) {
            contentJson = new JSONObject();
            contentJson.put("nodes", (Object)new JSONArray());
            contentJson.put("edges", (Object)new JSONArray());
        }
        return contentJson;
    }

    public JSONObject preNode() {
        return this.contentJson().getJSONObject("__pre_node__");
    }

    public JSONObject postNode() {
        return this.contentJson().getJSONObject("__post_node__");
    }

    public List<JSONObject> nodes() {
        JSONArray nodeArray = this.contentJson().getJSONArray("nodes");
        if (nodeArray == null) {
            return new ArrayList<JSONObject>();
        }
        return nodeArray.toJavaList(JSONObject.class);
    }

    public void checkNodes() throws Exception {
        block8: for (JSONObject node : this.nodes()) {
            String type;
            JSONObject dataJson = node.getJSONObject("data");
            if (CollectionUtils.isEmpty((Map)dataJson)) {
                throw new Exception("data can not be null");
            }
            long defId = dataJson.getLongValue("defId");
            if (defId <= 0L) {
                throw new Exception("defId can not be negative");
            }
            switch (type = dataJson.getString("type")) {
                case "NODE": {
                    TcDagNode dagNode = BeanUtil.getBean(TcDagNodeRepository.class).findFirstById(defId);
                    if (dagNode != null) continue block8;
                    throw new Exception("can not find defid with dagNode: " + defId);
                }
                case "DAG": {
                    TcDag dag = BeanUtil.getBean(TcDagRepository.class).findFirstById(defId);
                    if (dag != null) continue block8;
                    throw new Exception("can not find defid with dag: " + defId);
                }
            }
            throw new Exception("no such type: " + type);
        }
    }

    public List<JSONObject> edges() {
        JSONArray nodeArray = this.contentJson().getJSONArray("edges");
        if (nodeArray == null) {
            return new ArrayList<JSONObject>();
        }
        return nodeArray.toJavaList(JSONObject.class);
    }

    public void setInputParams(String inputParams) {
        this.inputParams = inputParams;
    }

    public void setInputParams(List<DagInputParam> inputParams) throws Exception {
        inputParams = inputParams == null ? new ArrayList() : inputParams;
        for (DagInputParam inputParam : inputParams) {
            inputParam.check();
        }
        this.inputParams = JSONObject.toJSONString(inputParams, (boolean)true);
    }

    public List<DagInputParam> inputParams() {
        if (StringUtils.isEmpty((CharSequence)this.inputParams)) {
            return new ArrayList<DagInputParam>();
        }
        JSONArray jsonArray = JSONObject.parseArray((String)this.inputParams);
        if (CollectionUtils.isEmpty((Collection)jsonArray)) {
            return new ArrayList<DagInputParam>();
        }
        return jsonArray.toJavaList(DagInputParam.class);
    }

    public void addInputParam(DagInputParam inputParam) throws Exception {
        List<DagInputParam> inputParams = this.inputParams();
        for (DagInputParam param : inputParams) {
            if (!param.getName().equals(inputParam.getName())) continue;
            throw new Exception("name has already exists");
        }
        inputParams.add(inputParam);
        this.inputParams = JSONObject.toJSONString(inputParams);
        this.saveAndFlush();
    }

    public void deleteInputParam(String name) throws Exception {
        List<DagInputParam> inputParams = this.inputParams();
        ArrayList<DagInputParam> newInputParams = new ArrayList<DagInputParam>();
        for (DagInputParam param : inputParams) {
            if (param.getName().equals(name)) continue;
            newInputParams.add(param);
        }
        this.inputParams = JSONObject.toJSONString(newInputParams);
        this.saveAndFlush();
    }

    public void updateInputParam(DagInputParam inputParam) throws Exception {
        List<DagInputParam> inputParams = this.inputParams();
        for (int index = 0; index < inputParams.size(); ++index) {
            if (!inputParams.get(index).getName().equals(inputParam.getName())) continue;
            inputParams.set(index, inputParam);
        }
        this.inputParams = JSONObject.toJSONString(inputParams);
        this.saveAndFlush();
    }

    public void saveAndFlush() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            throw new Exception("name can not be null");
        }
        if (StringUtils.isEmpty((CharSequence)this.appId)) {
            throw new Exception("appId can not be null");
        }
        BeanUtil.getBean(TcDagRepository.class).saveAndFlush(this);
    }

    public void updateOptions() {
        this.updateOptions("zh_CN");
    }

    public void updateOptions(String locale) {
        TcDagOptions.builder().locale(locale).name(String.format("dag:%s:alias", this.id)).value(this.alias).build().upsert();
        TcDagOptions.builder().locale(locale).name(String.format("dag:%s:description", this.id)).value(this.description).build().upsert();
    }

    public void obtainOptions(String locale) {
        TcDagOptionsRepository dagOptionsRepository = BeanUtil.getBean(TcDagOptionsRepository.class);
        TcDagOptions dagOptions = dagOptionsRepository.findFirstByLocaleAndName(locale, String.format("dag:%s:alias", this.id));
        if (dagOptions != null) {
            this.alias = dagOptions.getValue();
        }
        if ((dagOptions = dagOptionsRepository.findFirstByLocaleAndName(locale, String.format("dag:%s:description", this.id))) != null) {
            this.description = dagOptions.getValue();
        }
    }

    public List<String> getFatherNodeIdListByNodeId(String nodeId) {
        List<String> nodeIdList = this.edges().stream().filter(x -> x.getString("target").equals(nodeId)).map(x -> x.getString("source")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(nodeIdList)) {
            nodeIdList = new ArrayList();
        }
        ArrayList copyList = new ArrayList(nodeIdList);
        for (String fatherNodeId : copyList) {
            for (String fNodeId : this.getFatherNodeIdListByNodeId(fatherNodeId)) {
                if (nodeIdList.contains(fNodeId)) continue;
                nodeIdList.add(fNodeId);
            }
        }
        return nodeIdList;
    }

    public JSONObject getNodeByNodeId(String nodeId) throws Exception {
        for (JSONObject node : this.nodes()) {
            if (!node.getString("id").equals(nodeId)) continue;
            return node;
        }
        throw new Exception("can not find by nodeId: " + nodeId);
    }

    public void upsertByAppIdAndName() throws Exception {
        TcDagRepository dagRepository;
        TcDag searchDag;
        if (this.id == null && (searchDag = (dagRepository = BeanUtil.getBean(TcDagRepository.class)).findFirstByAppIdAndName(this.appId, this.name)) != null) {
            this.gmtCreate = searchDag.getGmtCreate();
            this.id = searchDag.getId();
        }
        if (this.id == null) {
            this.setGmtCreate(System.currentTimeMillis() / 1000L);
            this.setGmtModified(System.currentTimeMillis() / 1000L);
        } else {
            this.setGmtModified(System.currentTimeMillis() / 1000L);
        }
        this.saveAndFlush();
    }

    @Override
    public void save() {
        BeanUtil.getBean(TcDagRepository.class).save(this);
    }

    @Override
    public void flush() {
        BeanUtil.getBean(TcDagRepository.class).flush();
    }

    public static TcDagBuilder builder() {
        return new TcDagBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TcDag)) {
            return false;
        }
        TcDag other = (TcDag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$gmtCreate = this.getGmtCreate();
        Long other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Long this$gmtModified = this.getGmtModified();
        Long other$gmtModified = other.getGmtModified();
        if (this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$inputParams = this.getInputParams();
        String other$inputParams = other.getInputParams();
        if (this$inputParams == null ? other$inputParams != null : !this$inputParams.equals(other$inputParams)) {
            return false;
        }
        Integer this$hasFeedback = this.getHasFeedback();
        Integer other$hasFeedback = other.getHasFeedback();
        if (this$hasFeedback == null ? other$hasFeedback != null : !((Object)this$hasFeedback).equals(other$hasFeedback)) {
            return false;
        }
        Integer this$hasHistory = this.getHasHistory();
        Integer other$hasHistory = other.getHasHistory();
        if (this$hasHistory == null ? other$hasHistory != null : !((Object)this$hasHistory).equals(other$hasHistory)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$entity = this.getEntity();
        String other$entity = other.getEntity();
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
            return false;
        }
        String this$notice = this.getNotice();
        String other$notice = other.getNotice();
        if (this$notice == null ? other$notice != null : !this$notice.equals(other$notice)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        String this$lastUpdateBy = this.getLastUpdateBy();
        String other$lastUpdateBy = other.getLastUpdateBy();
        if (this$lastUpdateBy == null ? other$lastUpdateBy != null : !this$lastUpdateBy.equals(other$lastUpdateBy)) {
            return false;
        }
        String this$exScheduleTaskId = this.getExScheduleTaskId();
        String other$exScheduleTaskId = other.getExScheduleTaskId();
        if (this$exScheduleTaskId == null ? other$exScheduleTaskId != null : !this$exScheduleTaskId.equals(other$exScheduleTaskId)) {
            return false;
        }
        Integer this$defaultShowHistory = this.getDefaultShowHistory();
        Integer other$defaultShowHistory = other.getDefaultShowHistory();
        return !(this$defaultShowHistory == null ? other$defaultShowHistory != null : !((Object)this$defaultShowHistory).equals(other$defaultShowHistory));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TcDag;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Long $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $inputParams = this.getInputParams();
        result = result * 59 + ($inputParams == null ? 43 : $inputParams.hashCode());
        Integer $hasFeedback = this.getHasFeedback();
        result = result * 59 + ($hasFeedback == null ? 43 : ((Object)$hasFeedback).hashCode());
        Integer $hasHistory = this.getHasHistory();
        result = result * 59 + ($hasHistory == null ? 43 : ((Object)$hasHistory).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        String $notice = this.getNotice();
        result = result * 59 + ($notice == null ? 43 : $notice.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        String $lastUpdateBy = this.getLastUpdateBy();
        result = result * 59 + ($lastUpdateBy == null ? 43 : $lastUpdateBy.hashCode());
        String $exScheduleTaskId = this.getExScheduleTaskId();
        result = result * 59 + ($exScheduleTaskId == null ? 43 : $exScheduleTaskId.hashCode());
        Integer $defaultShowHistory = this.getDefaultShowHistory();
        result = result * 59 + ($defaultShowHistory == null ? 43 : ((Object)$defaultShowHistory).hashCode());
        return result;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public Long getGmtCreate() {
        return this.gmtCreate;
    }

    @Override
    public Long getGmtModified() {
        return this.gmtModified;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getContent() {
        return this.content;
    }

    public String getInputParams() {
        return this.inputParams;
    }

    public Integer getHasFeedback() {
        return this.hasFeedback;
    }

    public Integer getHasHistory() {
        return this.hasHistory;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEntity() {
        return this.entity;
    }

    public String getNotice() {
        return this.notice;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    public String getExScheduleTaskId() {
        return this.exScheduleTaskId;
    }

    public Integer getDefaultShowHistory() {
        return this.defaultShowHistory;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setGmtCreate(Long gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    @Override
    public void setGmtModified(Long gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setHasFeedback(Integer hasFeedback) {
        this.hasFeedback = hasFeedback;
    }

    public void setHasHistory(Integer hasHistory) {
        this.hasHistory = hasHistory;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public void setNotice(String notice) {
        this.notice = notice;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setLastUpdateBy(String lastUpdateBy) {
        this.lastUpdateBy = lastUpdateBy;
    }

    public void setExScheduleTaskId(String exScheduleTaskId) {
        this.exScheduleTaskId = exScheduleTaskId;
    }

    public void setDefaultShowHistory(Integer defaultShowHistory) {
        this.defaultShowHistory = defaultShowHistory;
    }

    @Override
    public String toString() {
        return "TcDag(id=" + this.getId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ", appId=" + this.getAppId() + ", name=" + this.getName() + ", alias=" + this.getAlias() + ", content=" + this.getContent() + ", inputParams=" + this.getInputParams() + ", hasFeedback=" + this.getHasFeedback() + ", hasHistory=" + this.getHasHistory() + ", description=" + this.getDescription() + ", entity=" + this.getEntity() + ", notice=" + this.getNotice() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", lastUpdateBy=" + this.getLastUpdateBy() + ", exScheduleTaskId=" + this.getExScheduleTaskId() + ", defaultShowHistory=" + this.getDefaultShowHistory() + ")";
    }

    public TcDag(Long id, Long gmtCreate, Long gmtModified, String appId, String name, String alias, String content, String inputParams, Integer hasFeedback, Integer hasHistory, String description, String entity, String notice, String creator, String modifier, String lastUpdateBy, String exScheduleTaskId, Integer defaultShowHistory) {
        this.id = id;
        this.gmtCreate = gmtCreate;
        this.gmtModified = gmtModified;
        this.appId = appId;
        this.name = name;
        this.alias = alias;
        this.content = content;
        this.inputParams = inputParams;
        this.hasFeedback = hasFeedback;
        this.hasHistory = hasHistory;
        this.description = description;
        this.entity = entity;
        this.notice = notice;
        this.creator = creator;
        this.modifier = modifier;
        this.lastUpdateBy = lastUpdateBy;
        this.exScheduleTaskId = exScheduleTaskId;
        this.defaultShowHistory = defaultShowHistory;
    }

    public TcDag() {
    }

    public static class TcDagBuilder {
        private Long id;
        private Long gmtCreate;
        private Long gmtModified;
        private String appId;
        private String name;
        private String alias;
        private String content;
        private String inputParams;
        private Integer hasFeedback;
        private Integer hasHistory;
        private String description;
        private String entity;
        private String notice;
        private String creator;
        private String modifier;
        private String lastUpdateBy;
        private String exScheduleTaskId;
        private Integer defaultShowHistory;

        TcDagBuilder() {
        }

        public TcDagBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public TcDagBuilder gmtCreate(Long gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public TcDagBuilder gmtModified(Long gmtModified) {
            this.gmtModified = gmtModified;
            return this;
        }

        public TcDagBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public TcDagBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TcDagBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public TcDagBuilder content(String content) {
            this.content = content;
            return this;
        }

        public TcDagBuilder inputParams(String inputParams) {
            this.inputParams = inputParams;
            return this;
        }

        public TcDagBuilder hasFeedback(Integer hasFeedback) {
            this.hasFeedback = hasFeedback;
            return this;
        }

        public TcDagBuilder hasHistory(Integer hasHistory) {
            this.hasHistory = hasHistory;
            return this;
        }

        public TcDagBuilder description(String description) {
            this.description = description;
            return this;
        }

        public TcDagBuilder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public TcDagBuilder notice(String notice) {
            this.notice = notice;
            return this;
        }

        public TcDagBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public TcDagBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public TcDagBuilder lastUpdateBy(String lastUpdateBy) {
            this.lastUpdateBy = lastUpdateBy;
            return this;
        }

        public TcDagBuilder exScheduleTaskId(String exScheduleTaskId) {
            this.exScheduleTaskId = exScheduleTaskId;
            return this;
        }

        public TcDagBuilder defaultShowHistory(Integer defaultShowHistory) {
            this.defaultShowHistory = defaultShowHistory;
            return this;
        }

        public TcDag build() {
            return new TcDag(this.id, this.gmtCreate, this.gmtModified, this.appId, this.name, this.alias, this.content, this.inputParams, this.hasFeedback, this.hasHistory, this.description, this.entity, this.notice, this.creator, this.modifier, this.lastUpdateBy, this.exScheduleTaskId, this.defaultShowHistory);
        }

        public String toString() {
            return "TcDag.TcDagBuilder(id=" + this.id + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + ", appId=" + this.appId + ", name=" + this.name + ", alias=" + this.alias + ", content=" + this.content + ", inputParams=" + this.inputParams + ", hasFeedback=" + this.hasFeedback + ", hasHistory=" + this.hasHistory + ", description=" + this.description + ", entity=" + this.entity + ", notice=" + this.notice + ", creator=" + this.creator + ", modifier=" + this.modifier + ", lastUpdateBy=" + this.lastUpdateBy + ", exScheduleTaskId=" + this.exScheduleTaskId + ", defaultShowHistory=" + this.defaultShowHistory + ")";
        }
    }
}

