/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.model.domain;

import com.alibaba.fastjson.util.TypeUtils;
import com.alibaba.tesla.dag.common.BeanUtil;
import com.alibaba.tesla.dag.model.domain.AbstractTcDag;
import com.alibaba.tesla.dag.model.repository.TcDagConfigRepository;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Table
@Entity
@EntityListeners(value={AuditingEntityListener.class})
public class TcDagConfig
extends AbstractTcDag {
    private static final Logger log = LoggerFactory.getLogger(TcDagConfig.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    private Long gmtCreate;
    @Column
    private Long gmtModified;
    @Column
    private String name;
    @Column
    private String content;

    public Integer getInteger(Integer defaultContent) {
        Integer ret = TypeUtils.castToInt((Object)this.content);
        return ret == null ? defaultContent : ret;
    }

    public Long getLong(Long defaultContent) {
        Long ret = TypeUtils.castToLong((Object)this.content);
        return ret == null ? defaultContent : ret;
    }

    public static Long getLong(String name) {
        TcDagConfigRepository configRepository = BeanUtil.getBean(TcDagConfigRepository.class);
        TcDagConfig dagConfig = configRepository.findFirstByName(name);
        if (dagConfig == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)dagConfig.content)) {
            return null;
        }
        return TypeUtils.castToLong((Object)dagConfig.content);
    }

    public static Long getLong(String name, Long d) {
        TcDagConfigRepository configRepository = BeanUtil.getBean(TcDagConfigRepository.class);
        TcDagConfig dagConfig = configRepository.findFirstByName(name);
        if (dagConfig == null) {
            return d;
        }
        return dagConfig.getLong(d);
    }

    public static Integer getInteger(String name, Integer d) {
        TcDagConfigRepository configRepository = BeanUtil.getBean(TcDagConfigRepository.class);
        TcDagConfig dagConfig = configRepository.findFirstByName(name);
        if (dagConfig == null) {
            return d;
        }
        return dagConfig.getInteger(d);
    }

    @Override
    public void save() {
        BeanUtil.getBean(TcDagConfigRepository.class).save(this);
    }

    @Override
    public void flush() {
        BeanUtil.getBean(TcDagConfigRepository.class).flush();
    }

    public static TcDagConfigBuilder builder() {
        return new TcDagConfigBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TcDagConfig)) {
            return false;
        }
        TcDagConfig other = (TcDagConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$gmtCreate = this.getGmtCreate();
        Long other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Long this$gmtModified = this.getGmtModified();
        Long other$gmtModified = other.getGmtModified();
        if (this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TcDagConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Long $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public Long getGmtCreate() {
        return this.gmtCreate;
    }

    @Override
    public Long getGmtModified() {
        return this.gmtModified;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setGmtCreate(Long gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    @Override
    public void setGmtModified(Long gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public String toString() {
        return "TcDagConfig(id=" + this.getId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ", name=" + this.getName() + ", content=" + this.getContent() + ")";
    }

    public TcDagConfig(Long id, Long gmtCreate, Long gmtModified, String name, String content) {
        this.id = id;
        this.gmtCreate = gmtCreate;
        this.gmtModified = gmtModified;
        this.name = name;
        this.content = content;
    }

    public TcDagConfig() {
    }

    public static class TcDagConfigBuilder {
        private Long id;
        private Long gmtCreate;
        private Long gmtModified;
        private String name;
        private String content;

        TcDagConfigBuilder() {
        }

        public TcDagConfigBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public TcDagConfigBuilder gmtCreate(Long gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public TcDagConfigBuilder gmtModified(Long gmtModified) {
            this.gmtModified = gmtModified;
            return this;
        }

        public TcDagConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TcDagConfigBuilder content(String content) {
            this.content = content;
            return this;
        }

        public TcDagConfig build() {
            return new TcDagConfig(this.id, this.gmtCreate, this.gmtModified, this.name, this.content);
        }

        public String toString() {
            return "TcDagConfig.TcDagConfigBuilder(id=" + this.id + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + ", name=" + this.name + ", content=" + this.content + ")";
        }
    }
}

