/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.model.domain;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.common.BeanUtil;
import com.alibaba.tesla.dag.model.domain.AbstractTcDag;
import com.alibaba.tesla.dag.model.domain.TcDag;
import com.alibaba.tesla.dag.model.domain.TcDagInstNode;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstRepository;
import com.alibaba.tesla.dag.schedule.status.DagInstNodeStatus;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Table
@Entity
@EntityListeners(value={AuditingEntityListener.class})
public class TcDagInst
extends AbstractTcDag {
    private static final Logger log = LoggerFactory.getLogger(TcDagInst.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    private Long gmtCreate;
    @Column
    private Long gmtModified;
    @Column
    private Long gmtAccess;
    @Column
    private String appId;
    @Column
    private Long dagId;
    @Column(columnDefinition="longtext")
    private String tcDagDetail;
    @Column
    private String status;
    @Column(columnDefinition="longtext")
    private String statusDetail;
    @Column(columnDefinition="longtext")
    private String globalParams;
    @Column(columnDefinition="longtext")
    private String globalObject;
    @Column(columnDefinition="longtext")
    private String globalVariable;
    @Column(columnDefinition="longtext")
    private String globalResult;
    @Column
    private String lockId;
    @Column
    private String creator;
    @Column
    private Integer isSub;
    @Column
    private String tag;
    @Column
    private String standaloneIp;
    @Column(columnDefinition="longtext")
    private String evaluationCreateRet;
    @Column
    private String channel;
    @Column
    private String env;
    @Transient
    private TcDag dag;

    public void setNodeId(String nodeId) {
        JSONObject globalVariableJson = this.globalVariableJson();
        globalVariableJson.put("__NODE__ID__", (Object)nodeId);
        this.globalVariable = JSONObject.toJSONString((Object)globalVariableJson);
    }

    public String nodeId() {
        return this.globalVariableJson().getString("__NODE__ID__");
    }

    public TcDag dag() {
        if (this.dag == null) {
            this.dag = (TcDag)JSONObject.parseObject((String)this.tcDagDetail, TcDag.class);
        }
        return this.dag;
    }

    public String channel() {
        if (StringUtils.isEmpty((CharSequence)this.channel)) {
            return "NotDefined";
        }
        return this.channel;
    }

    public DagInstStatus status() {
        return DagInstStatus.valueOf(this.status);
    }

    public boolean isSub() {
        return this.isSub == 1;
    }

    public JSONObject globalVariableJson() {
        return StringUtils.isEmpty((CharSequence)this.globalVariable) ? new JSONObject() : JSONObject.parseObject((String)this.globalVariable);
    }

    public JSONObject globalParamsJson() {
        return StringUtils.isEmpty((CharSequence)this.globalParams) ? new JSONObject() : JSONObject.parseObject((String)this.globalParams);
    }

    public JSONObject globalResultJson() {
        return StringUtils.isEmpty((CharSequence)this.globalResult) ? new JSONObject() : JSONObject.parseObject((String)this.globalResult);
    }

    public void saveAndFlush() {
        BeanUtil.getBean(TcDagInstRepository.class).saveAndFlush(this);
    }

    public List<TcDagInstNode> nodes(DagInstNodeStatus ... statusList) {
        return BeanUtil.getBean(TcDagInstNodeRepository.class).findAllByDagInstIdAndNodeIdNotInAndStatusIn(this.id, Arrays.asList("__pre_node__", "__post_node__"), Arrays.stream(statusList).map(Enum::toString).collect(Collectors.toList()));
    }

    public List<TcDagInstNode> nodes() {
        return BeanUtil.getBean(TcDagInstNodeRepository.class).findAllByDagInstIdAndNodeIdNotIn(this.id, Arrays.asList("__pre_node__", "__post_node__"));
    }

    public TcDagInstNode postNode() {
        return BeanUtil.getBean(TcDagInstNodeRepository.class).findFirstByDagInstIdAndNodeId(this.id, "__post_node__");
    }

    @Override
    public void save() {
        BeanUtil.getBean(TcDagInstRepository.class).save(this);
    }

    @Override
    public void flush() {
        BeanUtil.getBean(TcDagInstRepository.class).flush();
    }

    public static TcDagInstBuilder builder() {
        return new TcDagInstBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TcDagInst)) {
            return false;
        }
        TcDagInst other = (TcDagInst)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$gmtCreate = this.getGmtCreate();
        Long other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Long this$gmtModified = this.getGmtModified();
        Long other$gmtModified = other.getGmtModified();
        if (this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified)) {
            return false;
        }
        Long this$gmtAccess = this.getGmtAccess();
        Long other$gmtAccess = other.getGmtAccess();
        if (this$gmtAccess == null ? other$gmtAccess != null : !((Object)this$gmtAccess).equals(other$gmtAccess)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        Long this$dagId = this.getDagId();
        Long other$dagId = other.getDagId();
        if (this$dagId == null ? other$dagId != null : !((Object)this$dagId).equals(other$dagId)) {
            return false;
        }
        String this$tcDagDetail = this.getTcDagDetail();
        String other$tcDagDetail = other.getTcDagDetail();
        if (this$tcDagDetail == null ? other$tcDagDetail != null : !this$tcDagDetail.equals(other$tcDagDetail)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$statusDetail = this.getStatusDetail();
        String other$statusDetail = other.getStatusDetail();
        if (this$statusDetail == null ? other$statusDetail != null : !this$statusDetail.equals(other$statusDetail)) {
            return false;
        }
        String this$globalParams = this.getGlobalParams();
        String other$globalParams = other.getGlobalParams();
        if (this$globalParams == null ? other$globalParams != null : !this$globalParams.equals(other$globalParams)) {
            return false;
        }
        String this$globalObject = this.getGlobalObject();
        String other$globalObject = other.getGlobalObject();
        if (this$globalObject == null ? other$globalObject != null : !this$globalObject.equals(other$globalObject)) {
            return false;
        }
        String this$globalVariable = this.getGlobalVariable();
        String other$globalVariable = other.getGlobalVariable();
        if (this$globalVariable == null ? other$globalVariable != null : !this$globalVariable.equals(other$globalVariable)) {
            return false;
        }
        String this$globalResult = this.getGlobalResult();
        String other$globalResult = other.getGlobalResult();
        if (this$globalResult == null ? other$globalResult != null : !this$globalResult.equals(other$globalResult)) {
            return false;
        }
        String this$lockId = this.getLockId();
        String other$lockId = other.getLockId();
        if (this$lockId == null ? other$lockId != null : !this$lockId.equals(other$lockId)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        Integer this$isSub = this.getIsSub();
        Integer other$isSub = other.getIsSub();
        if (this$isSub == null ? other$isSub != null : !((Object)this$isSub).equals(other$isSub)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$standaloneIp = this.getStandaloneIp();
        String other$standaloneIp = other.getStandaloneIp();
        if (this$standaloneIp == null ? other$standaloneIp != null : !this$standaloneIp.equals(other$standaloneIp)) {
            return false;
        }
        String this$evaluationCreateRet = this.getEvaluationCreateRet();
        String other$evaluationCreateRet = other.getEvaluationCreateRet();
        if (this$evaluationCreateRet == null ? other$evaluationCreateRet != null : !this$evaluationCreateRet.equals(other$evaluationCreateRet)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        String this$env = this.getEnv();
        String other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        TcDag this$dag = this.getDag();
        TcDag other$dag = other.getDag();
        return !(this$dag == null ? other$dag != null : !((Object)this$dag).equals(other$dag));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TcDagInst;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Long $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        Long $gmtAccess = this.getGmtAccess();
        result = result * 59 + ($gmtAccess == null ? 43 : ((Object)$gmtAccess).hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        Long $dagId = this.getDagId();
        result = result * 59 + ($dagId == null ? 43 : ((Object)$dagId).hashCode());
        String $tcDagDetail = this.getTcDagDetail();
        result = result * 59 + ($tcDagDetail == null ? 43 : $tcDagDetail.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $statusDetail = this.getStatusDetail();
        result = result * 59 + ($statusDetail == null ? 43 : $statusDetail.hashCode());
        String $globalParams = this.getGlobalParams();
        result = result * 59 + ($globalParams == null ? 43 : $globalParams.hashCode());
        String $globalObject = this.getGlobalObject();
        result = result * 59 + ($globalObject == null ? 43 : $globalObject.hashCode());
        String $globalVariable = this.getGlobalVariable();
        result = result * 59 + ($globalVariable == null ? 43 : $globalVariable.hashCode());
        String $globalResult = this.getGlobalResult();
        result = result * 59 + ($globalResult == null ? 43 : $globalResult.hashCode());
        String $lockId = this.getLockId();
        result = result * 59 + ($lockId == null ? 43 : $lockId.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        Integer $isSub = this.getIsSub();
        result = result * 59 + ($isSub == null ? 43 : ((Object)$isSub).hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $standaloneIp = this.getStandaloneIp();
        result = result * 59 + ($standaloneIp == null ? 43 : $standaloneIp.hashCode());
        String $evaluationCreateRet = this.getEvaluationCreateRet();
        result = result * 59 + ($evaluationCreateRet == null ? 43 : $evaluationCreateRet.hashCode());
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        String $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        TcDag $dag = this.getDag();
        result = result * 59 + ($dag == null ? 43 : ((Object)$dag).hashCode());
        return result;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public Long getGmtCreate() {
        return this.gmtCreate;
    }

    @Override
    public Long getGmtModified() {
        return this.gmtModified;
    }

    public Long getGmtAccess() {
        return this.gmtAccess;
    }

    public String getAppId() {
        return this.appId;
    }

    public Long getDagId() {
        return this.dagId;
    }

    public String getTcDagDetail() {
        return this.tcDagDetail;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStatusDetail() {
        return this.statusDetail;
    }

    public String getGlobalParams() {
        return this.globalParams;
    }

    public String getGlobalObject() {
        return this.globalObject;
    }

    public String getGlobalVariable() {
        return this.globalVariable;
    }

    public String getGlobalResult() {
        return this.globalResult;
    }

    public String getLockId() {
        return this.lockId;
    }

    public String getCreator() {
        return this.creator;
    }

    public Integer getIsSub() {
        return this.isSub;
    }

    public String getTag() {
        return this.tag;
    }

    public String getStandaloneIp() {
        return this.standaloneIp;
    }

    public String getEvaluationCreateRet() {
        return this.evaluationCreateRet;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getEnv() {
        return this.env;
    }

    public TcDag getDag() {
        return this.dag;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setGmtCreate(Long gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    @Override
    public void setGmtModified(Long gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void setGmtAccess(Long gmtAccess) {
        this.gmtAccess = gmtAccess;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setDagId(Long dagId) {
        this.dagId = dagId;
    }

    public void setTcDagDetail(String tcDagDetail) {
        this.tcDagDetail = tcDagDetail;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStatusDetail(String statusDetail) {
        this.statusDetail = statusDetail;
    }

    public void setGlobalParams(String globalParams) {
        this.globalParams = globalParams;
    }

    public void setGlobalObject(String globalObject) {
        this.globalObject = globalObject;
    }

    public void setGlobalVariable(String globalVariable) {
        this.globalVariable = globalVariable;
    }

    public void setGlobalResult(String globalResult) {
        this.globalResult = globalResult;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setIsSub(Integer isSub) {
        this.isSub = isSub;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setStandaloneIp(String standaloneIp) {
        this.standaloneIp = standaloneIp;
    }

    public void setEvaluationCreateRet(String evaluationCreateRet) {
        this.evaluationCreateRet = evaluationCreateRet;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public void setDag(TcDag dag) {
        this.dag = dag;
    }

    @Override
    public String toString() {
        return "TcDagInst(id=" + this.getId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ", gmtAccess=" + this.getGmtAccess() + ", appId=" + this.getAppId() + ", dagId=" + this.getDagId() + ", tcDagDetail=" + this.getTcDagDetail() + ", status=" + this.getStatus() + ", statusDetail=" + this.getStatusDetail() + ", globalParams=" + this.getGlobalParams() + ", globalObject=" + this.getGlobalObject() + ", globalVariable=" + this.getGlobalVariable() + ", globalResult=" + this.getGlobalResult() + ", lockId=" + this.getLockId() + ", creator=" + this.getCreator() + ", isSub=" + this.getIsSub() + ", tag=" + this.getTag() + ", standaloneIp=" + this.getStandaloneIp() + ", evaluationCreateRet=" + this.getEvaluationCreateRet() + ", channel=" + this.getChannel() + ", env=" + this.getEnv() + ", dag=" + this.getDag() + ")";
    }

    public TcDagInst(Long id, Long gmtCreate, Long gmtModified, Long gmtAccess, String appId, Long dagId, String tcDagDetail, String status, String statusDetail, String globalParams, String globalObject, String globalVariable, String globalResult, String lockId, String creator, Integer isSub, String tag, String standaloneIp, String evaluationCreateRet, String channel, String env, TcDag dag) {
        this.id = id;
        this.gmtCreate = gmtCreate;
        this.gmtModified = gmtModified;
        this.gmtAccess = gmtAccess;
        this.appId = appId;
        this.dagId = dagId;
        this.tcDagDetail = tcDagDetail;
        this.status = status;
        this.statusDetail = statusDetail;
        this.globalParams = globalParams;
        this.globalObject = globalObject;
        this.globalVariable = globalVariable;
        this.globalResult = globalResult;
        this.lockId = lockId;
        this.creator = creator;
        this.isSub = isSub;
        this.tag = tag;
        this.standaloneIp = standaloneIp;
        this.evaluationCreateRet = evaluationCreateRet;
        this.channel = channel;
        this.env = env;
        this.dag = dag;
    }

    public TcDagInst() {
    }

    public static class TcDagInstBuilder {
        private Long id;
        private Long gmtCreate;
        private Long gmtModified;
        private Long gmtAccess;
        private String appId;
        private Long dagId;
        private String tcDagDetail;
        private String status;
        private String statusDetail;
        private String globalParams;
        private String globalObject;
        private String globalVariable;
        private String globalResult;
        private String lockId;
        private String creator;
        private Integer isSub;
        private String tag;
        private String standaloneIp;
        private String evaluationCreateRet;
        private String channel;
        private String env;
        private TcDag dag;

        TcDagInstBuilder() {
        }

        public TcDagInstBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public TcDagInstBuilder gmtCreate(Long gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public TcDagInstBuilder gmtModified(Long gmtModified) {
            this.gmtModified = gmtModified;
            return this;
        }

        public TcDagInstBuilder gmtAccess(Long gmtAccess) {
            this.gmtAccess = gmtAccess;
            return this;
        }

        public TcDagInstBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public TcDagInstBuilder dagId(Long dagId) {
            this.dagId = dagId;
            return this;
        }

        public TcDagInstBuilder tcDagDetail(String tcDagDetail) {
            this.tcDagDetail = tcDagDetail;
            return this;
        }

        public TcDagInstBuilder status(String status) {
            this.status = status;
            return this;
        }

        public TcDagInstBuilder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        public TcDagInstBuilder globalParams(String globalParams) {
            this.globalParams = globalParams;
            return this;
        }

        public TcDagInstBuilder globalObject(String globalObject) {
            this.globalObject = globalObject;
            return this;
        }

        public TcDagInstBuilder globalVariable(String globalVariable) {
            this.globalVariable = globalVariable;
            return this;
        }

        public TcDagInstBuilder globalResult(String globalResult) {
            this.globalResult = globalResult;
            return this;
        }

        public TcDagInstBuilder lockId(String lockId) {
            this.lockId = lockId;
            return this;
        }

        public TcDagInstBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public TcDagInstBuilder isSub(Integer isSub) {
            this.isSub = isSub;
            return this;
        }

        public TcDagInstBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public TcDagInstBuilder standaloneIp(String standaloneIp) {
            this.standaloneIp = standaloneIp;
            return this;
        }

        public TcDagInstBuilder evaluationCreateRet(String evaluationCreateRet) {
            this.evaluationCreateRet = evaluationCreateRet;
            return this;
        }

        public TcDagInstBuilder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public TcDagInstBuilder env(String env) {
            this.env = env;
            return this;
        }

        public TcDagInstBuilder dag(TcDag dag) {
            this.dag = dag;
            return this;
        }

        public TcDagInst build() {
            return new TcDagInst(this.id, this.gmtCreate, this.gmtModified, this.gmtAccess, this.appId, this.dagId, this.tcDagDetail, this.status, this.statusDetail, this.globalParams, this.globalObject, this.globalVariable, this.globalResult, this.lockId, this.creator, this.isSub, this.tag, this.standaloneIp, this.evaluationCreateRet, this.channel, this.env, this.dag);
        }

        public String toString() {
            return "TcDagInst.TcDagInstBuilder(id=" + this.id + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + ", gmtAccess=" + this.gmtAccess + ", appId=" + this.appId + ", dagId=" + this.dagId + ", tcDagDetail=" + this.tcDagDetail + ", status=" + this.status + ", statusDetail=" + this.statusDetail + ", globalParams=" + this.globalParams + ", globalObject=" + this.globalObject + ", globalVariable=" + this.globalVariable + ", globalResult=" + this.globalResult + ", lockId=" + this.lockId + ", creator=" + this.creator + ", isSub=" + this.isSub + ", tag=" + this.tag + ", standaloneIp=" + this.standaloneIp + ", evaluationCreateRet=" + this.evaluationCreateRet + ", channel=" + this.channel + ", env=" + this.env + ", dag=" + this.dag + ")";
        }
    }
}

