/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.model.domain;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.common.BeanUtil;
import com.alibaba.tesla.dag.model.domain.AbstractTcDag;
import com.alibaba.tesla.dag.model.domain.TcDagInst;
import com.alibaba.tesla.dag.model.domain.TcDagInstNode;
import com.alibaba.tesla.dag.model.repository.TcDagInstEdgeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstRepository;
import com.alibaba.tesla.dag.schedule.status.DagInstEdgeStatus;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Table
@Entity
@EntityListeners(value={AuditingEntityListener.class})
public class TcDagInstEdge
extends AbstractTcDag {
    private static final Logger log = LoggerFactory.getLogger(TcDagInstEdge.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public Long id;
    @Column
    public Long gmtCreate;
    @Column
    public Long gmtModified;
    @Column
    public Long dagInstId;
    @Column
    public String source;
    @Column
    public String target;
    @Column
    public String label;
    @Column
    public String shape;
    @Column(columnDefinition="longtext")
    public String style;
    @Column(columnDefinition="longtext")
    public String data;
    @Column
    public Integer isPass;
    @Column(columnDefinition="longtext")
    public String exception;
    @Column
    public String status;

    public DagInstEdgeStatus status() {
        this.status = StringUtils.isEmpty((CharSequence)this.status) ? "INIT" : this.status;
        return DagInstEdgeStatus.valueOf(this.status);
    }

    public String getException() {
        if (this.isPass == null) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)this.exception)) {
            return "SUCCESS";
        }
        return "EXCEPTION";
    }

    public JSONObject dataJson() {
        return StringUtils.isEmpty((CharSequence)this.data) ? new JSONObject() : JSONObject.parseObject((String)this.data);
    }

    public String expression() {
        return this.dataJson().getString("expression");
    }

    public TcDagInst dagInst() {
        return BeanUtil.getBean(TcDagInstRepository.class).findFirstById(this.dagInstId);
    }

    public TcDagInstNode sourceNode() {
        return BeanUtil.getBean(TcDagInstNodeRepository.class).findFirstByDagInstIdAndNodeId(this.dagInstId, this.source);
    }

    public void saveAndFlush() {
        BeanUtil.getBean(TcDagInstEdgeRepository.class).saveAndFlush(this);
    }

    @Override
    public void save() {
        BeanUtil.getBean(TcDagInstEdgeRepository.class).save(this);
    }

    @Override
    public void flush() {
        BeanUtil.getBean(TcDagInstEdgeRepository.class).flush();
    }

    public static TcDagInstEdgeBuilder builder() {
        return new TcDagInstEdgeBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TcDagInstEdge)) {
            return false;
        }
        TcDagInstEdge other = (TcDagInstEdge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$gmtCreate = this.getGmtCreate();
        Long other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Long this$gmtModified = this.getGmtModified();
        Long other$gmtModified = other.getGmtModified();
        if (this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified)) {
            return false;
        }
        Long this$dagInstId = this.getDagInstId();
        Long other$dagInstId = other.getDagInstId();
        if (this$dagInstId == null ? other$dagInstId != null : !((Object)this$dagInstId).equals(other$dagInstId)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$shape = this.getShape();
        String other$shape = other.getShape();
        if (this$shape == null ? other$shape != null : !this$shape.equals(other$shape)) {
            return false;
        }
        String this$style = this.getStyle();
        String other$style = other.getStyle();
        if (this$style == null ? other$style != null : !this$style.equals(other$style)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Integer this$isPass = this.getIsPass();
        Integer other$isPass = other.getIsPass();
        if (this$isPass == null ? other$isPass != null : !((Object)this$isPass).equals(other$isPass)) {
            return false;
        }
        String this$exception = this.getException();
        String other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TcDagInstEdge;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Long $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        Long $dagInstId = this.getDagInstId();
        result = result * 59 + ($dagInstId == null ? 43 : ((Object)$dagInstId).hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $shape = this.getShape();
        result = result * 59 + ($shape == null ? 43 : $shape.hashCode());
        String $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Integer $isPass = this.getIsPass();
        result = result * 59 + ($isPass == null ? 43 : ((Object)$isPass).hashCode());
        String $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public Long getGmtCreate() {
        return this.gmtCreate;
    }

    @Override
    public Long getGmtModified() {
        return this.gmtModified;
    }

    public Long getDagInstId() {
        return this.dagInstId;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public String getLabel() {
        return this.label;
    }

    public String getShape() {
        return this.shape;
    }

    public String getStyle() {
        return this.style;
    }

    public String getData() {
        return this.data;
    }

    public Integer getIsPass() {
        return this.isPass;
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setGmtCreate(Long gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    @Override
    public void setGmtModified(Long gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void setDagInstId(Long dagInstId) {
        this.dagInstId = dagInstId;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setShape(String shape) {
        this.shape = shape;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setIsPass(Integer isPass) {
        this.isPass = isPass;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "TcDagInstEdge(id=" + this.getId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ", dagInstId=" + this.getDagInstId() + ", source=" + this.getSource() + ", target=" + this.getTarget() + ", label=" + this.getLabel() + ", shape=" + this.getShape() + ", style=" + this.getStyle() + ", data=" + this.getData() + ", isPass=" + this.getIsPass() + ", exception=" + this.getException() + ", status=" + this.getStatus() + ")";
    }

    public TcDagInstEdge(Long id, Long gmtCreate, Long gmtModified, Long dagInstId, String source, String target, String label, String shape, String style, String data, Integer isPass, String exception, String status) {
        this.id = id;
        this.gmtCreate = gmtCreate;
        this.gmtModified = gmtModified;
        this.dagInstId = dagInstId;
        this.source = source;
        this.target = target;
        this.label = label;
        this.shape = shape;
        this.style = style;
        this.data = data;
        this.isPass = isPass;
        this.exception = exception;
        this.status = status;
    }

    public TcDagInstEdge() {
    }

    public static class TcDagInstEdgeBuilder {
        private Long id;
        private Long gmtCreate;
        private Long gmtModified;
        private Long dagInstId;
        private String source;
        private String target;
        private String label;
        private String shape;
        private String style;
        private String data;
        private Integer isPass;
        private String exception;
        private String status;

        TcDagInstEdgeBuilder() {
        }

        public TcDagInstEdgeBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public TcDagInstEdgeBuilder gmtCreate(Long gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public TcDagInstEdgeBuilder gmtModified(Long gmtModified) {
            this.gmtModified = gmtModified;
            return this;
        }

        public TcDagInstEdgeBuilder dagInstId(Long dagInstId) {
            this.dagInstId = dagInstId;
            return this;
        }

        public TcDagInstEdgeBuilder source(String source) {
            this.source = source;
            return this;
        }

        public TcDagInstEdgeBuilder target(String target) {
            this.target = target;
            return this;
        }

        public TcDagInstEdgeBuilder label(String label) {
            this.label = label;
            return this;
        }

        public TcDagInstEdgeBuilder shape(String shape) {
            this.shape = shape;
            return this;
        }

        public TcDagInstEdgeBuilder style(String style) {
            this.style = style;
            return this;
        }

        public TcDagInstEdgeBuilder data(String data) {
            this.data = data;
            return this;
        }

        public TcDagInstEdgeBuilder isPass(Integer isPass) {
            this.isPass = isPass;
            return this;
        }

        public TcDagInstEdgeBuilder exception(String exception) {
            this.exception = exception;
            return this;
        }

        public TcDagInstEdgeBuilder status(String status) {
            this.status = status;
            return this;
        }

        public TcDagInstEdge build() {
            return new TcDagInstEdge(this.id, this.gmtCreate, this.gmtModified, this.dagInstId, this.source, this.target, this.label, this.shape, this.style, this.data, this.isPass, this.exception, this.status);
        }

        public String toString() {
            return "TcDagInstEdge.TcDagInstEdgeBuilder(id=" + this.id + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + ", dagInstId=" + this.dagInstId + ", source=" + this.source + ", target=" + this.target + ", label=" + this.label + ", shape=" + this.shape + ", style=" + this.style + ", data=" + this.data + ", isPass=" + this.isPass + ", exception=" + this.exception + ", status=" + this.status + ")";
        }
    }
}

