/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.model.domain;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.common.BeanUtil;
import com.alibaba.tesla.dag.model.domain.AbstractTcDag;
import com.alibaba.tesla.dag.model.domain.TcDagInst;
import com.alibaba.tesla.dag.model.domain.TcDagInstEdge;
import com.alibaba.tesla.dag.model.domain.TcDagInstNodeStd;
import com.alibaba.tesla.dag.model.domain.TcDagNode;
import com.alibaba.tesla.dag.model.domain.dagnode.DagInstNodeType;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeInputParam;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeOutputParam;
import com.alibaba.tesla.dag.model.repository.TcDagInstEdgeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeStdRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstRepository;
import com.alibaba.tesla.dag.model.repository.TcDagNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagRepository;
import com.alibaba.tesla.dag.schedule.status.DagInstNodeStatus;
import com.alibaba.tesla.dag.services.LocalActionNewService;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.springframework.util.CollectionUtils;

@Table
@Entity
@EntityListeners(value={AuditingEntityListener.class})
public class TcDagInstNode
extends AbstractTcDag {
    private static final Logger log = LoggerFactory.getLogger(TcDagInstNode.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    private Long gmtCreate;
    @Column
    private Long gmtModified;
    @Column
    private Long gmtStart;
    @Column
    private Long dagInstId;
    @Column
    private String nodeId;
    @Column
    private String status;
    @Column(columnDefinition="longtext")
    private String statusDetail;
    @Column
    private String taskId;
    @Column
    private String stopTaskId;
    @Column
    private String lockId;
    @Column
    private Long subDagInstId;
    @Column
    private Long retryTimes;
    @Column(columnDefinition="longtext")
    private String tcDagOrNodeDetail;
    @Column(columnDefinition="longtext")
    private String tcDagContentNodeSpec;
    @Transient
    private JSONObject tcDagContentNodeSpecJson;
    @Transient
    private TcDagNode dagNode;
    @Transient
    private JSONObject outJsonWithCache;

    public long retryTimes() {
        return this.retryTimes == null ? 0L : this.retryTimes;
    }

    public TcDagInstNode updateTcDagOrNodeDetail(JSONObject nodeJson) {
        switch (this.type()) {
            case NODE: {
                TcDagNode dagNode = BeanUtil.getBean(TcDagNodeRepository.class).findFirstById(this.defId());
                String formatType = nodeJson.getJSONObject("data").getString("format_type");
                String formatDetail = nodeJson.getJSONObject("data").getString("format_detail");
                Long maxRetryTimes = nodeJson.getJSONObject("data").getLong("maxRetryTimes");
                String retryExpression = nodeJson.getJSONObject("data").getString("retryExpression");
                Integer runTimeout = nodeJson.getJSONObject("data").getInteger("runTimeout");
                if (StringUtils.isNotEmpty((CharSequence)formatType)) {
                    dagNode.setFormatType(formatType);
                }
                if (StringUtils.isNotEmpty((CharSequence)formatDetail)) {
                    dagNode.setFormatDetail(formatDetail);
                }
                if (maxRetryTimes != null) {
                    dagNode.setMaxRetryTimes(maxRetryTimes);
                }
                if (retryExpression != null) {
                    dagNode.setRetryExpression(retryExpression);
                }
                if (runTimeout != null) {
                    dagNode.setRunTimeout(runTimeout);
                }
                this.tcDagOrNodeDetail = JSONObject.toJSONString((Object)dagNode);
                break;
            }
            case DAG: {
                this.tcDagOrNodeDetail = JSONObject.toJSONString((Object)BeanUtil.getBean(TcDagRepository.class).findFirstById(this.defId()));
                break;
            }
        }
        return this;
    }

    public TcDagInstNode updateNodeId() {
        this.nodeId();
        return this;
    }

    public String alias() {
        if (this.subDagInstId == null || this.subDagInstId == 0L) {
            return this.dagNode().alias();
        }
        return this.subDagInst().dag().alias();
    }

    public JSONObject tcDagContentNodeSpecJson() {
        if (CollectionUtils.isEmpty((Map)this.tcDagContentNodeSpecJson)) {
            this.tcDagContentNodeSpecJson = JSONObject.parseObject((String)this.tcDagContentNodeSpec);
        }
        return this.tcDagContentNodeSpecJson;
    }

    public String nodeId() {
        if (StringUtils.isEmpty((CharSequence)this.nodeId)) {
            this.nodeId = this.tcDagContentNodeSpecJson().getString("id");
        }
        return this.nodeId;
    }

    public JSONObject dataJson() {
        return this.tcDagContentNodeSpecJson().getJSONObject("data");
    }

    public DagInstNodeType type() {
        return DagInstNodeType.valueOf(this.dataJson().getString("type"));
    }

    public Long defId() {
        return this.dataJson().getLongValue("defId");
    }

    public List<DagNodeInputParam> inputParamList() {
        List<DagNodeInputParam> dagNodeInputParamsFromDag = DagNodeInputParam.toList(this.dataJson().getJSONArray("inputParams"));
        List<DagNodeInputParam> dagNodeInputParamsFromNode = this.dagNode().inputParamList();
        for (DagNodeInputParam dagNodeInputParamFromDag : dagNodeInputParamsFromDag) {
            for (DagNodeInputParam dagNodeInputParamFromNode : dagNodeInputParamsFromNode) {
                if (!dagNodeInputParamFromDag.getName().equals(dagNodeInputParamFromNode.getName())) continue;
                dagNodeInputParamFromDag.setType(dagNodeInputParamFromNode.getType());
            }
        }
        return dagNodeInputParamsFromDag;
    }

    public List<DagNodeOutputParam> outputParamList() {
        return DagNodeOutputParam.toList(this.dataJson().getJSONArray("outputParams"));
    }

    public DagInstNodeStatus status() {
        return DagInstNodeStatus.valueOf(this.status);
    }

    public boolean isEnd() {
        switch (this.status()) {
            case EXCEPTION: 
            case STOPPED: 
            case SUCCESS: 
            case SKIP: 
            case SKIP_CAUSE_BY_STOPPED: 
            case SKIP_CAUSE_BY_EXCEPTION: {
                return true;
            }
        }
        return false;
    }

    public TcDagInst dagInst() {
        return BeanUtil.getBean(TcDagInstRepository.class).findFirstById(this.dagInstId);
    }

    public TcDagInst subDagInst() {
        return BeanUtil.getBean(TcDagInstRepository.class).findFirstById(this.subDagInstId);
    }

    public Long taskId() {
        if (StringUtils.isEmpty((CharSequence)this.taskId)) {
            return null;
        }
        return Long.parseLong(this.taskId);
    }

    public TcDagInstNodeStd localNodeStd() {
        return BeanUtil.getBean(TcDagInstNodeStdRepository.class).findFirstById(this.id);
    }

    public Long stopTaskId() {
        if (StringUtils.isEmpty((CharSequence)this.stopTaskId)) {
            return null;
        }
        return Long.parseLong(this.stopTaskId);
    }

    public TcDagNode dagNode() {
        if (this.dagNode == null) {
            this.dagNode = (TcDagNode)JSONObject.parseObject((String)this.tcDagOrNodeDetail, TcDagNode.class);
        }
        return this.dagNode;
    }

    public List<TcDagInstEdge> inEdgeList() {
        TcDagInstEdgeRepository dagInstEdgeRepository = BeanUtil.getBean(TcDagInstEdgeRepository.class);
        ArrayList edgeList = dagInstEdgeRepository.findAllByDagInstIdAndTarget(this.dagInstId, this.nodeId());
        return CollectionUtils.isEmpty(edgeList) ? new ArrayList() : edgeList;
    }

    public List<TcDagInstNode> sourceNodeList() {
        return this.inEdgeList().stream().map(TcDagInstEdge::sourceNode).collect(Collectors.toList());
    }

    public JSONObject outJsonWithCache() throws Exception {
        if (CollectionUtils.isEmpty((Map)this.outJsonWithCache)) {
            this.outJsonWithCache = this.outJson();
        }
        return this.outJsonWithCache;
    }

    public JSONObject outJson() throws Exception {
        JSONObject outJson;
        TcDagNode dagNode = this.dagNode();
        switch (dagNode.type()) {
            case LOCAL: {
                outJson = BeanUtil.getBean(LocalActionNewService.class).stdout(this.taskId());
                break;
            }
            default: {
                throw new Exception("dagNode node have this type: " + (Object)((Object)dagNode.type()));
            }
        }
        return outJson;
    }

    public void saveAndFlush() {
        BeanUtil.getBean(TcDagInstNodeRepository.class).saveAndFlush(this);
    }

    @Override
    public void save() {
        BeanUtil.getBean(TcDagInstNodeRepository.class).save(this);
    }

    @Override
    public void flush() {
        BeanUtil.getBean(TcDagInstNodeRepository.class).flush();
    }

    public void statusSet(Exception e) {
        this.status = DagInstNodeStatus.EXCEPTION.toString();
        this.statusDetail = Throwables.getStackTraceAsString((Throwable)e);
    }

    public void statusSet(DagInstNodeStatus status) {
        this.status = status.toString();
    }

    public void statusSet(DagInstNodeStatus status, String statusDetail) {
        this.status = status.toString();
        this.statusDetail = statusDetail;
    }

    public static TcDagInstNodeBuilder builder() {
        return new TcDagInstNodeBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TcDagInstNode)) {
            return false;
        }
        TcDagInstNode other = (TcDagInstNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$gmtCreate = this.getGmtCreate();
        Long other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Long this$gmtModified = this.getGmtModified();
        Long other$gmtModified = other.getGmtModified();
        if (this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified)) {
            return false;
        }
        Long this$gmtStart = this.getGmtStart();
        Long other$gmtStart = other.getGmtStart();
        if (this$gmtStart == null ? other$gmtStart != null : !((Object)this$gmtStart).equals(other$gmtStart)) {
            return false;
        }
        Long this$dagInstId = this.getDagInstId();
        Long other$dagInstId = other.getDagInstId();
        if (this$dagInstId == null ? other$dagInstId != null : !((Object)this$dagInstId).equals(other$dagInstId)) {
            return false;
        }
        String this$nodeId = this.getNodeId();
        String other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !this$nodeId.equals(other$nodeId)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$statusDetail = this.getStatusDetail();
        String other$statusDetail = other.getStatusDetail();
        if (this$statusDetail == null ? other$statusDetail != null : !this$statusDetail.equals(other$statusDetail)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$stopTaskId = this.getStopTaskId();
        String other$stopTaskId = other.getStopTaskId();
        if (this$stopTaskId == null ? other$stopTaskId != null : !this$stopTaskId.equals(other$stopTaskId)) {
            return false;
        }
        String this$lockId = this.getLockId();
        String other$lockId = other.getLockId();
        if (this$lockId == null ? other$lockId != null : !this$lockId.equals(other$lockId)) {
            return false;
        }
        Long this$subDagInstId = this.getSubDagInstId();
        Long other$subDagInstId = other.getSubDagInstId();
        if (this$subDagInstId == null ? other$subDagInstId != null : !((Object)this$subDagInstId).equals(other$subDagInstId)) {
            return false;
        }
        Long this$retryTimes = this.getRetryTimes();
        Long other$retryTimes = other.getRetryTimes();
        if (this$retryTimes == null ? other$retryTimes != null : !((Object)this$retryTimes).equals(other$retryTimes)) {
            return false;
        }
        String this$tcDagOrNodeDetail = this.getTcDagOrNodeDetail();
        String other$tcDagOrNodeDetail = other.getTcDagOrNodeDetail();
        if (this$tcDagOrNodeDetail == null ? other$tcDagOrNodeDetail != null : !this$tcDagOrNodeDetail.equals(other$tcDagOrNodeDetail)) {
            return false;
        }
        String this$tcDagContentNodeSpec = this.getTcDagContentNodeSpec();
        String other$tcDagContentNodeSpec = other.getTcDagContentNodeSpec();
        if (this$tcDagContentNodeSpec == null ? other$tcDagContentNodeSpec != null : !this$tcDagContentNodeSpec.equals(other$tcDagContentNodeSpec)) {
            return false;
        }
        JSONObject this$tcDagContentNodeSpecJson = this.getTcDagContentNodeSpecJson();
        JSONObject other$tcDagContentNodeSpecJson = other.getTcDagContentNodeSpecJson();
        if (this$tcDagContentNodeSpecJson == null ? other$tcDagContentNodeSpecJson != null : !this$tcDagContentNodeSpecJson.equals(other$tcDagContentNodeSpecJson)) {
            return false;
        }
        TcDagNode this$dagNode = this.getDagNode();
        TcDagNode other$dagNode = other.getDagNode();
        if (this$dagNode == null ? other$dagNode != null : !((Object)this$dagNode).equals(other$dagNode)) {
            return false;
        }
        JSONObject this$outJsonWithCache = this.getOutJsonWithCache();
        JSONObject other$outJsonWithCache = other.getOutJsonWithCache();
        return !(this$outJsonWithCache == null ? other$outJsonWithCache != null : !this$outJsonWithCache.equals(other$outJsonWithCache));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TcDagInstNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Long $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        Long $gmtStart = this.getGmtStart();
        result = result * 59 + ($gmtStart == null ? 43 : ((Object)$gmtStart).hashCode());
        Long $dagInstId = this.getDagInstId();
        result = result * 59 + ($dagInstId == null ? 43 : ((Object)$dagInstId).hashCode());
        String $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : $nodeId.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $statusDetail = this.getStatusDetail();
        result = result * 59 + ($statusDetail == null ? 43 : $statusDetail.hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $stopTaskId = this.getStopTaskId();
        result = result * 59 + ($stopTaskId == null ? 43 : $stopTaskId.hashCode());
        String $lockId = this.getLockId();
        result = result * 59 + ($lockId == null ? 43 : $lockId.hashCode());
        Long $subDagInstId = this.getSubDagInstId();
        result = result * 59 + ($subDagInstId == null ? 43 : ((Object)$subDagInstId).hashCode());
        Long $retryTimes = this.getRetryTimes();
        result = result * 59 + ($retryTimes == null ? 43 : ((Object)$retryTimes).hashCode());
        String $tcDagOrNodeDetail = this.getTcDagOrNodeDetail();
        result = result * 59 + ($tcDagOrNodeDetail == null ? 43 : $tcDagOrNodeDetail.hashCode());
        String $tcDagContentNodeSpec = this.getTcDagContentNodeSpec();
        result = result * 59 + ($tcDagContentNodeSpec == null ? 43 : $tcDagContentNodeSpec.hashCode());
        JSONObject $tcDagContentNodeSpecJson = this.getTcDagContentNodeSpecJson();
        result = result * 59 + ($tcDagContentNodeSpecJson == null ? 43 : $tcDagContentNodeSpecJson.hashCode());
        TcDagNode $dagNode = this.getDagNode();
        result = result * 59 + ($dagNode == null ? 43 : ((Object)$dagNode).hashCode());
        JSONObject $outJsonWithCache = this.getOutJsonWithCache();
        result = result * 59 + ($outJsonWithCache == null ? 43 : $outJsonWithCache.hashCode());
        return result;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public Long getGmtCreate() {
        return this.gmtCreate;
    }

    @Override
    public Long getGmtModified() {
        return this.gmtModified;
    }

    public Long getGmtStart() {
        return this.gmtStart;
    }

    public Long getDagInstId() {
        return this.dagInstId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStatusDetail() {
        return this.statusDetail;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getStopTaskId() {
        return this.stopTaskId;
    }

    public String getLockId() {
        return this.lockId;
    }

    public Long getSubDagInstId() {
        return this.subDagInstId;
    }

    public Long getRetryTimes() {
        return this.retryTimes;
    }

    public String getTcDagOrNodeDetail() {
        return this.tcDagOrNodeDetail;
    }

    public String getTcDagContentNodeSpec() {
        return this.tcDagContentNodeSpec;
    }

    public JSONObject getTcDagContentNodeSpecJson() {
        return this.tcDagContentNodeSpecJson;
    }

    public TcDagNode getDagNode() {
        return this.dagNode;
    }

    public JSONObject getOutJsonWithCache() {
        return this.outJsonWithCache;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setGmtCreate(Long gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    @Override
    public void setGmtModified(Long gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void setGmtStart(Long gmtStart) {
        this.gmtStart = gmtStart;
    }

    public void setDagInstId(Long dagInstId) {
        this.dagInstId = dagInstId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStatusDetail(String statusDetail) {
        this.statusDetail = statusDetail;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setStopTaskId(String stopTaskId) {
        this.stopTaskId = stopTaskId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public void setSubDagInstId(Long subDagInstId) {
        this.subDagInstId = subDagInstId;
    }

    public void setRetryTimes(Long retryTimes) {
        this.retryTimes = retryTimes;
    }

    public void setTcDagOrNodeDetail(String tcDagOrNodeDetail) {
        this.tcDagOrNodeDetail = tcDagOrNodeDetail;
    }

    public void setTcDagContentNodeSpec(String tcDagContentNodeSpec) {
        this.tcDagContentNodeSpec = tcDagContentNodeSpec;
    }

    public void setTcDagContentNodeSpecJson(JSONObject tcDagContentNodeSpecJson) {
        this.tcDagContentNodeSpecJson = tcDagContentNodeSpecJson;
    }

    public void setDagNode(TcDagNode dagNode) {
        this.dagNode = dagNode;
    }

    public void setOutJsonWithCache(JSONObject outJsonWithCache) {
        this.outJsonWithCache = outJsonWithCache;
    }

    @Override
    public String toString() {
        return "TcDagInstNode(id=" + this.getId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ", gmtStart=" + this.getGmtStart() + ", dagInstId=" + this.getDagInstId() + ", nodeId=" + this.getNodeId() + ", status=" + this.getStatus() + ", statusDetail=" + this.getStatusDetail() + ", taskId=" + this.getTaskId() + ", stopTaskId=" + this.getStopTaskId() + ", lockId=" + this.getLockId() + ", subDagInstId=" + this.getSubDagInstId() + ", retryTimes=" + this.getRetryTimes() + ", tcDagOrNodeDetail=" + this.getTcDagOrNodeDetail() + ", tcDagContentNodeSpec=" + this.getTcDagContentNodeSpec() + ", tcDagContentNodeSpecJson=" + this.getTcDagContentNodeSpecJson() + ", dagNode=" + this.getDagNode() + ", outJsonWithCache=" + this.getOutJsonWithCache() + ")";
    }

    public TcDagInstNode(Long id, Long gmtCreate, Long gmtModified, Long gmtStart, Long dagInstId, String nodeId, String status, String statusDetail, String taskId, String stopTaskId, String lockId, Long subDagInstId, Long retryTimes, String tcDagOrNodeDetail, String tcDagContentNodeSpec, JSONObject tcDagContentNodeSpecJson, TcDagNode dagNode, JSONObject outJsonWithCache) {
        this.id = id;
        this.gmtCreate = gmtCreate;
        this.gmtModified = gmtModified;
        this.gmtStart = gmtStart;
        this.dagInstId = dagInstId;
        this.nodeId = nodeId;
        this.status = status;
        this.statusDetail = statusDetail;
        this.taskId = taskId;
        this.stopTaskId = stopTaskId;
        this.lockId = lockId;
        this.subDagInstId = subDagInstId;
        this.retryTimes = retryTimes;
        this.tcDagOrNodeDetail = tcDagOrNodeDetail;
        this.tcDagContentNodeSpec = tcDagContentNodeSpec;
        this.tcDagContentNodeSpecJson = tcDagContentNodeSpecJson;
        this.dagNode = dagNode;
        this.outJsonWithCache = outJsonWithCache;
    }

    public TcDagInstNode() {
    }

    public static class TcDagInstNodeBuilder {
        private Long id;
        private Long gmtCreate;
        private Long gmtModified;
        private Long gmtStart;
        private Long dagInstId;
        private String nodeId;
        private String status;
        private String statusDetail;
        private String taskId;
        private String stopTaskId;
        private String lockId;
        private Long subDagInstId;
        private Long retryTimes;
        private String tcDagOrNodeDetail;
        private String tcDagContentNodeSpec;
        private JSONObject tcDagContentNodeSpecJson;
        private TcDagNode dagNode;
        private JSONObject outJsonWithCache;

        TcDagInstNodeBuilder() {
        }

        public TcDagInstNodeBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public TcDagInstNodeBuilder gmtCreate(Long gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public TcDagInstNodeBuilder gmtModified(Long gmtModified) {
            this.gmtModified = gmtModified;
            return this;
        }

        public TcDagInstNodeBuilder gmtStart(Long gmtStart) {
            this.gmtStart = gmtStart;
            return this;
        }

        public TcDagInstNodeBuilder dagInstId(Long dagInstId) {
            this.dagInstId = dagInstId;
            return this;
        }

        public TcDagInstNodeBuilder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public TcDagInstNodeBuilder status(String status) {
            this.status = status;
            return this;
        }

        public TcDagInstNodeBuilder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        public TcDagInstNodeBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public TcDagInstNodeBuilder stopTaskId(String stopTaskId) {
            this.stopTaskId = stopTaskId;
            return this;
        }

        public TcDagInstNodeBuilder lockId(String lockId) {
            this.lockId = lockId;
            return this;
        }

        public TcDagInstNodeBuilder subDagInstId(Long subDagInstId) {
            this.subDagInstId = subDagInstId;
            return this;
        }

        public TcDagInstNodeBuilder retryTimes(Long retryTimes) {
            this.retryTimes = retryTimes;
            return this;
        }

        public TcDagInstNodeBuilder tcDagOrNodeDetail(String tcDagOrNodeDetail) {
            this.tcDagOrNodeDetail = tcDagOrNodeDetail;
            return this;
        }

        public TcDagInstNodeBuilder tcDagContentNodeSpec(String tcDagContentNodeSpec) {
            this.tcDagContentNodeSpec = tcDagContentNodeSpec;
            return this;
        }

        public TcDagInstNodeBuilder tcDagContentNodeSpecJson(JSONObject tcDagContentNodeSpecJson) {
            this.tcDagContentNodeSpecJson = tcDagContentNodeSpecJson;
            return this;
        }

        public TcDagInstNodeBuilder dagNode(TcDagNode dagNode) {
            this.dagNode = dagNode;
            return this;
        }

        public TcDagInstNodeBuilder outJsonWithCache(JSONObject outJsonWithCache) {
            this.outJsonWithCache = outJsonWithCache;
            return this;
        }

        public TcDagInstNode build() {
            return new TcDagInstNode(this.id, this.gmtCreate, this.gmtModified, this.gmtStart, this.dagInstId, this.nodeId, this.status, this.statusDetail, this.taskId, this.stopTaskId, this.lockId, this.subDagInstId, this.retryTimes, this.tcDagOrNodeDetail, this.tcDagContentNodeSpec, this.tcDagContentNodeSpecJson, this.dagNode, this.outJsonWithCache);
        }

        public String toString() {
            return "TcDagInstNode.TcDagInstNodeBuilder(id=" + this.id + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + ", gmtStart=" + this.gmtStart + ", dagInstId=" + this.dagInstId + ", nodeId=" + this.nodeId + ", status=" + this.status + ", statusDetail=" + this.statusDetail + ", taskId=" + this.taskId + ", stopTaskId=" + this.stopTaskId + ", lockId=" + this.lockId + ", subDagInstId=" + this.subDagInstId + ", retryTimes=" + this.retryTimes + ", tcDagOrNodeDetail=" + this.tcDagOrNodeDetail + ", tcDagContentNodeSpec=" + this.tcDagContentNodeSpec + ", tcDagContentNodeSpecJson=" + this.tcDagContentNodeSpecJson + ", dagNode=" + this.dagNode + ", outJsonWithCache=" + this.outJsonWithCache + ")";
        }
    }
}

