/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.model.domain;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.tesla.dag.common.BeanUtil;
import com.alibaba.tesla.dag.model.domain.AbstractTcDag;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeStdRepository;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;
import com.alibaba.tesla.dag.schedule.task.TaskStatus;
import com.google.common.base.Throwables;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Table
@Entity
@EntityListeners(value={AuditingEntityListener.class})
public class TcDagInstNodeStd
extends AbstractTcDag {
    private static final Logger log = LoggerFactory.getLogger(TcDagInstNodeStd.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    private Long gmtCreate;
    @Column
    private Long gmtModified;
    @Column
    private Long gmtAccess;
    @Column
    private String status;
    @Column(columnDefinition="longtext")
    private String stdout;
    @Column(columnDefinition="longtext")
    private String stderr;
    @Column(columnDefinition="longtext")
    private String globalParams;
    @Column
    private String ip;
    @Column
    private String standaloneIp;
    @Column(columnDefinition="longtext")
    private String comment;
    @Column
    private Integer isStop;
    @Column
    private Long stopId;
    @Column
    private String lockId;
    @Column
    private Long dagInstId;
    @Column
    private Long dagInstNodeId;

    public boolean isStop() {
        return this.isStop != null && 1 == this.isStop;
    }

    public Object globalParams() {
        if (!"__DEL__".equals(this.globalParams)) {
            return JSONObject.parseObject((String)this.globalParams);
        }
        return this.globalParams;
    }

    public TaskStatus status() {
        return TaskStatus.valueOf(this.status);
    }

    public TcDagInstNodeStd patchError(Exception e) {
        this.setGmtModified(System.currentTimeMillis() / 1000L);
        this.status = TaskStatus.EXCEPTION.name();
        this.setStdout("");
        this.setStderr(Throwables.getStackTraceAsString((Throwable)e));
        return this;
    }

    public JSONObject stdout() {
        return JSONObject.parseObject((String)this.stdout, (Feature[])new Feature[]{Feature.OrderedField});
    }

    public void saveStatus(TaskStatus status) {
        this.setGmtModified(System.currentTimeMillis() / 1000L);
        this.status = status.toString();
        this.saveAndFlush();
    }

    public void saveStatus(Exception e) {
        this.setGmtModified(System.currentTimeMillis() / 1000L);
        this.status = TaskStatus.EXCEPTION.toString();
        this.stderr = Throwables.getStackTraceAsString((Throwable)e);
        this.saveAndFlush();
    }

    public void saveAndFlush() {
        if (this.gmtCreate == null) {
            this.gmtCreate = System.currentTimeMillis() / 1000L;
        }
        this.gmtModified = System.currentTimeMillis() / 1000L;
        BeanUtil.getBean(TcDagInstNodeStdRepository.class).saveAndFlush(this);
    }

    @Override
    public void save() {
        BeanUtil.getBean(TcDagInstNodeStdRepository.class).save(this);
    }

    @Override
    public void flush() {
        BeanUtil.getBean(TcDagInstNodeStdRepository.class).flush();
    }

    public void statusSet(Exception e) {
        this.status = DagInstStatus.EXCEPTION.toString();
        this.stderr = Throwables.getStackTraceAsString((Throwable)e);
    }

    public void statusSet(TaskStatus status) {
        this.status = status.toString();
    }

    public static TcDagInstNodeStdBuilder builder() {
        return new TcDagInstNodeStdBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TcDagInstNodeStd)) {
            return false;
        }
        TcDagInstNodeStd other = (TcDagInstNodeStd)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$gmtCreate = this.getGmtCreate();
        Long other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Long this$gmtModified = this.getGmtModified();
        Long other$gmtModified = other.getGmtModified();
        if (this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified)) {
            return false;
        }
        Long this$gmtAccess = this.getGmtAccess();
        Long other$gmtAccess = other.getGmtAccess();
        if (this$gmtAccess == null ? other$gmtAccess != null : !((Object)this$gmtAccess).equals(other$gmtAccess)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$stdout = this.getStdout();
        String other$stdout = other.getStdout();
        if (this$stdout == null ? other$stdout != null : !this$stdout.equals(other$stdout)) {
            return false;
        }
        String this$stderr = this.getStderr();
        String other$stderr = other.getStderr();
        if (this$stderr == null ? other$stderr != null : !this$stderr.equals(other$stderr)) {
            return false;
        }
        String this$globalParams = this.getGlobalParams();
        String other$globalParams = other.getGlobalParams();
        if (this$globalParams == null ? other$globalParams != null : !this$globalParams.equals(other$globalParams)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$standaloneIp = this.getStandaloneIp();
        String other$standaloneIp = other.getStandaloneIp();
        if (this$standaloneIp == null ? other$standaloneIp != null : !this$standaloneIp.equals(other$standaloneIp)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Integer this$isStop = this.getIsStop();
        Integer other$isStop = other.getIsStop();
        if (this$isStop == null ? other$isStop != null : !((Object)this$isStop).equals(other$isStop)) {
            return false;
        }
        Long this$stopId = this.getStopId();
        Long other$stopId = other.getStopId();
        if (this$stopId == null ? other$stopId != null : !((Object)this$stopId).equals(other$stopId)) {
            return false;
        }
        String this$lockId = this.getLockId();
        String other$lockId = other.getLockId();
        if (this$lockId == null ? other$lockId != null : !this$lockId.equals(other$lockId)) {
            return false;
        }
        Long this$dagInstId = this.getDagInstId();
        Long other$dagInstId = other.getDagInstId();
        if (this$dagInstId == null ? other$dagInstId != null : !((Object)this$dagInstId).equals(other$dagInstId)) {
            return false;
        }
        Long this$dagInstNodeId = this.getDagInstNodeId();
        Long other$dagInstNodeId = other.getDagInstNodeId();
        return !(this$dagInstNodeId == null ? other$dagInstNodeId != null : !((Object)this$dagInstNodeId).equals(other$dagInstNodeId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TcDagInstNodeStd;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Long $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        Long $gmtAccess = this.getGmtAccess();
        result = result * 59 + ($gmtAccess == null ? 43 : ((Object)$gmtAccess).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $stdout = this.getStdout();
        result = result * 59 + ($stdout == null ? 43 : $stdout.hashCode());
        String $stderr = this.getStderr();
        result = result * 59 + ($stderr == null ? 43 : $stderr.hashCode());
        String $globalParams = this.getGlobalParams();
        result = result * 59 + ($globalParams == null ? 43 : $globalParams.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $standaloneIp = this.getStandaloneIp();
        result = result * 59 + ($standaloneIp == null ? 43 : $standaloneIp.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Integer $isStop = this.getIsStop();
        result = result * 59 + ($isStop == null ? 43 : ((Object)$isStop).hashCode());
        Long $stopId = this.getStopId();
        result = result * 59 + ($stopId == null ? 43 : ((Object)$stopId).hashCode());
        String $lockId = this.getLockId();
        result = result * 59 + ($lockId == null ? 43 : $lockId.hashCode());
        Long $dagInstId = this.getDagInstId();
        result = result * 59 + ($dagInstId == null ? 43 : ((Object)$dagInstId).hashCode());
        Long $dagInstNodeId = this.getDagInstNodeId();
        result = result * 59 + ($dagInstNodeId == null ? 43 : ((Object)$dagInstNodeId).hashCode());
        return result;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public Long getGmtCreate() {
        return this.gmtCreate;
    }

    @Override
    public Long getGmtModified() {
        return this.gmtModified;
    }

    public Long getGmtAccess() {
        return this.gmtAccess;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public String getGlobalParams() {
        return this.globalParams;
    }

    public String getIp() {
        return this.ip;
    }

    public String getStandaloneIp() {
        return this.standaloneIp;
    }

    public String getComment() {
        return this.comment;
    }

    public Integer getIsStop() {
        return this.isStop;
    }

    public Long getStopId() {
        return this.stopId;
    }

    public String getLockId() {
        return this.lockId;
    }

    public Long getDagInstId() {
        return this.dagInstId;
    }

    public Long getDagInstNodeId() {
        return this.dagInstNodeId;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setGmtCreate(Long gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    @Override
    public void setGmtModified(Long gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void setGmtAccess(Long gmtAccess) {
        this.gmtAccess = gmtAccess;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStdout(String stdout) {
        this.stdout = stdout;
    }

    public void setStderr(String stderr) {
        this.stderr = stderr;
    }

    public void setGlobalParams(String globalParams) {
        this.globalParams = globalParams;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setStandaloneIp(String standaloneIp) {
        this.standaloneIp = standaloneIp;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setIsStop(Integer isStop) {
        this.isStop = isStop;
    }

    public void setStopId(Long stopId) {
        this.stopId = stopId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public void setDagInstId(Long dagInstId) {
        this.dagInstId = dagInstId;
    }

    public void setDagInstNodeId(Long dagInstNodeId) {
        this.dagInstNodeId = dagInstNodeId;
    }

    @Override
    public String toString() {
        return "TcDagInstNodeStd(id=" + this.getId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ", gmtAccess=" + this.getGmtAccess() + ", status=" + this.getStatus() + ", stdout=" + this.getStdout() + ", stderr=" + this.getStderr() + ", globalParams=" + this.getGlobalParams() + ", ip=" + this.getIp() + ", standaloneIp=" + this.getStandaloneIp() + ", comment=" + this.getComment() + ", isStop=" + this.getIsStop() + ", stopId=" + this.getStopId() + ", lockId=" + this.getLockId() + ", dagInstId=" + this.getDagInstId() + ", dagInstNodeId=" + this.getDagInstNodeId() + ")";
    }

    public TcDagInstNodeStd(Long id, Long gmtCreate, Long gmtModified, Long gmtAccess, String status, String stdout, String stderr, String globalParams, String ip, String standaloneIp, String comment, Integer isStop, Long stopId, String lockId, Long dagInstId, Long dagInstNodeId) {
        this.id = id;
        this.gmtCreate = gmtCreate;
        this.gmtModified = gmtModified;
        this.gmtAccess = gmtAccess;
        this.status = status;
        this.stdout = stdout;
        this.stderr = stderr;
        this.globalParams = globalParams;
        this.ip = ip;
        this.standaloneIp = standaloneIp;
        this.comment = comment;
        this.isStop = isStop;
        this.stopId = stopId;
        this.lockId = lockId;
        this.dagInstId = dagInstId;
        this.dagInstNodeId = dagInstNodeId;
    }

    public TcDagInstNodeStd() {
    }

    public static class TcDagInstNodeStdBuilder {
        private Long id;
        private Long gmtCreate;
        private Long gmtModified;
        private Long gmtAccess;
        private String status;
        private String stdout;
        private String stderr;
        private String globalParams;
        private String ip;
        private String standaloneIp;
        private String comment;
        private Integer isStop;
        private Long stopId;
        private String lockId;
        private Long dagInstId;
        private Long dagInstNodeId;

        TcDagInstNodeStdBuilder() {
        }

        public TcDagInstNodeStdBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public TcDagInstNodeStdBuilder gmtCreate(Long gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public TcDagInstNodeStdBuilder gmtModified(Long gmtModified) {
            this.gmtModified = gmtModified;
            return this;
        }

        public TcDagInstNodeStdBuilder gmtAccess(Long gmtAccess) {
            this.gmtAccess = gmtAccess;
            return this;
        }

        public TcDagInstNodeStdBuilder status(String status) {
            this.status = status;
            return this;
        }

        public TcDagInstNodeStdBuilder stdout(String stdout) {
            this.stdout = stdout;
            return this;
        }

        public TcDagInstNodeStdBuilder stderr(String stderr) {
            this.stderr = stderr;
            return this;
        }

        public TcDagInstNodeStdBuilder globalParams(String globalParams) {
            this.globalParams = globalParams;
            return this;
        }

        public TcDagInstNodeStdBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public TcDagInstNodeStdBuilder standaloneIp(String standaloneIp) {
            this.standaloneIp = standaloneIp;
            return this;
        }

        public TcDagInstNodeStdBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public TcDagInstNodeStdBuilder isStop(Integer isStop) {
            this.isStop = isStop;
            return this;
        }

        public TcDagInstNodeStdBuilder stopId(Long stopId) {
            this.stopId = stopId;
            return this;
        }

        public TcDagInstNodeStdBuilder lockId(String lockId) {
            this.lockId = lockId;
            return this;
        }

        public TcDagInstNodeStdBuilder dagInstId(Long dagInstId) {
            this.dagInstId = dagInstId;
            return this;
        }

        public TcDagInstNodeStdBuilder dagInstNodeId(Long dagInstNodeId) {
            this.dagInstNodeId = dagInstNodeId;
            return this;
        }

        public TcDagInstNodeStd build() {
            return new TcDagInstNodeStd(this.id, this.gmtCreate, this.gmtModified, this.gmtAccess, this.status, this.stdout, this.stderr, this.globalParams, this.ip, this.standaloneIp, this.comment, this.isStop, this.stopId, this.lockId, this.dagInstId, this.dagInstNodeId);
        }

        public String toString() {
            return "TcDagInstNodeStd.TcDagInstNodeStdBuilder(id=" + this.id + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + ", gmtAccess=" + this.gmtAccess + ", status=" + this.status + ", stdout=" + this.stdout + ", stderr=" + this.stderr + ", globalParams=" + this.globalParams + ", ip=" + this.ip + ", standaloneIp=" + this.standaloneIp + ", comment=" + this.comment + ", isStop=" + this.isStop + ", stopId=" + this.stopId + ", lockId=" + this.lockId + ", dagInstId=" + this.dagInstId + ", dagInstNodeId=" + this.dagInstNodeId + ")";
        }
    }
}

