/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.model.domain;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.common.BeanUtil;
import com.alibaba.tesla.dag.model.domain.AbstractTcDag;
import com.alibaba.tesla.dag.model.domain.TcDagOptions;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeDetailApi;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeDetailFaas;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeDetailInterface;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeDetailLocal;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeDetailTask;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeFormatType;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeInputParam;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeOutputParam;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeType;
import com.alibaba.tesla.dag.model.repository.TcDagNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagOptionsRepository;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Table(uniqueConstraints={@UniqueConstraint(columnNames={"appId", "name"})})
@Entity
@EntityListeners(value={AuditingEntityListener.class})
public class TcDagNode
extends AbstractTcDag {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    private Long gmtCreate;
    @Column
    private Long gmtModified;
    @Column
    private String appId;
    @Column
    private String name;
    @Column
    private String alias;
    @Column(columnDefinition="longtext")
    private String description;
    @Column
    private Integer isShare;
    @Column
    private Integer isShow;
    @Column(columnDefinition="longtext")
    private String inputParams;
    @Column(columnDefinition="longtext")
    private String outputParams;
    @Column
    private String type;
    @Column(columnDefinition="longtext")
    private String detail;
    @Column
    private String formatType;
    @Column(columnDefinition="longtext")
    private String formatDetail;
    private String lastUpdateBy;
    private String creator;
    private String modifier;
    private Integer isSupportChatops;
    @Column(columnDefinition="longtext")
    private String chatopsDetail;
    private Integer runTimeout;
    @Column
    private Long maxRetryTimes;
    @Column(columnDefinition="longtext")
    private String retryExpression;

    public long maxRetryTimes() {
        return this.maxRetryTimes == null ? 0L : this.maxRetryTimes;
    }

    public String alias() {
        return StringUtils.isEmpty((CharSequence)this.alias) ? this.name : this.alias;
    }

    public boolean share() {
        return this.isShare != null && 1 == this.isShare;
    }

    public boolean show() {
        return this.isShow != null && 1 == this.isShow;
    }

    public List<DagNodeInputParam> inputParamList() {
        return DagNodeInputParam.toList(JSONArray.parseArray((String)this.inputParams));
    }

    public List<DagNodeOutputParam> outputParamList() {
        return DagNodeOutputParam.toList(JSONArray.parseArray((String)this.outputParams));
    }

    public DagNodeType type() {
        return DagNodeType.valueOf(this.type);
    }

    public DagNodeDetailInterface detail() {
        switch (this.type()) {
            case LOCAL: {
                return (DagNodeDetailInterface)JSONObject.parseObject((String)this.detail, DagNodeDetailLocal.class);
            }
            case TASK: {
                return (DagNodeDetailInterface)JSONObject.parseObject((String)this.detail, DagNodeDetailTask.class);
            }
            case API: {
                return (DagNodeDetailInterface)JSONObject.parseObject((String)this.detail, DagNodeDetailApi.class);
            }
            case FAAS: {
                return (DagNodeDetailInterface)JSONObject.parseObject((String)this.detail, DagNodeDetailFaas.class);
            }
        }
        return null;
    }

    public DagNodeFormatType formatType() {
        return StringUtils.isEmpty((CharSequence)this.formatType) ? DagNodeFormatType.CUSTOM : DagNodeFormatType.valueOf(this.formatType);
    }

    public void updateOptions() {
        this.updateOptions("zh_CN");
    }

    public void updateOptions(String locale) {
        TcDagOptions.builder().locale(locale).name(String.format("dagNode:%s:alias", this.id)).value(this.alias).build().upsert();
        TcDagOptions.builder().locale(locale).name(String.format("dagNode:%s:description", this.id)).value(this.description).build().upsert();
    }

    public void obtainOptions(String locale) {
        TcDagOptionsRepository dagOptionsRepository = BeanUtil.getBean(TcDagOptionsRepository.class);
        TcDagOptions dagOptions = dagOptionsRepository.findFirstByLocaleAndName(locale, String.format("dagNode:%s:alias", this.id));
        if (dagOptions != null) {
            this.alias = dagOptions.getValue();
        }
        if ((dagOptions = dagOptionsRepository.findFirstByLocaleAndName(locale, String.format("dagNode:%s:description", this.id))) != null) {
            this.description = dagOptions.getValue();
        }
    }

    public void upsertByAppIdAndName() throws Exception {
        TcDagNodeRepository dagNodeRepository;
        TcDagNode searchDagNode;
        if (this.id == null && (searchDagNode = (dagNodeRepository = BeanUtil.getBean(TcDagNodeRepository.class)).findFirstByAppIdAndName(this.appId, this.name)) != null) {
            this.gmtCreate = searchDagNode.getGmtCreate();
            this.id = searchDagNode.getId();
        }
        if (this.id == null) {
            this.setGmtCreate(System.currentTimeMillis() / 1000L);
            this.setGmtModified(System.currentTimeMillis() / 1000L);
        } else {
            this.setGmtModified(System.currentTimeMillis() / 1000L);
        }
        this.saveAndFlush();
    }

    public void saveAndFlush() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            throw new Exception("name can not be null");
        }
        if (StringUtils.isEmpty((CharSequence)this.appId)) {
            throw new Exception("appId can not be null");
        }
        BeanUtil.getBean(TcDagNodeRepository.class).saveAndFlush(this);
    }

    @Override
    public void save() {
        BeanUtil.getBean(TcDagNodeRepository.class).save(this);
    }

    @Override
    public void flush() {
        BeanUtil.getBean(TcDagNodeRepository.class).flush();
    }

    public static TcDagNodeBuilder builder() {
        return new TcDagNodeBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TcDagNode)) {
            return false;
        }
        TcDagNode other = (TcDagNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$gmtCreate = this.getGmtCreate();
        Long other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Long this$gmtModified = this.getGmtModified();
        Long other$gmtModified = other.getGmtModified();
        if (this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Integer this$isShare = this.getIsShare();
        Integer other$isShare = other.getIsShare();
        if (this$isShare == null ? other$isShare != null : !((Object)this$isShare).equals(other$isShare)) {
            return false;
        }
        Integer this$isShow = this.getIsShow();
        Integer other$isShow = other.getIsShow();
        if (this$isShow == null ? other$isShow != null : !((Object)this$isShow).equals(other$isShow)) {
            return false;
        }
        String this$inputParams = this.getInputParams();
        String other$inputParams = other.getInputParams();
        if (this$inputParams == null ? other$inputParams != null : !this$inputParams.equals(other$inputParams)) {
            return false;
        }
        String this$outputParams = this.getOutputParams();
        String other$outputParams = other.getOutputParams();
        if (this$outputParams == null ? other$outputParams != null : !this$outputParams.equals(other$outputParams)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$detail = this.getDetail();
        String other$detail = other.getDetail();
        if (this$detail == null ? other$detail != null : !this$detail.equals(other$detail)) {
            return false;
        }
        String this$formatType = this.getFormatType();
        String other$formatType = other.getFormatType();
        if (this$formatType == null ? other$formatType != null : !this$formatType.equals(other$formatType)) {
            return false;
        }
        String this$formatDetail = this.getFormatDetail();
        String other$formatDetail = other.getFormatDetail();
        if (this$formatDetail == null ? other$formatDetail != null : !this$formatDetail.equals(other$formatDetail)) {
            return false;
        }
        String this$lastUpdateBy = this.getLastUpdateBy();
        String other$lastUpdateBy = other.getLastUpdateBy();
        if (this$lastUpdateBy == null ? other$lastUpdateBy != null : !this$lastUpdateBy.equals(other$lastUpdateBy)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        Integer this$isSupportChatops = this.getIsSupportChatops();
        Integer other$isSupportChatops = other.getIsSupportChatops();
        if (this$isSupportChatops == null ? other$isSupportChatops != null : !((Object)this$isSupportChatops).equals(other$isSupportChatops)) {
            return false;
        }
        String this$chatopsDetail = this.getChatopsDetail();
        String other$chatopsDetail = other.getChatopsDetail();
        if (this$chatopsDetail == null ? other$chatopsDetail != null : !this$chatopsDetail.equals(other$chatopsDetail)) {
            return false;
        }
        Integer this$runTimeout = this.getRunTimeout();
        Integer other$runTimeout = other.getRunTimeout();
        if (this$runTimeout == null ? other$runTimeout != null : !((Object)this$runTimeout).equals(other$runTimeout)) {
            return false;
        }
        Long this$maxRetryTimes = this.getMaxRetryTimes();
        Long other$maxRetryTimes = other.getMaxRetryTimes();
        if (this$maxRetryTimes == null ? other$maxRetryTimes != null : !((Object)this$maxRetryTimes).equals(other$maxRetryTimes)) {
            return false;
        }
        String this$retryExpression = this.getRetryExpression();
        String other$retryExpression = other.getRetryExpression();
        return !(this$retryExpression == null ? other$retryExpression != null : !this$retryExpression.equals(other$retryExpression));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TcDagNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Long $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Integer $isShare = this.getIsShare();
        result = result * 59 + ($isShare == null ? 43 : ((Object)$isShare).hashCode());
        Integer $isShow = this.getIsShow();
        result = result * 59 + ($isShow == null ? 43 : ((Object)$isShow).hashCode());
        String $inputParams = this.getInputParams();
        result = result * 59 + ($inputParams == null ? 43 : $inputParams.hashCode());
        String $outputParams = this.getOutputParams();
        result = result * 59 + ($outputParams == null ? 43 : $outputParams.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $detail = this.getDetail();
        result = result * 59 + ($detail == null ? 43 : $detail.hashCode());
        String $formatType = this.getFormatType();
        result = result * 59 + ($formatType == null ? 43 : $formatType.hashCode());
        String $formatDetail = this.getFormatDetail();
        result = result * 59 + ($formatDetail == null ? 43 : $formatDetail.hashCode());
        String $lastUpdateBy = this.getLastUpdateBy();
        result = result * 59 + ($lastUpdateBy == null ? 43 : $lastUpdateBy.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        Integer $isSupportChatops = this.getIsSupportChatops();
        result = result * 59 + ($isSupportChatops == null ? 43 : ((Object)$isSupportChatops).hashCode());
        String $chatopsDetail = this.getChatopsDetail();
        result = result * 59 + ($chatopsDetail == null ? 43 : $chatopsDetail.hashCode());
        Integer $runTimeout = this.getRunTimeout();
        result = result * 59 + ($runTimeout == null ? 43 : ((Object)$runTimeout).hashCode());
        Long $maxRetryTimes = this.getMaxRetryTimes();
        result = result * 59 + ($maxRetryTimes == null ? 43 : ((Object)$maxRetryTimes).hashCode());
        String $retryExpression = this.getRetryExpression();
        result = result * 59 + ($retryExpression == null ? 43 : $retryExpression.hashCode());
        return result;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public Long getGmtCreate() {
        return this.gmtCreate;
    }

    @Override
    public Long getGmtModified() {
        return this.gmtModified;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getIsShare() {
        return this.isShare;
    }

    public Integer getIsShow() {
        return this.isShow;
    }

    public String getInputParams() {
        return this.inputParams;
    }

    public String getOutputParams() {
        return this.outputParams;
    }

    public String getType() {
        return this.type;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getFormatType() {
        return this.formatType;
    }

    public String getFormatDetail() {
        return this.formatDetail;
    }

    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Integer getIsSupportChatops() {
        return this.isSupportChatops;
    }

    public String getChatopsDetail() {
        return this.chatopsDetail;
    }

    public Integer getRunTimeout() {
        return this.runTimeout;
    }

    public Long getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public String getRetryExpression() {
        return this.retryExpression;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setGmtCreate(Long gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    @Override
    public void setGmtModified(Long gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIsShare(Integer isShare) {
        this.isShare = isShare;
    }

    public void setIsShow(Integer isShow) {
        this.isShow = isShow;
    }

    public void setInputParams(String inputParams) {
        this.inputParams = inputParams;
    }

    public void setOutputParams(String outputParams) {
        this.outputParams = outputParams;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public void setFormatType(String formatType) {
        this.formatType = formatType;
    }

    public void setFormatDetail(String formatDetail) {
        this.formatDetail = formatDetail;
    }

    public void setLastUpdateBy(String lastUpdateBy) {
        this.lastUpdateBy = lastUpdateBy;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setIsSupportChatops(Integer isSupportChatops) {
        this.isSupportChatops = isSupportChatops;
    }

    public void setChatopsDetail(String chatopsDetail) {
        this.chatopsDetail = chatopsDetail;
    }

    public void setRunTimeout(Integer runTimeout) {
        this.runTimeout = runTimeout;
    }

    public void setMaxRetryTimes(Long maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public void setRetryExpression(String retryExpression) {
        this.retryExpression = retryExpression;
    }

    @Override
    public String toString() {
        return "TcDagNode(id=" + this.getId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ", appId=" + this.getAppId() + ", name=" + this.getName() + ", alias=" + this.getAlias() + ", description=" + this.getDescription() + ", isShare=" + this.getIsShare() + ", isShow=" + this.getIsShow() + ", inputParams=" + this.getInputParams() + ", outputParams=" + this.getOutputParams() + ", type=" + this.getType() + ", detail=" + this.getDetail() + ", formatType=" + this.getFormatType() + ", formatDetail=" + this.getFormatDetail() + ", lastUpdateBy=" + this.getLastUpdateBy() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", isSupportChatops=" + this.getIsSupportChatops() + ", chatopsDetail=" + this.getChatopsDetail() + ", runTimeout=" + this.getRunTimeout() + ", maxRetryTimes=" + this.getMaxRetryTimes() + ", retryExpression=" + this.getRetryExpression() + ")";
    }

    public TcDagNode(Long id, Long gmtCreate, Long gmtModified, String appId, String name, String alias, String description, Integer isShare, Integer isShow, String inputParams, String outputParams, String type, String detail, String formatType, String formatDetail, String lastUpdateBy, String creator, String modifier, Integer isSupportChatops, String chatopsDetail, Integer runTimeout, Long maxRetryTimes, String retryExpression) {
        this.id = id;
        this.gmtCreate = gmtCreate;
        this.gmtModified = gmtModified;
        this.appId = appId;
        this.name = name;
        this.alias = alias;
        this.description = description;
        this.isShare = isShare;
        this.isShow = isShow;
        this.inputParams = inputParams;
        this.outputParams = outputParams;
        this.type = type;
        this.detail = detail;
        this.formatType = formatType;
        this.formatDetail = formatDetail;
        this.lastUpdateBy = lastUpdateBy;
        this.creator = creator;
        this.modifier = modifier;
        this.isSupportChatops = isSupportChatops;
        this.chatopsDetail = chatopsDetail;
        this.runTimeout = runTimeout;
        this.maxRetryTimes = maxRetryTimes;
        this.retryExpression = retryExpression;
    }

    public TcDagNode() {
    }

    public static class TcDagNodeBuilder {
        private Long id;
        private Long gmtCreate;
        private Long gmtModified;
        private String appId;
        private String name;
        private String alias;
        private String description;
        private Integer isShare;
        private Integer isShow;
        private String inputParams;
        private String outputParams;
        private String type;
        private String detail;
        private String formatType;
        private String formatDetail;
        private String lastUpdateBy;
        private String creator;
        private String modifier;
        private Integer isSupportChatops;
        private String chatopsDetail;
        private Integer runTimeout;
        private Long maxRetryTimes;
        private String retryExpression;

        TcDagNodeBuilder() {
        }

        public TcDagNodeBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public TcDagNodeBuilder gmtCreate(Long gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public TcDagNodeBuilder gmtModified(Long gmtModified) {
            this.gmtModified = gmtModified;
            return this;
        }

        public TcDagNodeBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public TcDagNodeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TcDagNodeBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public TcDagNodeBuilder description(String description) {
            this.description = description;
            return this;
        }

        public TcDagNodeBuilder isShare(Integer isShare) {
            this.isShare = isShare;
            return this;
        }

        public TcDagNodeBuilder isShow(Integer isShow) {
            this.isShow = isShow;
            return this;
        }

        public TcDagNodeBuilder inputParams(String inputParams) {
            this.inputParams = inputParams;
            return this;
        }

        public TcDagNodeBuilder outputParams(String outputParams) {
            this.outputParams = outputParams;
            return this;
        }

        public TcDagNodeBuilder type(String type) {
            this.type = type;
            return this;
        }

        public TcDagNodeBuilder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public TcDagNodeBuilder formatType(String formatType) {
            this.formatType = formatType;
            return this;
        }

        public TcDagNodeBuilder formatDetail(String formatDetail) {
            this.formatDetail = formatDetail;
            return this;
        }

        public TcDagNodeBuilder lastUpdateBy(String lastUpdateBy) {
            this.lastUpdateBy = lastUpdateBy;
            return this;
        }

        public TcDagNodeBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public TcDagNodeBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public TcDagNodeBuilder isSupportChatops(Integer isSupportChatops) {
            this.isSupportChatops = isSupportChatops;
            return this;
        }

        public TcDagNodeBuilder chatopsDetail(String chatopsDetail) {
            this.chatopsDetail = chatopsDetail;
            return this;
        }

        public TcDagNodeBuilder runTimeout(Integer runTimeout) {
            this.runTimeout = runTimeout;
            return this;
        }

        public TcDagNodeBuilder maxRetryTimes(Long maxRetryTimes) {
            this.maxRetryTimes = maxRetryTimes;
            return this;
        }

        public TcDagNodeBuilder retryExpression(String retryExpression) {
            this.retryExpression = retryExpression;
            return this;
        }

        public TcDagNode build() {
            return new TcDagNode(this.id, this.gmtCreate, this.gmtModified, this.appId, this.name, this.alias, this.description, this.isShare, this.isShow, this.inputParams, this.outputParams, this.type, this.detail, this.formatType, this.formatDetail, this.lastUpdateBy, this.creator, this.modifier, this.isSupportChatops, this.chatopsDetail, this.runTimeout, this.maxRetryTimes, this.retryExpression);
        }

        public String toString() {
            return "TcDagNode.TcDagNodeBuilder(id=" + this.id + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + ", appId=" + this.appId + ", name=" + this.name + ", alias=" + this.alias + ", description=" + this.description + ", isShare=" + this.isShare + ", isShow=" + this.isShow + ", inputParams=" + this.inputParams + ", outputParams=" + this.outputParams + ", type=" + this.type + ", detail=" + this.detail + ", formatType=" + this.formatType + ", formatDetail=" + this.formatDetail + ", lastUpdateBy=" + this.lastUpdateBy + ", creator=" + this.creator + ", modifier=" + this.modifier + ", isSupportChatops=" + this.isSupportChatops + ", chatopsDetail=" + this.chatopsDetail + ", runTimeout=" + this.runTimeout + ", maxRetryTimes=" + this.maxRetryTimes + ", retryExpression=" + this.retryExpression + ")";
        }
    }
}

