/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.model.domain;

import com.alibaba.tesla.dag.common.BeanUtil;
import com.alibaba.tesla.dag.model.domain.AbstractTcDag;
import com.alibaba.tesla.dag.model.repository.TcDagOptionsRepository;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Table(uniqueConstraints={@UniqueConstraint(columnNames={"locale", "name"})})
@Entity
@EntityListeners(value={AuditingEntityListener.class})
public class TcDagOptions
extends AbstractTcDag {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    private String locale;
    @Column(length=256)
    private String name;
    @Column(columnDefinition="longtext")
    private String value;

    public static String value(String locale, String name) {
        TcDagOptions dagOptions = BeanUtil.getBean(TcDagOptionsRepository.class).findFirstByLocaleAndName(locale, name);
        if (dagOptions == null) {
            return null;
        }
        return dagOptions.getValue();
    }

    public void upsert() {
        TcDagOptionsRepository dagOptionsRepository = BeanUtil.getBean(TcDagOptionsRepository.class);
        TcDagOptions dagOptions = dagOptionsRepository.findFirstByLocaleAndName(this.locale, this.name);
        this.id = dagOptions == null ? null : dagOptions.getId();
        dagOptionsRepository.saveAndFlush(this);
    }

    @Override
    public void save() {
        BeanUtil.getBean(TcDagOptionsRepository.class).save(this);
    }

    @Override
    public void flush() {
        BeanUtil.getBean(TcDagOptionsRepository.class).flush();
    }

    public static TcDagOptionsBuilder builder() {
        return new TcDagOptionsBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TcDagOptions)) {
            return false;
        }
        TcDagOptions other = (TcDagOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TcDagOptions;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "TcDagOptions(id=" + this.getId() + ", locale=" + this.getLocale() + ", name=" + this.getName() + ", value=" + this.getValue() + ")";
    }

    public TcDagOptions(Long id, String locale, String name, String value) {
        this.id = id;
        this.locale = locale;
        this.name = name;
        this.value = value;
    }

    public TcDagOptions() {
    }

    public static class TcDagOptionsBuilder {
        private Long id;
        private String locale;
        private String name;
        private String value;

        TcDagOptionsBuilder() {
        }

        public TcDagOptionsBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public TcDagOptionsBuilder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public TcDagOptionsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TcDagOptionsBuilder value(String value) {
            this.value = value;
            return this;
        }

        public TcDagOptions build() {
            return new TcDagOptions(this.id, this.locale, this.name, this.value);
        }

        public String toString() {
            return "TcDagOptions.TcDagOptionsBuilder(id=" + this.id + ", locale=" + this.locale + ", name=" + this.name + ", value=" + this.value + ")";
        }
    }
}

