/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.model.domain.dag;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.alibaba.tesla.dag.model.domain.ParamType;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeInputParam;
import com.alibaba.tesla.dag.model.domain.dagnode.ParamFromType;
import java.util.List;

public class DagInputParam {
    String name;
    String alias;
    Object value;
    ParamType type;
    Boolean isOverWrite;

    public DagNodeInputParam toDagNodeInputParam() {
        return DagNodeInputParam.builder().name(this.name).alias(this.alias).value(this.value).type(this.type).isOverWrite(this.isOverWrite).fromType(ParamFromType.CONSTANT).from("").build();
    }

    public Object value() throws Exception {
        if (this.value == null) {
            return null;
        }
        try {
            switch (this.type) {
                case STRING: {
                    return TypeUtils.castToJavaBean((Object)this.value, String.class);
                }
                case OBJECT: {
                    return TypeUtils.castToJavaBean((Object)this.value, JSONObject.class);
                }
                case FLOAT: {
                    return TypeUtils.castToJavaBean((Object)this.value, Float.class);
                }
                case ARRAY: {
                    return TypeUtils.castToJavaBean((Object)this.value, JSONArray.class);
                }
                case LONG: {
                    return TypeUtils.castToJavaBean((Object)this.value, Long.class);
                }
                case BOOLEAN: {
                    return TypeUtils.castToJavaBean((Object)this.value, Boolean.class);
                }
            }
            return this.value;
        }
        catch (Exception e) {
            throw new Exception("value can not match type", e);
        }
    }

    public void check() throws Exception {
        this.value();
    }

    public static void check(List<DagInputParam> inputParamList) throws Exception {
        for (DagInputParam inputParam : inputParamList) {
            inputParam.check();
        }
    }

    public static DagInputParamBuilder builder() {
        return new DagInputParamBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public Object getValue() {
        return this.value;
    }

    public ParamType getType() {
        return this.type;
    }

    public Boolean getIsOverWrite() {
        return this.isOverWrite;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setType(ParamType type) {
        this.type = type;
    }

    public void setIsOverWrite(Boolean isOverWrite) {
        this.isOverWrite = isOverWrite;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DagInputParam)) {
            return false;
        }
        DagInputParam other = (DagInputParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        ParamType this$type = this.getType();
        ParamType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Boolean this$isOverWrite = this.getIsOverWrite();
        Boolean other$isOverWrite = other.getIsOverWrite();
        return !(this$isOverWrite == null ? other$isOverWrite != null : !((Object)this$isOverWrite).equals(other$isOverWrite));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DagInputParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        ParamType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Boolean $isOverWrite = this.getIsOverWrite();
        result = result * 59 + ($isOverWrite == null ? 43 : ((Object)$isOverWrite).hashCode());
        return result;
    }

    public String toString() {
        return "DagInputParam(name=" + this.getName() + ", alias=" + this.getAlias() + ", value=" + this.getValue() + ", type=" + (Object)((Object)this.getType()) + ", isOverWrite=" + this.getIsOverWrite() + ")";
    }

    public DagInputParam() {
    }

    public DagInputParam(String name, String alias, Object value, ParamType type, Boolean isOverWrite) {
        this.name = name;
        this.alias = alias;
        this.value = value;
        this.type = type;
        this.isOverWrite = isOverWrite;
    }

    public static class DagInputParamBuilder {
        private String name;
        private String alias;
        private Object value;
        private ParamType type;
        private Boolean isOverWrite;

        DagInputParamBuilder() {
        }

        public DagInputParamBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DagInputParamBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public DagInputParamBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public DagInputParamBuilder type(ParamType type) {
            this.type = type;
            return this;
        }

        public DagInputParamBuilder isOverWrite(Boolean isOverWrite) {
            this.isOverWrite = isOverWrite;
            return this;
        }

        public DagInputParam build() {
            return new DagInputParam(this.name, this.alias, this.value, this.type, this.isOverWrite);
        }

        public String toString() {
            return "DagInputParam.DagInputParamBuilder(name=" + this.name + ", alias=" + this.alias + ", value=" + this.value + ", type=" + (Object)((Object)this.type) + ", isOverWrite=" + this.isOverWrite + ")";
        }
    }
}

