/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.model.domain.dagnode;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.model.domain.ParamType;
import com.alibaba.tesla.dag.model.domain.dag.DagInputParam;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeParam;
import com.alibaba.tesla.dag.model.domain.dagnode.ParamFromType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DagNodeInputParam
extends DagNodeParam {
    private static final Logger log = LoggerFactory.getLogger(DagNodeInputParam.class);
    String name;
    String alias;
    Object value;
    ParamType type;
    Boolean isOverWrite;
    ParamFromType fromType;
    String from;

    public DagInputParam toDagInputParam() {
        return DagInputParam.builder().name(this.name).alias(this.alias).value(this.value).type(this.type).isOverWrite(this.isOverWrite).build();
    }

    public void setValue(JSONObject jsonObject) {
        String name = (String)this.value;
        if (StringUtils.isEmpty((CharSequence)name)) {
            name = this.name;
        }
        switch (this.type) {
            case BOOLEAN: {
                this.value = jsonObject.getBooleanValue(name);
                break;
            }
            case LONG: {
                this.value = jsonObject.getLongValue(name);
                break;
            }
            case ARRAY: {
                this.value = jsonObject.getJSONArray(name);
                break;
            }
            case FLOAT: {
                this.value = Float.valueOf(jsonObject.getFloatValue(name));
                break;
            }
            case OBJECT: {
                this.value = jsonObject.getJSONObject(name);
                break;
            }
            case STRING: {
                this.value = jsonObject.getString(name);
                break;
            }
            default: {
                this.value = null;
            }
        }
    }

    public static Map<String, Object> toMap(List<DagNodeInputParam> dagNodeInputParamList) {
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        for (DagNodeInputParam dagNodeInputParam : dagNodeInputParamList) {
            map.put(dagNodeInputParam.getName(), dagNodeInputParam.getValue());
        }
        return map;
    }

    public static JSONObject toJson(List<DagNodeInputParam> dagNodeInputParamList) {
        return JSONObject.parseObject((String)JSONObject.toJSONString(DagNodeInputParam.toMap(dagNodeInputParamList)));
    }

    public static void setValue(List<DagNodeInputParam> dagNodeInputParamList, JSONObject globalVariableJson, JSONObject globalResultJson) {
        for (DagNodeInputParam dagNodeInputParam : dagNodeInputParamList) {
            switch (dagNodeInputParam.getFromType()) {
                case FATHER_NODE: {
                    JSONObject jsonObject = globalResultJson.getJSONObject(dagNodeInputParam.getFrom());
                    jsonObject = jsonObject == null ? new JSONObject() : jsonObject;
                    jsonObject = jsonObject.getJSONObject("output");
                    dagNodeInputParam.setValue(jsonObject);
                    break;
                }
                case GLOBAL_VARIABLE: {
                    dagNodeInputParam.setValue(globalVariableJson);
                    break;
                }
            }
        }
    }

    public static List<DagNodeInputParam> toList(JSONArray inputParamArray) {
        inputParamArray = inputParamArray == null ? new JSONArray() : inputParamArray;
        ArrayList<DagNodeInputParam> dagNodeInputParamList = new ArrayList<DagNodeInputParam>();
        for (JSONObject jsonObject : inputParamArray.toJavaList(JSONObject.class)) {
            String name = jsonObject.getString("name");
            String alias = jsonObject.getString("alias");
            Boolean isOverWrite = jsonObject.getBoolean("isOverWrite");
            String type = null;
            if (jsonObject.get((Object)"type") != null) {
                type = jsonObject.getString("type");
            } else {
                log.info("typeIsEmpty, data={}", (Object)JSONObject.toJSONString((Object)jsonObject));
                type = "STRING";
            }
            dagNodeInputParamList.add(DagNodeInputParam.builder().name(name).alias(StringUtils.isEmpty((CharSequence)alias) ? name : alias).value(jsonObject.get((Object)"value")).type(ParamType.valueOf(type.toUpperCase())).isOverWrite(isOverWrite == null ? true : isOverWrite).from(jsonObject.getString("from")).fromType(StringUtils.isEmpty((CharSequence)jsonObject.getString("fromType")) ? ParamFromType.CONSTANT : ParamFromType.valueOf(jsonObject.getString("fromType"))).build());
        }
        return dagNodeInputParamList;
    }

    private static ParamFromType $default$fromType() {
        return ParamFromType.CONSTANT;
    }

    public static DagNodeInputParamBuilder builder() {
        return new DagNodeInputParamBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DagNodeInputParam)) {
            return false;
        }
        DagNodeInputParam other = (DagNodeInputParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        ParamType this$type = this.getType();
        ParamType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Boolean this$isOverWrite = this.getIsOverWrite();
        Boolean other$isOverWrite = other.getIsOverWrite();
        if (this$isOverWrite == null ? other$isOverWrite != null : !((Object)this$isOverWrite).equals(other$isOverWrite)) {
            return false;
        }
        ParamFromType this$fromType = this.getFromType();
        ParamFromType other$fromType = other.getFromType();
        if (this$fromType == null ? other$fromType != null : !((Object)((Object)this$fromType)).equals((Object)other$fromType)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        return !(this$from == null ? other$from != null : !this$from.equals(other$from));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DagNodeInputParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        ParamType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Boolean $isOverWrite = this.getIsOverWrite();
        result = result * 59 + ($isOverWrite == null ? 43 : ((Object)$isOverWrite).hashCode());
        ParamFromType $fromType = this.getFromType();
        result = result * 59 + ($fromType == null ? 43 : ((Object)((Object)$fromType)).hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public Object getValue() {
        return this.value;
    }

    public ParamType getType() {
        return this.type;
    }

    public Boolean getIsOverWrite() {
        return this.isOverWrite;
    }

    public ParamFromType getFromType() {
        return this.fromType;
    }

    public String getFrom() {
        return this.from;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setType(ParamType type) {
        this.type = type;
    }

    public void setIsOverWrite(Boolean isOverWrite) {
        this.isOverWrite = isOverWrite;
    }

    public void setFromType(ParamFromType fromType) {
        this.fromType = fromType;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String toString() {
        return "DagNodeInputParam(name=" + this.getName() + ", alias=" + this.getAlias() + ", value=" + this.getValue() + ", type=" + (Object)((Object)this.getType()) + ", isOverWrite=" + this.getIsOverWrite() + ", fromType=" + (Object)((Object)this.getFromType()) + ", from=" + this.getFrom() + ")";
    }

    public DagNodeInputParam(String name, String alias, Object value, ParamType type, Boolean isOverWrite, ParamFromType fromType, String from) {
        this.name = name;
        this.alias = alias;
        this.value = value;
        this.type = type;
        this.isOverWrite = isOverWrite;
        this.fromType = fromType;
        this.from = from;
    }

    public DagNodeInputParam() {
        this.fromType = DagNodeInputParam.$default$fromType();
    }

    public static class DagNodeInputParamBuilder {
        private String name;
        private String alias;
        private Object value;
        private ParamType type;
        private Boolean isOverWrite;
        private boolean fromType$set;
        private ParamFromType fromType;
        private String from;

        DagNodeInputParamBuilder() {
        }

        public DagNodeInputParamBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DagNodeInputParamBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public DagNodeInputParamBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public DagNodeInputParamBuilder type(ParamType type) {
            this.type = type;
            return this;
        }

        public DagNodeInputParamBuilder isOverWrite(Boolean isOverWrite) {
            this.isOverWrite = isOverWrite;
            return this;
        }

        public DagNodeInputParamBuilder fromType(ParamFromType fromType) {
            this.fromType = fromType;
            this.fromType$set = true;
            return this;
        }

        public DagNodeInputParamBuilder from(String from) {
            this.from = from;
            return this;
        }

        public DagNodeInputParam build() {
            ParamFromType fromType = this.fromType;
            if (!this.fromType$set) {
                fromType = DagNodeInputParam.$default$fromType();
            }
            return new DagNodeInputParam(this.name, this.alias, this.value, this.type, this.isOverWrite, fromType, this.from);
        }

        public String toString() {
            return "DagNodeInputParam.DagNodeInputParamBuilder(name=" + this.name + ", alias=" + this.alias + ", value=" + this.value + ", type=" + (Object)((Object)this.type) + ", isOverWrite=" + this.isOverWrite + ", fromType=" + (Object)((Object)this.fromType) + ", from=" + this.from + ")";
        }
    }
}

