/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.model.domain.dagnode;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.model.domain.ParamType;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeParam;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DagNodeOutputParam
extends DagNodeParam {
    private static final Logger log = LoggerFactory.getLogger(DagNodeOutputParam.class);
    String name;
    String alias;
    ParamType type;

    public static List<DagNodeOutputParam> toList(JSONArray outputParamArray) {
        outputParamArray = outputParamArray == null ? new JSONArray() : outputParamArray;
        ArrayList<DagNodeOutputParam> dagNodeOutputParamList = new ArrayList<DagNodeOutputParam>();
        for (JSONObject jsonObject : outputParamArray.toJavaList(JSONObject.class)) {
            String name = jsonObject.getString("name");
            String alias = jsonObject.getString("alias");
            dagNodeOutputParamList.add(DagNodeOutputParam.builder().name(name).alias(StringUtils.isEmpty((CharSequence)alias) ? name : alias).type(ParamType.valueOf(jsonObject.getString("type").toUpperCase())).build());
        }
        return dagNodeOutputParamList;
    }

    public static DagNodeOutputParamBuilder builder() {
        return new DagNodeOutputParamBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DagNodeOutputParam)) {
            return false;
        }
        DagNodeOutputParam other = (DagNodeOutputParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        ParamType this$type = this.getType();
        ParamType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DagNodeOutputParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        ParamType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public ParamType getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setType(ParamType type) {
        this.type = type;
    }

    public String toString() {
        return "DagNodeOutputParam(name=" + this.getName() + ", alias=" + this.getAlias() + ", type=" + (Object)((Object)this.getType()) + ")";
    }

    public DagNodeOutputParam(String name, String alias, ParamType type) {
        this.name = name;
        this.alias = alias;
        this.type = type;
    }

    public DagNodeOutputParam() {
    }

    public static class DagNodeOutputParamBuilder {
        private String name;
        private String alias;
        private ParamType type;

        DagNodeOutputParamBuilder() {
        }

        public DagNodeOutputParamBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DagNodeOutputParamBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public DagNodeOutputParamBuilder type(ParamType type) {
            this.type = type;
            return this;
        }

        public DagNodeOutputParam build() {
            return new DagNodeOutputParam(this.name, this.alias, this.type);
        }

        public String toString() {
            return "DagNodeOutputParam.DagNodeOutputParamBuilder(name=" + this.name + ", alias=" + this.alias + ", type=" + (Object)((Object)this.type) + ")";
        }
    }
}

