/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.notify.impl;

import com.alibaba.tesla.dag.notify.DagInstNodeTask;
import com.alibaba.tesla.dag.notify.IDagInstNodeTaskNotify;
import com.alibaba.tesla.dag.services.AsyncService;
import com.alibaba.tesla.dag.services.LockService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@ConditionalOnProperty(name={"dag.usage.mode"}, havingValue="jar")
public class LocalDagInstNodeTaskNotify
implements IDagInstNodeTaskNotify {
    private static final Logger log = LoggerFactory.getLogger(LocalDagInstNodeTaskNotify.class);
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private LockService lockService;

    @Override
    public void sendDagInstNodeTask(DagInstNodeTask dagInstNodeTask) {
        String key = dagInstNodeTask.fetchKey();
        if (!this.lockService.tryLock(key)) {
            log.info(">>>localDagInstNodeTaskNotify|sendDagInstNodeTask|already exists|key={}", (Object)key);
            return;
        }
        this.asyncService.doDagInstNodeTask(dagInstNodeTask);
    }
}

