/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.provider.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.provider.DagInstProvider;
import com.alibaba.tesla.dag.repository.domain.DagDO;
import com.alibaba.tesla.dag.services.DagInstNewService;
import com.alibaba.tesla.dag.services.DagNewService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DagInstProviderImpl
implements DagInstProvider {
    private static final Logger log = LoggerFactory.getLogger(DagInstProviderImpl.class);
    @Autowired
    private DagNewService dagNewService;
    @Autowired
    private DagInstNewService dagInstNewService;

    @Override
    public Long submit(String appId, String operator, String channel, String env, JSONObject commonParams, boolean isStandalone) throws Exception {
        log.info(">>>dagInstProvider|submit|enter|appId={}, operator={}, channel={}, env={}, commonParams={}, isStandalone={}", new Object[]{appId, operator, channel, env, commonParams, isStandalone});
        String nameEn = commonParams.getString("nameEn");
        DagDO dagDO = this.dagNewService.getDag(appId, nameEn);
        if (Objects.isNull(dagDO)) {
            log.warn(">>>dagInstProvider|submit|dag does not exist|appId={}, name={}", (Object)appId, (Object)nameEn);
            throw new Exception("dag does not exist!appId=" + appId + ", name=" + nameEn);
        }
        return this.dagInstNewService.submit(dagDO, operator, channel, env, commonParams, isStandalone);
    }
}

