/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.repository.dao;

import com.alibaba.tesla.dag.ApplicationProperties;
import com.alibaba.tesla.dag.common.Tools;
import com.alibaba.tesla.dag.repository.domain.DagInstDO;
import com.alibaba.tesla.dag.repository.domain.DagInstDOExample;
import com.alibaba.tesla.dag.repository.mapper.DagInstDOMapper;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;
import com.alibaba.tesla.dag.util.DateUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DagInstDAO {
    private static final Logger log = LoggerFactory.getLogger(DagInstDAO.class);
    private static List<String> UN_END_STATUS_LIST = Arrays.asList(DagInstStatus.INIT.toString(), DagInstStatus.PRE_RUNNING.toString(), DagInstStatus.RUNNING.toString(), DagInstStatus.POST_RUNNING.toString(), DagInstStatus.WAIT_STOP.toString(), DagInstStatus.STOPPING.toString());
    @Autowired
    private DagInstDOMapper dagInstDOMapper;
    @Autowired
    private ApplicationProperties applicationProperties;

    public List<DagInstDO> listTimeOut(Long begin, Long end) {
        DagInstDOExample example = new DagInstDOExample();
        DagInstDOExample.Criteria criteria = example.createCriteria();
        criteria.andGmtAccessBetween(begin, end);
        criteria.andStatusIn((List)UN_END_STATUS_LIST);
        if (this.applicationProperties.isJarUseMode()) {
            criteria.andStandaloneIpEqualTo(Tools.localIp);
        }
        List<DagInstDO> dagInstDOList = this.dagInstDOMapper.selectByExampleWithBLOBs(example);
        return dagInstDOList;
    }

    public long count(Long dagId, String status) {
        DagInstDOExample example = new DagInstDOExample();
        DagInstDOExample.Criteria criteria = example.createCriteria();
        criteria.andDagIdEqualTo(dagId);
        if (StringUtils.isNotEmpty((CharSequence)status)) {
            criteria.andStatusEqualTo(status);
        }
        return this.dagInstDOMapper.countByExample(example);
    }

    public int insert(DagInstDO dagInstDO) {
        dagInstDO.setGmtCreate(DateUtil.currentSeconds());
        dagInstDO.setGmtModified(DateUtil.currentSeconds());
        dagInstDO.setGmtAccess(DateUtil.currentSeconds());
        dagInstDO.setVersion(0);
        return this.dagInstDOMapper.insertSelective(dagInstDO);
    }

    public DagInstDO getDagInstById(Long id) {
        DagInstDOExample example = new DagInstDOExample();
        DagInstDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        List<DagInstDO> dagInstDOList = this.dagInstDOMapper.selectByExampleWithBLOBs(example);
        if (CollectionUtils.isNotEmpty(dagInstDOList)) {
            return dagInstDOList.get(0);
        }
        return null;
    }

    public DagInstDO getDagInstById(Long id, DagInstStatus dagInstStatus) {
        DagInstDOExample example = new DagInstDOExample();
        DagInstDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        criteria.andStatusEqualTo(dagInstStatus.toString());
        List<DagInstDO> dagInstDOList = this.dagInstDOMapper.selectByExampleWithBLOBs(example);
        if (CollectionUtils.isNotEmpty(dagInstDOList)) {
            return dagInstDOList.get(0);
        }
        return null;
    }

    public int update(DagInstDO dagInstDO) {
        DagInstDOExample example = new DagInstDOExample();
        DagInstDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(dagInstDO.getId());
        dagInstDO.setGmtModified(DateUtil.currentSeconds());
        dagInstDO.setGmtAccess(DateUtil.currentSeconds());
        return this.dagInstDOMapper.updateByExampleSelective(dagInstDO, example);
    }

    public int updateWithVersion(DagInstDO dagInstDO) {
        DagInstDOExample example = new DagInstDOExample();
        DagInstDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(dagInstDO.getId());
        criteria.andVersionLessThan(dagInstDO.getVersion());
        dagInstDO.setGmtModified(DateUtil.currentSeconds());
        dagInstDO.setGmtAccess(DateUtil.currentSeconds());
        return this.dagInstDOMapper.updateByExampleSelective(dagInstDO, example);
    }

    public int updateStatus(Long id, DagInstStatus fromStatus, DagInstStatus toStatus) {
        DagInstDOExample example = new DagInstDOExample();
        DagInstDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        criteria.andStatusEqualTo(fromStatus.toString());
        int count = this.dagInstDOMapper.updateByExampleSelective(DagInstDO.builder().status(toStatus.toString()).gmtModified(DateUtil.currentSeconds()).gmtAccess(DateUtil.currentSeconds()).build(), example);
        log.info(">>>dagInstDAO|updateStatus|{}|dagInstId={}, fromStatus={}, toStatus={}", new Object[]{Objects.equals(count, 0) ? "FAILED" : "SUCCESS", id, fromStatus, toStatus});
        return count;
    }

    public int updateStatusWithDetail(Long id, DagInstStatus toStatus, String statusDetail) {
        DagInstDOExample example = new DagInstDOExample();
        DagInstDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        return this.dagInstDOMapper.updateByExampleSelective(DagInstDO.builder().status(toStatus.toString()).statusDetail(statusDetail).gmtAccess(DateUtil.currentSeconds()).gmtModified(DateUtil.currentSeconds()).build(), example);
    }
}

