/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.repository.dao;

import com.alibaba.tesla.dag.repository.domain.DagInstNodeDO;
import com.alibaba.tesla.dag.repository.domain.DagInstNodeDOExample;
import com.alibaba.tesla.dag.repository.mapper.DagInstNodeDOMapper;
import com.alibaba.tesla.dag.schedule.status.DagInstNodeStatus;
import com.alibaba.tesla.dag.util.DateUtil;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DagInstNodeDAO {
    private static final Logger log = LoggerFactory.getLogger(DagInstNodeDAO.class);
    @Autowired
    private DagInstNodeDOMapper dagInstNodeDOMapper;

    public DagInstNodeDO getDagInstNode(Long dagInstId, String nodeId) {
        DagInstNodeDOExample example = new DagInstNodeDOExample();
        DagInstNodeDOExample.Criteria criteria = example.createCriteria();
        criteria.andDagInstIdEqualTo(dagInstId);
        criteria.andNodeIdEqualTo(nodeId);
        List<DagInstNodeDO> dagInstNodeDOList = this.dagInstNodeDOMapper.selectByExampleWithBLOBs(example);
        if (CollectionUtils.isNotEmpty(dagInstNodeDOList)) {
            return dagInstNodeDOList.get(0);
        }
        return null;
    }

    public DagInstNodeDO getDagInstNode(Long dagInstNodeId) {
        DagInstNodeDOExample example = new DagInstNodeDOExample();
        DagInstNodeDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(dagInstNodeId);
        List<DagInstNodeDO> dagInstNodeDOList = this.dagInstNodeDOMapper.selectByExampleWithBLOBs(example);
        if (CollectionUtils.isNotEmpty(dagInstNodeDOList)) {
            return dagInstNodeDOList.get(0);
        }
        return null;
    }

    public List<DagInstNodeDO> listByRunning(Long dagInstId) {
        DagInstNodeDOExample example = new DagInstNodeDOExample();
        DagInstNodeDOExample.Criteria criteria = example.createCriteria();
        criteria.andDagInstIdEqualTo(dagInstId);
        criteria.andStatusEqualTo(DagInstNodeStatus.RUNNING.toString());
        List<DagInstNodeDO> dagInstNodeDOList = this.dagInstNodeDOMapper.selectByExample(example);
        return dagInstNodeDOList;
    }

    public List<DagInstNodeDO> getSimpleList(Long dagInstId) {
        DagInstNodeDOExample example = new DagInstNodeDOExample();
        DagInstNodeDOExample.Criteria criteria = example.createCriteria();
        criteria.andDagInstIdEqualTo(dagInstId);
        criteria.andNodeIdNotIn((List)Arrays.asList("__pre_node__", "__post_node__"));
        List<DagInstNodeDO> dagInstNodeDOList = this.dagInstNodeDOMapper.selectByExample(example);
        return dagInstNodeDOList;
    }

    public List<DagInstNodeDO> listBySuccess(Long dagInstId) {
        DagInstNodeDOExample example = new DagInstNodeDOExample();
        DagInstNodeDOExample.Criteria criteria = example.createCriteria();
        criteria.andDagInstIdEqualTo(dagInstId);
        criteria.andStatusIn((List)Arrays.asList(DagInstNodeStatus.SUCCESS.toString(), DagInstNodeStatus.MERGE.toString()));
        example.setOrderByClause("`lock_id`");
        List<DagInstNodeDO> dagInstNodeDOList = this.dagInstNodeDOMapper.selectByExampleWithBLOBs(example);
        return dagInstNodeDOList;
    }

    public int insert(DagInstNodeDO dagInstNodeDO) {
        return this.dagInstNodeDOMapper.insertSelective(dagInstNodeDO);
    }

    public int updateStatusWithDetail(Long id, DagInstNodeStatus toStatus, String statusDetail) {
        DagInstNodeDOExample example = new DagInstNodeDOExample();
        DagInstNodeDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        return this.dagInstNodeDOMapper.updateByExampleSelective(DagInstNodeDO.builder().status(toStatus.toString()).lockId(DateUtil.currentTimeMillis()).statusDetail(statusDetail).gmtModified(DateUtil.currentSeconds()).build(), example);
    }

    public int updateStatus(Long id, DagInstNodeStatus toStatus) {
        DagInstNodeDOExample example = new DagInstNodeDOExample();
        DagInstNodeDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        return this.dagInstNodeDOMapper.updateByExampleSelective(DagInstNodeDO.builder().status(toStatus.toString()).lockId(DateUtil.currentTimeMillis()).gmtModified(DateUtil.currentSeconds()).build(), example);
    }

    public int update(DagInstNodeDO dagInstNodeDO) {
        DagInstNodeDOExample example = new DagInstNodeDOExample();
        DagInstNodeDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(dagInstNodeDO.getId());
        dagInstNodeDO.setGmtModified(DateUtil.currentSeconds());
        return this.dagInstNodeDOMapper.updateByExampleSelective(dagInstNodeDO, example);
    }
}

