/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.repository.dao;

import com.alibaba.tesla.dag.ApplicationProperties;
import com.alibaba.tesla.dag.common.Tools;
import com.alibaba.tesla.dag.repository.domain.DagInstNodeStdDO;
import com.alibaba.tesla.dag.repository.domain.DagInstNodeStdDOExample;
import com.alibaba.tesla.dag.repository.mapper.DagInstNodeStdDOMapper;
import com.alibaba.tesla.dag.schedule.task.TaskStatus;
import com.alibaba.tesla.dag.util.DateUtil;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DagInstNodeStdDAO {
    private static final Logger log = LoggerFactory.getLogger(DagInstNodeStdDAO.class);
    public static List<String> UN_END_STATUS_LIST = Arrays.asList(TaskStatus.INIT.toString(), TaskStatus.RUNNING.toString());
    @Autowired
    private DagInstNodeStdDOMapper dagInstNodeStdDOMapper;
    @Autowired
    private ApplicationProperties applicationProperties;

    public int insert(DagInstNodeStdDO dagInstNodeStdDO) {
        dagInstNodeStdDO.setGmtCreate(DateUtil.currentSeconds());
        dagInstNodeStdDO.setGmtModified(DateUtil.currentSeconds());
        dagInstNodeStdDO.setGmtAccess(DateUtil.currentSeconds());
        return this.dagInstNodeStdDOMapper.insertSelective(dagInstNodeStdDO);
    }

    public DagInstNodeStdDO getDagInstNodeStdById(Long id) {
        DagInstNodeStdDOExample example = new DagInstNodeStdDOExample();
        DagInstNodeStdDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        List<DagInstNodeStdDO> dagInstNodeStdDOList = this.dagInstNodeStdDOMapper.selectByExampleWithBLOBs(example);
        if (CollectionUtils.isNotEmpty(dagInstNodeStdDOList)) {
            return dagInstNodeStdDOList.get(0);
        }
        return null;
    }

    public int update(DagInstNodeStdDO dagInstNodeStdDO) {
        DagInstNodeStdDOExample example = new DagInstNodeStdDOExample();
        DagInstNodeStdDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(dagInstNodeStdDO.getId());
        if (StringUtils.equals((CharSequence)dagInstNodeStdDO.getStatus(), (CharSequence)TaskStatus.EXCEPTION.toString())) {
            log.warn(">>>dagInstNodeStdDAO|update|taskStatus is Exception|localTaskId={}", (Object)dagInstNodeStdDO.getId());
        }
        dagInstNodeStdDO.setGmtModified(DateUtil.currentSeconds());
        return this.dagInstNodeStdDOMapper.updateByExampleSelective(dagInstNodeStdDO, example);
    }

    public int updateStatusWithDetail(Long id, TaskStatus toStatus, String statusDetail) {
        DagInstNodeStdDOExample example = new DagInstNodeStdDOExample();
        DagInstNodeStdDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        if (toStatus == TaskStatus.EXCEPTION) {
            log.warn(">>>dagInstNodeStdDAO|updateStatusWithDetail|taskStatus is Exception|localTaskId={}", (Object)id);
        }
        return this.dagInstNodeStdDOMapper.updateByExampleSelective(DagInstNodeStdDO.builder().status(toStatus.toString()).stderr(statusDetail).gmtModified(DateUtil.currentSeconds()).build(), example);
    }

    public List<DagInstNodeStdDO> listTimeOut(Long begin, Long end) {
        DagInstNodeStdDOExample example = new DagInstNodeStdDOExample();
        DagInstNodeStdDOExample.Criteria criteria = example.createCriteria();
        criteria.andGmtAccessBetween(begin, end);
        criteria.andLockIdLike("V2_%");
        criteria.andStatusIn((List)UN_END_STATUS_LIST);
        if (this.applicationProperties.isJarUseMode()) {
            criteria.andStandaloneIpEqualTo(Tools.localIp);
        }
        return this.dagInstNodeStdDOMapper.selectByExample(example);
    }
}

