/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.repository.domain;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.algorithm.DAG;
import com.alibaba.tesla.dag.model.domain.ParamType;
import com.alibaba.tesla.dag.model.domain.dag.DagInputParam;
import com.alibaba.tesla.dag.model.domain.dagnode.ParamFromType;
import com.alibaba.tesla.dag.util.DagUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DagDO {
    private static final Logger log = LoggerFactory.getLogger(DagDO.class);
    private Long id;
    private Long gmtCreate;
    private Long gmtModified;
    private String appId;
    private String name;
    private String alias;
    private Boolean hasFeedback;
    private Boolean hasHistory;
    private String notice;
    private String creator;
    private String modifier;
    private String lastUpdateBy;
    private String exScheduleTaskId;
    private Boolean defaultShowHistory;
    private String content;
    private String inputParams;
    private String description;
    private String entity;
    private JSONObject contentJson;

    public static void main(String[] args) throws Exception {
        DagDO dagDO1 = new DagDO();
        dagDO1.setInputParams("null");
        log.info("{}", dagDO1.fetchInputParamList());
        String content = "{\n  \"nodes\": [\n    {\n      \"shape\": \"rect\",\n      \"data\": {\n        \"defId\": 188491,\n        \"outputParams\": [],\n        \"tooltip\": {},\n        \"inputParams\": [],\n        \"id\": \"FlinkAsiJobResource\",\n        \"label\": \"\u4f5c\u4e1a\u8d44\u6e90\",\n        \"type\": \"NODE\"\n      },\n      \"index\": 2,\n      \"id\": \"FlinkAsiJobResource\",\n      \"label\": \"\u4f5c\u4e1a\u8d44\u6e90\"\n    },\n    {\n      \"shape\": \"rect\",\n      \"data\": {\n        \"defId\": 186490,\n        \"outputParams\": [],\n        \"tooltip\": {},\n        \"inputParams\": [],\n        \"id\": \"FlinkAsiJobStatus\",\n        \"label\": \"\u4f5c\u4e1a\u72b6\u6001\",\n        \"type\": \"NODE\"\n      },\n      \"index\": 0,\n      \"id\": \"FlinkAsiJobStatus\",\n      \"label\": \"\u4f5c\u4e1a\u72b6\u6001\"\n    },\n    {\n      \"shape\": \"rect\",\n      \"data\": {\n        \"defId\": 187969,\n        \"outputParams\": [],\n        \"tooltip\": {},\n        \"inputParams\": [],\n        \"id\": \"FlinkAsiJobGCTime\",\n        \"label\": \"GC\u65f6\u95f4\",\n        \"type\": \"NODE\"\n      },\n      \"index\": 10,\n      \"id\": \"FlinkAsiJobGCTime\",\n      \"label\": \"GC\u65f6\u95f4\"\n    },\n    {\n      \"shape\": \"rect\",\n      \"data\": {\n        \"defId\": 187970,\n        \"outputParams\": [],\n        \"tooltip\": {},\n        \"inputParams\": [],\n        \"id\": \"FlinkAsiJobGCCount\",\n        \"label\": \"GC\u6b21\u6570\",\n        \"type\": \"NODE\"\n      },\n      \"index\": 11,\n      \"id\": \"FlinkAsiJobGCCount\",\n      \"label\": \"GC\u6b21\u6570\"\n    },\n    {\n      \"shape\": \"rect\",\n      \"data\": {\n        \"defId\": 188261,\n        \"outputParams\": [],\n        \"tooltip\": {},\n        \"inputParams\": [],\n        \"id\": \"FlinkAsiJobEvents\",\n        \"label\": \"\u4f5c\u4e1a\u4e8b\u4ef6\",\n        \"type\": \"NODE\"\n      },\n      \"index\": 1,\n      \"id\": \"FlinkAsiJobEvents\",\n      \"label\": \"\u4f5c\u4e1a\u4e8b\u4ef6\"\n    }\n  ],\n  \"edges\": [\n    {\n      \"shape\": \"QuadraticEdge\",\n      \"data\": {\n        \"expression\": \"\"\n      },\n      \"style\": {\n        \"endArrow\": true,\n        \"stroke\": \"#fdad\",\n        \"lineWidth\": 2\n      },\n      \"source\": \"FlinkAsiJobStatus\",\n      \"target\": \"FlinkAsiJobGCCount\"\n    },\n    {\n      \"shape\": \"QuadraticEdge\",\n      \"data\": {\n        \"expression\": \"\"\n      },\n      \"style\": {\n        \"endArrow\": true,\n        \"stroke\": \"#fdad\",\n        \"lineWidth\": 2\n      },\n      \"source\": \"FlinkAsiJobStatus\",\n      \"target\": \"FlinkAsiJobGCTime\"\n    },\n    {\n      \"shape\": \"QuadraticEdge\",\n      \"data\": {\n        \"expression\": \"\"\n      },\n      \"style\": {\n        \"endArrow\": true,\n        \"stroke\": \"#fdad\",\n        \"lineWidth\": 2\n      },\n      \"source\": \"FlinkAsiJobStatus\",\n      \"target\": \"FlinkAsiJobResource\"\n    },\n    {\n      \"shape\": \"QuadraticEdge\",\n      \"data\": {\n        \"expression\": \"\"\n      },\n      \"style\": {\n        \"endArrow\": true,\n        \"stroke\": \"#fdad\",\n        \"lineWidth\": 2\n      },\n      \"source\": \"FlinkAsiJobStatus\",\n      \"target\": \"FlinkAsiJobEvents\"\n    }\n  ]\n}";
        DagDO dagDO = DagDO.builder().content(content).build();
        JSONArray array = new JSONArray();
        array.add((Object)"FlinkAsiJobResource");
        array.add((Object)"FlinkAsiJobStatus");
        dagDO.updateContent(array, null);
        log.info("{}", (Object)JSONObject.toJSONString((Object)dagDO));
        DAG dag = DagUtil.calcDAG(content);
        log.info("{}", (Object)dag.chain());
    }

    public void updateContent(JSONArray selectItemArray, JSONObject itemConfigs) throws Exception {
        this.content = this.fetchNewContent(selectItemArray, itemConfigs);
        boolean isValid = this.isValid();
        if (!isValid) {
            log.error(">>>dagDO|updateContent|invalid dag|content={}", (Object)this.content);
            throw new Exception("invalid dag!content=" + this.content);
        }
    }

    public boolean isValid() {
        return !DagUtil.calcDAG(this.content).isCircularity();
    }

    public String fetchNewContent(JSONArray selectItemArray, JSONObject itemConfigs) {
        JSONArray nodeArray;
        JSONObject contentJson = JSONObject.parseObject((String)this.content);
        if (Objects.isNull(contentJson)) {
            contentJson = new JSONObject();
            contentJson.put("nodes", (Object)new JSONArray());
            contentJson.put("edges", (Object)new JSONArray());
        }
        if (CollectionUtils.isNotEmpty((Collection)selectItemArray)) {
            nodeArray = contentJson.getJSONArray("nodes");
            JSONArray nodeTmp = new JSONArray();
            for (int i = 0; i < nodeArray.size(); ++i) {
                JSONObject node = nodeArray.getJSONObject(i);
                if (!selectItemArray.contains((Object)node.getString("id"))) continue;
                nodeTmp.add((Object)node);
            }
            contentJson.put("nodes", (Object)nodeTmp);
            JSONArray edgeArray = contentJson.getJSONArray("edges");
            JSONArray edgeTmp = new JSONArray();
            for (int i = 0; i < edgeArray.size(); ++i) {
                JSONObject edge = edgeArray.getJSONObject(i);
                if (!selectItemArray.contains((Object)edge.getString("source")) || !selectItemArray.contains((Object)edge.getString("target"))) continue;
                edgeTmp.add((Object)edge);
            }
            contentJson.put("edges", (Object)edgeTmp);
        }
        if (MapUtils.isNotEmpty((Map)itemConfigs)) {
            nodeArray = contentJson.getJSONArray("nodes");
            for (int i = 0; i < nodeArray.size(); ++i) {
                JSONObject node = nodeArray.getJSONObject(i);
                String id = node.getString("id");
                if (!itemConfigs.containsKey((Object)id)) continue;
                JSONArray inputParams = node.getJSONObject("data").getJSONArray("inputParams");
                JSONObject itemConfig = itemConfigs.getJSONObject(id);
                for (int j = 0; j < inputParams.size(); ++j) {
                    JSONObject inputParam = inputParams.getJSONObject(j);
                    String inputParamName = inputParam.getString("name");
                    if (!itemConfig.containsKey((Object)inputParamName)) continue;
                    inputParam.put("fromType", (Object)ParamFromType.CONSTANT.name());
                    inputParam.put("type", (Object)ParamType.STRING.name());
                    inputParam.put("value", (Object)itemConfig.getString(inputParamName));
                }
            }
        }
        return JSONObject.toJSONString((Object)contentJson);
    }

    public List<DagInputParam> fetchInputParamList() {
        if (StringUtils.isEmpty((CharSequence)this.inputParams)) {
            return Collections.emptyList();
        }
        List dagInputParamList = JSONArray.parseArray((String)this.inputParams, DagInputParam.class);
        if (CollectionUtils.isEmpty((Collection)dagInputParamList)) {
            return Collections.emptyList();
        }
        return dagInputParamList;
    }

    public void setInputParamList(List<DagInputParam> inputParamList) throws Exception {
        inputParamList = Objects.isNull(inputParamList) ? Collections.emptyList() : inputParamList;
        for (DagInputParam inputParam : inputParamList) {
            inputParam.check();
        }
        this.inputParams = JSONObject.toJSONString(inputParamList, (boolean)true);
    }

    public static DagDOBuilder builder() {
        return new DagDOBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getGmtCreate() {
        return this.gmtCreate;
    }

    public Long getGmtModified() {
        return this.gmtModified;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public Boolean getHasFeedback() {
        return this.hasFeedback;
    }

    public Boolean getHasHistory() {
        return this.hasHistory;
    }

    public String getNotice() {
        return this.notice;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    public String getExScheduleTaskId() {
        return this.exScheduleTaskId;
    }

    public Boolean getDefaultShowHistory() {
        return this.defaultShowHistory;
    }

    public String getContent() {
        return this.content;
    }

    public String getInputParams() {
        return this.inputParams;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEntity() {
        return this.entity;
    }

    public JSONObject getContentJson() {
        return this.contentJson;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setGmtCreate(Long gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtModified(Long gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setHasFeedback(Boolean hasFeedback) {
        this.hasFeedback = hasFeedback;
    }

    public void setHasHistory(Boolean hasHistory) {
        this.hasHistory = hasHistory;
    }

    public void setNotice(String notice) {
        this.notice = notice;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setLastUpdateBy(String lastUpdateBy) {
        this.lastUpdateBy = lastUpdateBy;
    }

    public void setExScheduleTaskId(String exScheduleTaskId) {
        this.exScheduleTaskId = exScheduleTaskId;
    }

    public void setDefaultShowHistory(Boolean defaultShowHistory) {
        this.defaultShowHistory = defaultShowHistory;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setInputParams(String inputParams) {
        this.inputParams = inputParams;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public void setContentJson(JSONObject contentJson) {
        this.contentJson = contentJson;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DagDO)) {
            return false;
        }
        DagDO other = (DagDO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$gmtCreate = this.getGmtCreate();
        Long other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Long this$gmtModified = this.getGmtModified();
        Long other$gmtModified = other.getGmtModified();
        if (this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        Boolean this$hasFeedback = this.getHasFeedback();
        Boolean other$hasFeedback = other.getHasFeedback();
        if (this$hasFeedback == null ? other$hasFeedback != null : !((Object)this$hasFeedback).equals(other$hasFeedback)) {
            return false;
        }
        Boolean this$hasHistory = this.getHasHistory();
        Boolean other$hasHistory = other.getHasHistory();
        if (this$hasHistory == null ? other$hasHistory != null : !((Object)this$hasHistory).equals(other$hasHistory)) {
            return false;
        }
        String this$notice = this.getNotice();
        String other$notice = other.getNotice();
        if (this$notice == null ? other$notice != null : !this$notice.equals(other$notice)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        String this$lastUpdateBy = this.getLastUpdateBy();
        String other$lastUpdateBy = other.getLastUpdateBy();
        if (this$lastUpdateBy == null ? other$lastUpdateBy != null : !this$lastUpdateBy.equals(other$lastUpdateBy)) {
            return false;
        }
        String this$exScheduleTaskId = this.getExScheduleTaskId();
        String other$exScheduleTaskId = other.getExScheduleTaskId();
        if (this$exScheduleTaskId == null ? other$exScheduleTaskId != null : !this$exScheduleTaskId.equals(other$exScheduleTaskId)) {
            return false;
        }
        Boolean this$defaultShowHistory = this.getDefaultShowHistory();
        Boolean other$defaultShowHistory = other.getDefaultShowHistory();
        if (this$defaultShowHistory == null ? other$defaultShowHistory != null : !((Object)this$defaultShowHistory).equals(other$defaultShowHistory)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$inputParams = this.getInputParams();
        String other$inputParams = other.getInputParams();
        if (this$inputParams == null ? other$inputParams != null : !this$inputParams.equals(other$inputParams)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$entity = this.getEntity();
        String other$entity = other.getEntity();
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
            return false;
        }
        JSONObject this$contentJson = this.getContentJson();
        JSONObject other$contentJson = other.getContentJson();
        return !(this$contentJson == null ? other$contentJson != null : !this$contentJson.equals(other$contentJson));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DagDO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Long $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        Boolean $hasFeedback = this.getHasFeedback();
        result = result * 59 + ($hasFeedback == null ? 43 : ((Object)$hasFeedback).hashCode());
        Boolean $hasHistory = this.getHasHistory();
        result = result * 59 + ($hasHistory == null ? 43 : ((Object)$hasHistory).hashCode());
        String $notice = this.getNotice();
        result = result * 59 + ($notice == null ? 43 : $notice.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        String $lastUpdateBy = this.getLastUpdateBy();
        result = result * 59 + ($lastUpdateBy == null ? 43 : $lastUpdateBy.hashCode());
        String $exScheduleTaskId = this.getExScheduleTaskId();
        result = result * 59 + ($exScheduleTaskId == null ? 43 : $exScheduleTaskId.hashCode());
        Boolean $defaultShowHistory = this.getDefaultShowHistory();
        result = result * 59 + ($defaultShowHistory == null ? 43 : ((Object)$defaultShowHistory).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $inputParams = this.getInputParams();
        result = result * 59 + ($inputParams == null ? 43 : $inputParams.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        JSONObject $contentJson = this.getContentJson();
        result = result * 59 + ($contentJson == null ? 43 : $contentJson.hashCode());
        return result;
    }

    public String toString() {
        return "DagDO(id=" + this.getId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ", appId=" + this.getAppId() + ", name=" + this.getName() + ", alias=" + this.getAlias() + ", hasFeedback=" + this.getHasFeedback() + ", hasHistory=" + this.getHasHistory() + ", notice=" + this.getNotice() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", lastUpdateBy=" + this.getLastUpdateBy() + ", exScheduleTaskId=" + this.getExScheduleTaskId() + ", defaultShowHistory=" + this.getDefaultShowHistory() + ", content=" + this.getContent() + ", inputParams=" + this.getInputParams() + ", description=" + this.getDescription() + ", entity=" + this.getEntity() + ", contentJson=" + this.getContentJson() + ")";
    }

    public DagDO() {
    }

    public DagDO(Long id, Long gmtCreate, Long gmtModified, String appId, String name, String alias, Boolean hasFeedback, Boolean hasHistory, String notice, String creator, String modifier, String lastUpdateBy, String exScheduleTaskId, Boolean defaultShowHistory, String content, String inputParams, String description, String entity, JSONObject contentJson) {
        this.id = id;
        this.gmtCreate = gmtCreate;
        this.gmtModified = gmtModified;
        this.appId = appId;
        this.name = name;
        this.alias = alias;
        this.hasFeedback = hasFeedback;
        this.hasHistory = hasHistory;
        this.notice = notice;
        this.creator = creator;
        this.modifier = modifier;
        this.lastUpdateBy = lastUpdateBy;
        this.exScheduleTaskId = exScheduleTaskId;
        this.defaultShowHistory = defaultShowHistory;
        this.content = content;
        this.inputParams = inputParams;
        this.description = description;
        this.entity = entity;
        this.contentJson = contentJson;
    }

    public static class DagDOBuilder {
        private Long id;
        private Long gmtCreate;
        private Long gmtModified;
        private String appId;
        private String name;
        private String alias;
        private Boolean hasFeedback;
        private Boolean hasHistory;
        private String notice;
        private String creator;
        private String modifier;
        private String lastUpdateBy;
        private String exScheduleTaskId;
        private Boolean defaultShowHistory;
        private String content;
        private String inputParams;
        private String description;
        private String entity;
        private JSONObject contentJson;

        DagDOBuilder() {
        }

        public DagDOBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public DagDOBuilder gmtCreate(Long gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public DagDOBuilder gmtModified(Long gmtModified) {
            this.gmtModified = gmtModified;
            return this;
        }

        public DagDOBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public DagDOBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DagDOBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public DagDOBuilder hasFeedback(Boolean hasFeedback) {
            this.hasFeedback = hasFeedback;
            return this;
        }

        public DagDOBuilder hasHistory(Boolean hasHistory) {
            this.hasHistory = hasHistory;
            return this;
        }

        public DagDOBuilder notice(String notice) {
            this.notice = notice;
            return this;
        }

        public DagDOBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public DagDOBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public DagDOBuilder lastUpdateBy(String lastUpdateBy) {
            this.lastUpdateBy = lastUpdateBy;
            return this;
        }

        public DagDOBuilder exScheduleTaskId(String exScheduleTaskId) {
            this.exScheduleTaskId = exScheduleTaskId;
            return this;
        }

        public DagDOBuilder defaultShowHistory(Boolean defaultShowHistory) {
            this.defaultShowHistory = defaultShowHistory;
            return this;
        }

        public DagDOBuilder content(String content) {
            this.content = content;
            return this;
        }

        public DagDOBuilder inputParams(String inputParams) {
            this.inputParams = inputParams;
            return this;
        }

        public DagDOBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DagDOBuilder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public DagDOBuilder contentJson(JSONObject contentJson) {
            this.contentJson = contentJson;
            return this;
        }

        public DagDO build() {
            return new DagDO(this.id, this.gmtCreate, this.gmtModified, this.appId, this.name, this.alias, this.hasFeedback, this.hasHistory, this.notice, this.creator, this.modifier, this.lastUpdateBy, this.exScheduleTaskId, this.defaultShowHistory, this.content, this.inputParams, this.description, this.entity, this.contentJson);
        }

        public String toString() {
            return "DagDO.DagDOBuilder(id=" + this.id + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + ", appId=" + this.appId + ", name=" + this.name + ", alias=" + this.alias + ", hasFeedback=" + this.hasFeedback + ", hasHistory=" + this.hasHistory + ", notice=" + this.notice + ", creator=" + this.creator + ", modifier=" + this.modifier + ", lastUpdateBy=" + this.lastUpdateBy + ", exScheduleTaskId=" + this.exScheduleTaskId + ", defaultShowHistory=" + this.defaultShowHistory + ", content=" + this.content + ", inputParams=" + this.inputParams + ", description=" + this.description + ", entity=" + this.entity + ", contentJson=" + this.contentJson + ")";
        }
    }
}

