/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.repository.domain;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.model.domain.dagnode.DagInstNodeType;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeInputParam;
import com.alibaba.tesla.dag.repository.domain.DagNodeDO;
import com.alibaba.tesla.dag.schedule.status.DagInstNodeStatus;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DagInstNodeDO {
    private static final Logger log = LoggerFactory.getLogger(DagInstNodeDO.class);
    private Long id;
    private Long gmtCreate;
    private Long gmtModified;
    private Long gmtStart;
    private Long dagInstId;
    private String nodeId;
    private String status;
    private String taskId;
    private String stopTaskId;
    private String lockId;
    private Long subDagInstId;
    private Long retryTimes;
    private String drgSerial;
    private String statusDetail;
    private String tcDagOrNodeDetail;
    private String tcDagContentNodeSpec;
    private String globalParams;
    private String globalObject;
    private String globalResult;
    private JSONObject nodeJson;

    public JSONObject fetchNodeJson() {
        if (MapUtils.isEmpty((Map)this.nodeJson)) {
            this.nodeJson = JSONObject.parseObject((String)this.tcDagContentNodeSpec);
        }
        return this.nodeJson;
    }

    public DagInstNodeType fetchNodeType() {
        return DagInstNodeType.valueOf(this.fetchNodeJson().getJSONObject("data").getString("type"));
    }

    public DagInstNodeStatus fetchNodeStatus() {
        return DagInstNodeStatus.valueOf(this.status);
    }

    public Long fetchDefId() {
        return this.fetchNodeJson().getJSONObject("data").getLongValue("defId");
    }

    public DagNodeDO fetchDagNode() {
        return (DagNodeDO)JSONObject.parseObject((String)this.tcDagOrNodeDetail, DagNodeDO.class);
    }

    public List<DagNodeInputParam> fetchInputParamList() {
        List<DagNodeInputParam> dagNodeInputParamsFromDag = DagNodeInputParam.toList(this.fetchNodeJson().getJSONObject("data").getJSONArray("inputParams"));
        List<DagNodeInputParam> dagNodeInputParamsFromNode = this.fetchDagNode().fetchInputParamList();
        for (DagNodeInputParam dagNodeInputParamFromDag : dagNodeInputParamsFromDag) {
            for (DagNodeInputParam dagNodeInputParamFromNode : dagNodeInputParamsFromNode) {
                if (!dagNodeInputParamFromDag.getName().equals(dagNodeInputParamFromNode.getName())) continue;
                dagNodeInputParamFromDag.setType(dagNodeInputParamFromNode.getType());
            }
        }
        return dagNodeInputParamsFromDag;
    }

    public String toSimpleString() {
        StringBuffer sb = new StringBuffer("DagInstNodeDO{");
        sb.append("id=").append(this.id);
        sb.append(", dagInstId=").append(this.dagInstId);
        sb.append(", nodeId='").append(this.nodeId).append('\'');
        sb.append(", taskId='").append(this.taskId).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static DagInstNodeDOBuilder builder() {
        return new DagInstNodeDOBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getGmtCreate() {
        return this.gmtCreate;
    }

    public Long getGmtModified() {
        return this.gmtModified;
    }

    public Long getGmtStart() {
        return this.gmtStart;
    }

    public Long getDagInstId() {
        return this.dagInstId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getStopTaskId() {
        return this.stopTaskId;
    }

    public String getLockId() {
        return this.lockId;
    }

    public Long getSubDagInstId() {
        return this.subDagInstId;
    }

    public Long getRetryTimes() {
        return this.retryTimes;
    }

    public String getDrgSerial() {
        return this.drgSerial;
    }

    public String getStatusDetail() {
        return this.statusDetail;
    }

    public String getTcDagOrNodeDetail() {
        return this.tcDagOrNodeDetail;
    }

    public String getTcDagContentNodeSpec() {
        return this.tcDagContentNodeSpec;
    }

    public String getGlobalParams() {
        return this.globalParams;
    }

    public String getGlobalObject() {
        return this.globalObject;
    }

    public String getGlobalResult() {
        return this.globalResult;
    }

    public JSONObject getNodeJson() {
        return this.nodeJson;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setGmtCreate(Long gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtModified(Long gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void setGmtStart(Long gmtStart) {
        this.gmtStart = gmtStart;
    }

    public void setDagInstId(Long dagInstId) {
        this.dagInstId = dagInstId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setStopTaskId(String stopTaskId) {
        this.stopTaskId = stopTaskId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public void setSubDagInstId(Long subDagInstId) {
        this.subDagInstId = subDagInstId;
    }

    public void setRetryTimes(Long retryTimes) {
        this.retryTimes = retryTimes;
    }

    public void setDrgSerial(String drgSerial) {
        this.drgSerial = drgSerial;
    }

    public void setStatusDetail(String statusDetail) {
        this.statusDetail = statusDetail;
    }

    public void setTcDagOrNodeDetail(String tcDagOrNodeDetail) {
        this.tcDagOrNodeDetail = tcDagOrNodeDetail;
    }

    public void setTcDagContentNodeSpec(String tcDagContentNodeSpec) {
        this.tcDagContentNodeSpec = tcDagContentNodeSpec;
    }

    public void setGlobalParams(String globalParams) {
        this.globalParams = globalParams;
    }

    public void setGlobalObject(String globalObject) {
        this.globalObject = globalObject;
    }

    public void setGlobalResult(String globalResult) {
        this.globalResult = globalResult;
    }

    public void setNodeJson(JSONObject nodeJson) {
        this.nodeJson = nodeJson;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DagInstNodeDO)) {
            return false;
        }
        DagInstNodeDO other = (DagInstNodeDO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$gmtCreate = this.getGmtCreate();
        Long other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Long this$gmtModified = this.getGmtModified();
        Long other$gmtModified = other.getGmtModified();
        if (this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified)) {
            return false;
        }
        Long this$gmtStart = this.getGmtStart();
        Long other$gmtStart = other.getGmtStart();
        if (this$gmtStart == null ? other$gmtStart != null : !((Object)this$gmtStart).equals(other$gmtStart)) {
            return false;
        }
        Long this$dagInstId = this.getDagInstId();
        Long other$dagInstId = other.getDagInstId();
        if (this$dagInstId == null ? other$dagInstId != null : !((Object)this$dagInstId).equals(other$dagInstId)) {
            return false;
        }
        String this$nodeId = this.getNodeId();
        String other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !this$nodeId.equals(other$nodeId)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$stopTaskId = this.getStopTaskId();
        String other$stopTaskId = other.getStopTaskId();
        if (this$stopTaskId == null ? other$stopTaskId != null : !this$stopTaskId.equals(other$stopTaskId)) {
            return false;
        }
        String this$lockId = this.getLockId();
        String other$lockId = other.getLockId();
        if (this$lockId == null ? other$lockId != null : !this$lockId.equals(other$lockId)) {
            return false;
        }
        Long this$subDagInstId = this.getSubDagInstId();
        Long other$subDagInstId = other.getSubDagInstId();
        if (this$subDagInstId == null ? other$subDagInstId != null : !((Object)this$subDagInstId).equals(other$subDagInstId)) {
            return false;
        }
        Long this$retryTimes = this.getRetryTimes();
        Long other$retryTimes = other.getRetryTimes();
        if (this$retryTimes == null ? other$retryTimes != null : !((Object)this$retryTimes).equals(other$retryTimes)) {
            return false;
        }
        String this$drgSerial = this.getDrgSerial();
        String other$drgSerial = other.getDrgSerial();
        if (this$drgSerial == null ? other$drgSerial != null : !this$drgSerial.equals(other$drgSerial)) {
            return false;
        }
        String this$statusDetail = this.getStatusDetail();
        String other$statusDetail = other.getStatusDetail();
        if (this$statusDetail == null ? other$statusDetail != null : !this$statusDetail.equals(other$statusDetail)) {
            return false;
        }
        String this$tcDagOrNodeDetail = this.getTcDagOrNodeDetail();
        String other$tcDagOrNodeDetail = other.getTcDagOrNodeDetail();
        if (this$tcDagOrNodeDetail == null ? other$tcDagOrNodeDetail != null : !this$tcDagOrNodeDetail.equals(other$tcDagOrNodeDetail)) {
            return false;
        }
        String this$tcDagContentNodeSpec = this.getTcDagContentNodeSpec();
        String other$tcDagContentNodeSpec = other.getTcDagContentNodeSpec();
        if (this$tcDagContentNodeSpec == null ? other$tcDagContentNodeSpec != null : !this$tcDagContentNodeSpec.equals(other$tcDagContentNodeSpec)) {
            return false;
        }
        String this$globalParams = this.getGlobalParams();
        String other$globalParams = other.getGlobalParams();
        if (this$globalParams == null ? other$globalParams != null : !this$globalParams.equals(other$globalParams)) {
            return false;
        }
        String this$globalObject = this.getGlobalObject();
        String other$globalObject = other.getGlobalObject();
        if (this$globalObject == null ? other$globalObject != null : !this$globalObject.equals(other$globalObject)) {
            return false;
        }
        String this$globalResult = this.getGlobalResult();
        String other$globalResult = other.getGlobalResult();
        if (this$globalResult == null ? other$globalResult != null : !this$globalResult.equals(other$globalResult)) {
            return false;
        }
        JSONObject this$nodeJson = this.getNodeJson();
        JSONObject other$nodeJson = other.getNodeJson();
        return !(this$nodeJson == null ? other$nodeJson != null : !this$nodeJson.equals(other$nodeJson));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DagInstNodeDO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Long $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        Long $gmtStart = this.getGmtStart();
        result = result * 59 + ($gmtStart == null ? 43 : ((Object)$gmtStart).hashCode());
        Long $dagInstId = this.getDagInstId();
        result = result * 59 + ($dagInstId == null ? 43 : ((Object)$dagInstId).hashCode());
        String $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : $nodeId.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $stopTaskId = this.getStopTaskId();
        result = result * 59 + ($stopTaskId == null ? 43 : $stopTaskId.hashCode());
        String $lockId = this.getLockId();
        result = result * 59 + ($lockId == null ? 43 : $lockId.hashCode());
        Long $subDagInstId = this.getSubDagInstId();
        result = result * 59 + ($subDagInstId == null ? 43 : ((Object)$subDagInstId).hashCode());
        Long $retryTimes = this.getRetryTimes();
        result = result * 59 + ($retryTimes == null ? 43 : ((Object)$retryTimes).hashCode());
        String $drgSerial = this.getDrgSerial();
        result = result * 59 + ($drgSerial == null ? 43 : $drgSerial.hashCode());
        String $statusDetail = this.getStatusDetail();
        result = result * 59 + ($statusDetail == null ? 43 : $statusDetail.hashCode());
        String $tcDagOrNodeDetail = this.getTcDagOrNodeDetail();
        result = result * 59 + ($tcDagOrNodeDetail == null ? 43 : $tcDagOrNodeDetail.hashCode());
        String $tcDagContentNodeSpec = this.getTcDagContentNodeSpec();
        result = result * 59 + ($tcDagContentNodeSpec == null ? 43 : $tcDagContentNodeSpec.hashCode());
        String $globalParams = this.getGlobalParams();
        result = result * 59 + ($globalParams == null ? 43 : $globalParams.hashCode());
        String $globalObject = this.getGlobalObject();
        result = result * 59 + ($globalObject == null ? 43 : $globalObject.hashCode());
        String $globalResult = this.getGlobalResult();
        result = result * 59 + ($globalResult == null ? 43 : $globalResult.hashCode());
        JSONObject $nodeJson = this.getNodeJson();
        result = result * 59 + ($nodeJson == null ? 43 : $nodeJson.hashCode());
        return result;
    }

    public String toString() {
        return "DagInstNodeDO(id=" + this.getId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ", gmtStart=" + this.getGmtStart() + ", dagInstId=" + this.getDagInstId() + ", nodeId=" + this.getNodeId() + ", status=" + this.getStatus() + ", taskId=" + this.getTaskId() + ", stopTaskId=" + this.getStopTaskId() + ", lockId=" + this.getLockId() + ", subDagInstId=" + this.getSubDagInstId() + ", retryTimes=" + this.getRetryTimes() + ", drgSerial=" + this.getDrgSerial() + ", statusDetail=" + this.getStatusDetail() + ", tcDagOrNodeDetail=" + this.getTcDagOrNodeDetail() + ", tcDagContentNodeSpec=" + this.getTcDagContentNodeSpec() + ", globalParams=" + this.getGlobalParams() + ", globalObject=" + this.getGlobalObject() + ", globalResult=" + this.getGlobalResult() + ", nodeJson=" + this.getNodeJson() + ")";
    }

    public DagInstNodeDO() {
    }

    public DagInstNodeDO(Long id, Long gmtCreate, Long gmtModified, Long gmtStart, Long dagInstId, String nodeId, String status, String taskId, String stopTaskId, String lockId, Long subDagInstId, Long retryTimes, String drgSerial, String statusDetail, String tcDagOrNodeDetail, String tcDagContentNodeSpec, String globalParams, String globalObject, String globalResult, JSONObject nodeJson) {
        this.id = id;
        this.gmtCreate = gmtCreate;
        this.gmtModified = gmtModified;
        this.gmtStart = gmtStart;
        this.dagInstId = dagInstId;
        this.nodeId = nodeId;
        this.status = status;
        this.taskId = taskId;
        this.stopTaskId = stopTaskId;
        this.lockId = lockId;
        this.subDagInstId = subDagInstId;
        this.retryTimes = retryTimes;
        this.drgSerial = drgSerial;
        this.statusDetail = statusDetail;
        this.tcDagOrNodeDetail = tcDagOrNodeDetail;
        this.tcDagContentNodeSpec = tcDagContentNodeSpec;
        this.globalParams = globalParams;
        this.globalObject = globalObject;
        this.globalResult = globalResult;
        this.nodeJson = nodeJson;
    }

    public static class DagInstNodeDOBuilder {
        private Long id;
        private Long gmtCreate;
        private Long gmtModified;
        private Long gmtStart;
        private Long dagInstId;
        private String nodeId;
        private String status;
        private String taskId;
        private String stopTaskId;
        private String lockId;
        private Long subDagInstId;
        private Long retryTimes;
        private String drgSerial;
        private String statusDetail;
        private String tcDagOrNodeDetail;
        private String tcDagContentNodeSpec;
        private String globalParams;
        private String globalObject;
        private String globalResult;
        private JSONObject nodeJson;

        DagInstNodeDOBuilder() {
        }

        public DagInstNodeDOBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public DagInstNodeDOBuilder gmtCreate(Long gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public DagInstNodeDOBuilder gmtModified(Long gmtModified) {
            this.gmtModified = gmtModified;
            return this;
        }

        public DagInstNodeDOBuilder gmtStart(Long gmtStart) {
            this.gmtStart = gmtStart;
            return this;
        }

        public DagInstNodeDOBuilder dagInstId(Long dagInstId) {
            this.dagInstId = dagInstId;
            return this;
        }

        public DagInstNodeDOBuilder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public DagInstNodeDOBuilder status(String status) {
            this.status = status;
            return this;
        }

        public DagInstNodeDOBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public DagInstNodeDOBuilder stopTaskId(String stopTaskId) {
            this.stopTaskId = stopTaskId;
            return this;
        }

        public DagInstNodeDOBuilder lockId(String lockId) {
            this.lockId = lockId;
            return this;
        }

        public DagInstNodeDOBuilder subDagInstId(Long subDagInstId) {
            this.subDagInstId = subDagInstId;
            return this;
        }

        public DagInstNodeDOBuilder retryTimes(Long retryTimes) {
            this.retryTimes = retryTimes;
            return this;
        }

        public DagInstNodeDOBuilder drgSerial(String drgSerial) {
            this.drgSerial = drgSerial;
            return this;
        }

        public DagInstNodeDOBuilder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        public DagInstNodeDOBuilder tcDagOrNodeDetail(String tcDagOrNodeDetail) {
            this.tcDagOrNodeDetail = tcDagOrNodeDetail;
            return this;
        }

        public DagInstNodeDOBuilder tcDagContentNodeSpec(String tcDagContentNodeSpec) {
            this.tcDagContentNodeSpec = tcDagContentNodeSpec;
            return this;
        }

        public DagInstNodeDOBuilder globalParams(String globalParams) {
            this.globalParams = globalParams;
            return this;
        }

        public DagInstNodeDOBuilder globalObject(String globalObject) {
            this.globalObject = globalObject;
            return this;
        }

        public DagInstNodeDOBuilder globalResult(String globalResult) {
            this.globalResult = globalResult;
            return this;
        }

        public DagInstNodeDOBuilder nodeJson(JSONObject nodeJson) {
            this.nodeJson = nodeJson;
            return this;
        }

        public DagInstNodeDO build() {
            return new DagInstNodeDO(this.id, this.gmtCreate, this.gmtModified, this.gmtStart, this.dagInstId, this.nodeId, this.status, this.taskId, this.stopTaskId, this.lockId, this.subDagInstId, this.retryTimes, this.drgSerial, this.statusDetail, this.tcDagOrNodeDetail, this.tcDagContentNodeSpec, this.globalParams, this.globalObject, this.globalResult, this.nodeJson);
        }

        public String toString() {
            return "DagInstNodeDO.DagInstNodeDOBuilder(id=" + this.id + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + ", gmtStart=" + this.gmtStart + ", dagInstId=" + this.dagInstId + ", nodeId=" + this.nodeId + ", status=" + this.status + ", taskId=" + this.taskId + ", stopTaskId=" + this.stopTaskId + ", lockId=" + this.lockId + ", subDagInstId=" + this.subDagInstId + ", retryTimes=" + this.retryTimes + ", drgSerial=" + this.drgSerial + ", statusDetail=" + this.statusDetail + ", tcDagOrNodeDetail=" + this.tcDagOrNodeDetail + ", tcDagContentNodeSpec=" + this.tcDagContentNodeSpec + ", globalParams=" + this.globalParams + ", globalObject=" + this.globalObject + ", globalResult=" + this.globalResult + ", nodeJson=" + this.nodeJson + ")";
        }
    }
}

