/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.schedule;

import com.alibaba.tesla.dag.common.Tools;
import com.alibaba.tesla.dag.model.domain.TcDagServiceNode;
import com.alibaba.tesla.dag.model.repository.TcDagServiceNodeRepository;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"beanUtil"})
public class DagSchedule {
    private static final Logger log = LoggerFactory.getLogger(DagSchedule.class);
    @Autowired
    TcDagServiceNodeRepository dagServiceNodeRepository;
    private ScheduledThreadPoolExecutor initExecutor = new ScheduledThreadPoolExecutor(2, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("%d").daemon(true).build());

    @PostConstruct
    private void init() {
        this.initExecutor.scheduleAtFixedRate(this::upsertNode, 0L, 10L, TimeUnit.SECONDS);
    }

    private void upsertNode() {
        try {
            String ip = Tools.localIp;
            TcDagServiceNode dagServiceNode = this.dagServiceNodeRepository.findFirstByIp(ip);
            if (dagServiceNode == null) {
                dagServiceNode = TcDagServiceNode.builder().ip(ip).enable(1).build();
            }
            dagServiceNode.saveWithTime();
            dagServiceNode.flush();
        }
        catch (Exception e) {
            log.error("upsertNode", (Throwable)e);
        }
    }
}

