/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.schedule.evaluation;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.common.Requests;
import com.alibaba.tesla.dag.model.domain.TcDagInst;
import com.alibaba.tesla.dag.repository.domain.DagInstDO;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EvaluationService {
    private static final Logger log = LoggerFactory.getLogger(EvaluationService.class);
    @Value(value="${evaluation.endpoint:}")
    public String evaluationEndpoint;

    public String create(TcDagInst dagInst) {
        if (StringUtils.isEmpty((CharSequence)this.evaluationEndpoint)) {
            return JSONObject.toJSONString((Object)ImmutableMap.of((Object)"id", (Object)"-2", (Object)"error_info", (Object)"evaluationEndpoint is null"));
        }
        try {
            JSONObject retJson = Requests.post(this.evaluationEndpoint + "/evaluation/create", JSONObject.toJSONString((Object)ImmutableMap.of((Object)"targetAppId", (Object)dagInst.getAppId(), (Object)"targetType", (Object)("\u901a\u7528\u8bca\u65ad-" + dagInst.dag().getName()), (Object)"targetId", (Object)Long.toString(dagInst.getId()), (Object)"modifier", (Object)dagInst.getCreator(), (Object)"tags", (Object)dagInst.channel())), JSONObject.class);
            return JSONObject.toJSONString((Object)retJson.getJSONObject("data"));
        }
        catch (Exception e) {
            log.error("create evaluation error", (Throwable)e);
            return JSONObject.toJSONString((Object)ImmutableMap.of((Object)"id", (Object)"-1", (Object)"error_info", (Object)Throwables.getStackTraceAsString((Throwable)e)));
        }
    }

    public String create(DagInstDO dagInstDO) {
        if (StringUtils.isEmpty((CharSequence)this.evaluationEndpoint)) {
            return JSONObject.toJSONString((Object)ImmutableMap.of((Object)"id", (Object)"-2", (Object)"error_info", (Object)"evaluationEndpoint is null"));
        }
        try {
            JSONObject retJson = Requests.post(this.evaluationEndpoint + "/evaluation/create", JSONObject.toJSONString((Object)ImmutableMap.of((Object)"targetAppId", (Object)dagInstDO.getAppId(), (Object)"targetType", (Object)("\u901a\u7528\u8bca\u65ad-" + dagInstDO.fetchDagDO().getName()), (Object)"targetId", (Object)Long.toString(dagInstDO.getId()), (Object)"modifier", (Object)dagInstDO.getCreator(), (Object)"tags", (Object)dagInstDO.fetchChannel())), JSONObject.class);
            return JSONObject.toJSONString((Object)retJson.getJSONObject("data"));
        }
        catch (Exception e) {
            log.error("create evaluation error", (Throwable)e);
            return JSONObject.toJSONString((Object)ImmutableMap.of((Object)"id", (Object)"-1", (Object)"error_info", (Object)Throwables.getStackTraceAsString((Throwable)e)));
        }
    }
}

