/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.services;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.ApplicationProperties;
import com.alibaba.tesla.dag.model.domain.dag.DagInputParam;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeInputParam;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeType;
import com.alibaba.tesla.dag.repository.domain.DagInstDO;
import com.alibaba.tesla.dag.repository.domain.DagInstNodeDO;
import com.alibaba.tesla.dag.schedule.task.TaskStatus;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractActionNewService {
    private static final Logger log = LoggerFactory.getLogger(AbstractActionNewService.class);
    public static final String OUTPUT_DATA_KEY = "_data";
    public static final String OUTPUT_DATA_OUTPUT_KEY = "output";
    public static final String OUTPUT_DATA_RESULT_KEY = "result";
    public static final String OUTPUT_DATA_DATA_KEY = "data";
    public static final String OUTPUT_DATA_CHATOPS_KEY = "chatops";
    public static final String PARAMS_SPEC_TARGET_ARGS_KEY_START = "_params_spec_target_args_key:";
    public static final String PARAMS_SPEC_TARGET_ARGS_KEY = "_params_spec_target_args";
    public static final String PARAMS_SPEC_TARGET_KEY = "_params_spec_target";
    @Autowired
    protected ApplicationProperties applicationProperties;

    public static String stdoutResult(String stdout) {
        String[] words;
        if (stdout.contains("<result>") && (words = stdout.split("<result>")).length >= 2) {
            stdout = stdout.split("<result>")[1];
        }
        if (stdout.contains("</result>") && (words = stdout.split("</result>")).length >= 1) {
            stdout = stdout.split("</result>")[0];
        }
        return stdout;
    }

    public static JSONObject getData(JSONObject outJson) {
        JSONObject dataJson = new JSONObject();
        if (outJson.containsKey((Object)OUTPUT_DATA_KEY)) {
            return outJson.getJSONObject(OUTPUT_DATA_KEY);
        }
        for (String k : outJson.keySet()) {
            if (k.equals("_global_object") || k.equals("_global_params")) continue;
            dataJson.put(k, outJson.get((Object)k));
        }
        return dataJson;
    }

    public static JSONObject getDataOutput(JSONObject outJson) {
        return AbstractActionNewService.getData(outJson).containsKey((Object)OUTPUT_DATA_OUTPUT_KEY) ? AbstractActionNewService.getData(outJson).getJSONObject(OUTPUT_DATA_OUTPUT_KEY) : new JSONObject();
    }

    public static JSONObject getDataResult(JSONObject outJson) {
        return AbstractActionNewService.getData(outJson).containsKey((Object)OUTPUT_DATA_RESULT_KEY) ? AbstractActionNewService.getData(outJson).getJSONObject(OUTPUT_DATA_RESULT_KEY) : new JSONObject();
    }

    public static JSONObject getDataChatops(JSONObject outJson) {
        return AbstractActionNewService.getData(outJson).containsKey((Object)OUTPUT_DATA_CHATOPS_KEY) ? AbstractActionNewService.getData(outJson).getJSONObject(OUTPUT_DATA_CHATOPS_KEY) : new JSONObject();
    }

    public static <T> T getDataData(JSONObject outJson, Class<T> clazz) {
        return (T)AbstractActionNewService.getData(outJson).getObject(OUTPUT_DATA_DATA_KEY, clazz);
    }

    public static JSONObject getDataResultAndOutput(JSONObject outJson) {
        JSONObject retJson = new JSONObject();
        retJson.put(OUTPUT_DATA_OUTPUT_KEY, (Object)AbstractActionNewService.getDataOutput(outJson));
        retJson.put(OUTPUT_DATA_RESULT_KEY, (Object)AbstractActionNewService.getDataResult(outJson));
        retJson.put(OUTPUT_DATA_CHATOPS_KEY, (Object)AbstractActionNewService.getDataChatops(outJson));
        return retJson;
    }

    public static JSONObject inputParams(DagInstDO dagInst, DagInstNodeDO dagInstNode) {
        List<DagNodeInputParam> dagNodeInputParams = dagInst.fetchDagDO().fetchInputParamList().stream().map(DagInputParam::toDagNodeInputParam).collect(Collectors.toList());
        dagNodeInputParams.addAll(dagInstNode.fetchInputParamList());
        DagNodeInputParam.setValue(dagNodeInputParams, dagInst.fetchGlobalVariableJson(), dagInst.fetchGlobalResultJson());
        return DagNodeInputParam.toJson(dagNodeInputParams);
    }

    public abstract Long start(DagInstDO var1, DagInstNodeDO var2) throws Exception;

    public abstract DagNodeType registerNodeType();

    public abstract TaskStatus status(Long var1) throws Exception;

    public abstract JSONObject stdout(Long var1) throws Exception;

    public abstract String stderr(Long var1) throws Exception;

    public abstract Long stop(Long var1) throws Exception;
}

