/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.services;

import com.alibaba.tesla.dag.notify.DagInstDispatch;
import com.alibaba.tesla.dag.notify.DagInstNodeTask;
import com.alibaba.tesla.dag.notify.NodeTaskType;
import com.alibaba.tesla.dag.services.DagInstNewService;
import com.alibaba.tesla.dag.services.DagInstNodeNewService;
import com.alibaba.tesla.dag.services.LockService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Lazy
public class AsyncService {
    private static final Logger log = LoggerFactory.getLogger(AsyncService.class);
    @Autowired
    private DagInstNewService dagInstNewService;
    @Autowired
    private DagInstNodeNewService dagInstNodeNewService;
    @Autowired
    private LockService lockService;

    @Async(value="instAsyncTaskExecutor")
    public void doDagInstDispatch(DagInstDispatch dagInstDispatch) {
        try {
            log.info(">>>[Inst Receive]|dagInstEvent={}", (Object)dagInstDispatch);
            this.dagInstNewService.doDagInstDispatch(dagInstDispatch);
        }
        catch (Exception e) {
            log.error(">>>asyncService|doDagInstEvent|err={}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Async(value="nodeAsyncTaskExecutor")
    public void doDagInstNodeTask(DagInstNodeTask dagInstNodeTask) {
        try {
            log.info(">>>[Node Receive]|dagInstNodeTask={}", (Object)dagInstNodeTask);
            if (dagInstNodeTask.getNodeTaskType() == NodeTaskType.START) {
                this.dagInstNodeNewService.startDagInstNode(dagInstNodeTask);
            } else if (dagInstNodeTask.getNodeTaskType() == NodeTaskType.INSPECT) {
                this.dagInstNodeNewService.inspectDagInstNode(dagInstNodeTask);
            }
        }
        catch (Exception e) {
            log.error(">>>asyncService|doDagInstNodeTask|err={}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            this.lockService.unLock(dagInstNodeTask.fetchKey());
        }
    }
}

