/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.services;

import com.alibaba.tesla.dag.model.repository.TcDagInstEdgeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeStdRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstRepository;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DagInstClearService {
    private static final Logger log = LoggerFactory.getLogger(DagInstClearService.class);
    @Autowired
    private TcDagInstRepository dagInstRepository;
    @Autowired
    private TcDagInstNodeRepository dagInstNodeRepository;
    @Autowired
    private TcDagInstEdgeRepository tcDagInstEdgeRepository;
    @Autowired
    private TcDagInstNodeStdRepository tcDagInstNodeStdRepository;

    public void clearDataBefore(Date date) {
        long seconds = date.getTime() / 1000L;
        long beginTimeMillis = System.currentTimeMillis();
        try {
            int delete4DagInst = this.dagInstRepository.deleteByGmtCreate(seconds);
            int delete4DagInstNode = this.dagInstNodeRepository.deleteByGmtCreate(seconds);
            int delete4DagInstEdge = this.tcDagInstEdgeRepository.deleteByGmtCreate(seconds);
            int delete4DagInstNodeStd = this.tcDagInstNodeStdRepository.deleteByGmtCreate(seconds);
            log.info(">>>dagInstClearService|clearDataBefore|exit|costTime={}, delete4DagInst={}, delete4DagInstNode={}, delete4DagInstEdge={}, delete4DagInstNodeStd={}", new Object[]{System.currentTimeMillis() - beginTimeMillis, delete4DagInst, delete4DagInstNode, delete4DagInstEdge, delete4DagInstNodeStd});
        }
        catch (Exception e) {
            log.error(">>>dagInstClearService|clearDataBefore|err={}", (Object)e.getMessage(), (Object)e);
        }
    }
}

