/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.services;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.ApplicationProperties;
import com.alibaba.tesla.dag.algorithm.DAG;
import com.alibaba.tesla.dag.common.Tools;
import com.alibaba.tesla.dag.dispatch.IDagInstDispatcher;
import com.alibaba.tesla.dag.model.domain.dag.DagInputParam;
import com.alibaba.tesla.dag.model.domain.dagnode.DagInstNodeType;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeInputParam;
import com.alibaba.tesla.dag.notify.DagInstDispatch;
import com.alibaba.tesla.dag.notify.DagInstNodeTask;
import com.alibaba.tesla.dag.notify.IDagInstNodeTaskNotify;
import com.alibaba.tesla.dag.notify.IDagInstNotify;
import com.alibaba.tesla.dag.notify.NodeTaskType;
import com.alibaba.tesla.dag.repository.dao.DagBatchDAO;
import com.alibaba.tesla.dag.repository.dao.DagDAO;
import com.alibaba.tesla.dag.repository.dao.DagInstDAO;
import com.alibaba.tesla.dag.repository.dao.DagInstNodeDAO;
import com.alibaba.tesla.dag.repository.dao.DagNodeDAO;
import com.alibaba.tesla.dag.repository.domain.DagDO;
import com.alibaba.tesla.dag.repository.domain.DagInstDO;
import com.alibaba.tesla.dag.repository.domain.DagInstEdgeDO;
import com.alibaba.tesla.dag.repository.domain.DagInstNodeDO;
import com.alibaba.tesla.dag.repository.domain.DagNodeDO;
import com.alibaba.tesla.dag.schedule.event.DagInstStatusEvent;
import com.alibaba.tesla.dag.schedule.status.DagInstEdgeStatus;
import com.alibaba.tesla.dag.schedule.status.DagInstNodeStatus;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;
import com.alibaba.tesla.dag.util.DagUtil;
import com.alibaba.tesla.dag.util.DateUtil;
import com.alibaba.tesla.dag.util.IPUtil;
import com.alibaba.tesla.dag.util.MonitorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;

@Service
public class DagInstNewService {
    private static final Logger log = LoggerFactory.getLogger(DagInstNewService.class);
    private static List<DagInstStatus> RUNNING_LIST = Arrays.asList(DagInstStatus.PRE_RUNNING, DagInstStatus.RUNNING, DagInstStatus.POST_RUNNING);
    @Autowired
    private DagInstDAO dagInstDAO;
    @Autowired
    private DagInstNodeDAO dagInstNodeDAO;
    @Autowired
    private DagDAO dagDAO;
    @Autowired
    private IDagInstNotify dagInstNotify;
    @Autowired
    private List<IDagInstDispatcher> handlerList;
    @Autowired
    private IDagInstNodeTaskNotify dagInstNodeTaskNotify;
    @Autowired
    private DagBatchDAO dagBatchDAO;
    @Autowired
    private DagNodeDAO dagNodeDAO;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private ApplicationContext applicationContext;

    private static String getTag(String entityValue) {
        return StringUtils.substring((String)entityValue, (int)0, (int)128);
    }

    private static boolean isDelete(String global) {
        return StringUtils.equals((CharSequence)"__DEL__", (CharSequence)global);
    }

    private static List<DagInstNodeDO> topologySortByDag(List<DagInstNodeDO> dagInstNodeDOList, DAG dag) {
        ArrayList<DagInstNodeDO> result = new ArrayList<DagInstNodeDO>(dagInstNodeDOList.size());
        List topologySortList = dag.topologySort();
        log.info(">>>dagInstNewService|topologySortByDag|topology={}", (Object)JSON.toJSONString((Object)topologySortList));
        topologySortList.stream().forEach(sort -> result.add(DagInstNewService.findByNodeId(dagInstNodeDOList, sort.toString())));
        return result;
    }

    private static DagInstNodeDO findByNodeId(List<DagInstNodeDO> dagInstNodeDOList, String nodeId) {
        return dagInstNodeDOList.stream().filter(dagInstNodeDO -> StringUtils.equals((CharSequence)dagInstNodeDO.getNodeId(), (CharSequence)nodeId)).findFirst().orElse(null);
    }

    public Long submit(DagDO dagDO, String operator, String channel, String env, JSONObject commonParams, boolean isStandalone) throws Exception {
        String entityValue;
        log.info(">>>dagInstNewService|submit|enter|dagName={}, channel={}, env={}, commonParams={}, isStandalone={}", new Object[]{dagDO.getName(), channel, env, commonParams, isStandalone});
        boolean entityValueIsTargetKey = commonParams.getBooleanValue("entityValueIsTargetKey");
        JSONArray selectItemArray = commonParams.getJSONArray("selectItems");
        JSONObject itemConfigs = commonParams.getJSONObject("itemConfigs");
        JSONObject globalVariable = commonParams.getJSONObject("configs");
        if (Objects.isNull(globalVariable)) {
            globalVariable = new JSONObject();
        }
        if (StringUtils.isNotEmpty((CharSequence)(entityValue = commonParams.getString("entityValue")))) {
            List<String> hostList = IPUtil.toIpList(entityValue);
            if (CollectionUtils.isEmpty(hostList) || entityValueIsTargetKey) {
                hostList = Arrays.asList(StringUtils.split((String)entityValue, (String)","));
            }
            if (CollectionUtils.isNotEmpty(hostList)) {
                globalVariable.put("_params_spec_target", hostList);
                globalVariable.put("_params_spec_target_args", hostList);
            }
        }
        dagDO.updateContent(selectItemArray, itemConfigs);
        DagInstDO dagInst = DagInstDO.builder().appId(dagDO.getAppId()).dagId(dagDO.getId()).lockId(IPUtil.getLockId()).tcDagDetail(JSONObject.toJSONString((Object)dagDO)).status(DagInstStatus.INIT.toString()).globalVariable(JSONObject.toJSONString((Object)globalVariable)).globalParams(JSONObject.toJSONString((Object)new JSONObject())).channel(channel).env(env).tag(DagInstNewService.getTag(entityValue)).creator(operator).isSub(false).standaloneIp(isStandalone || this.applicationProperties.isJarUseMode() ? Tools.localIp : "").build();
        this.dagInstDAO.insert(dagInst);
        this.dagInstNotify.sendDagInstDispatch(DagInstDispatch.builder().dagInstId(dagInst.getId()).dagInstStatus(DagInstStatus.INIT).build());
        return dagInst.getId();
    }

    public Long submitSub(DagInstNodeDO dagInstNodeDO, DagInstDO parentDagInstDO) throws Exception {
        Long dagId = dagInstNodeDO.fetchDefId();
        log.info(">>>[SubmitSub]|dagInstId={}, nodeId={}, dagId={}", new Object[]{dagInstNodeDO.getDagInstId(), dagInstNodeDO.getNodeId(), dagId});
        DagDO dagDO = this.dagDAO.getDagById(dagId);
        if (Objects.isNull(dagDO)) {
            log.warn(">>>dagInstNewService|submitSub|dag does not exist|dagId={}", (Object)dagId);
            throw new Exception("dag does not exist!dagId=" + dagId);
        }
        JSONObject globalVariableJson = parentDagInstDO.fetchGlobalVariableJson();
        JSONObject globalParamsJson = parentDagInstDO.fetchGlobalParamsJson();
        DagInstDO subDagInst = DagInstDO.builder().appId(dagDO.getAppId()).dagId(dagDO.getId()).lockId(IPUtil.getLockId()).status(DagInstStatus.INIT.toString()).globalVariable(JSONObject.toJSONString((Object)globalVariableJson)).globalParams(JSONObject.toJSONString((Object)globalParamsJson)).globalObject(parentDagInstDO.getGlobalObject()).channel(parentDagInstDO.getChannel()).env(parentDagInstDO.getEnv()).creator(parentDagInstDO.getCreator()).standaloneIp(parentDagInstDO.getStandaloneIp()).fatherDagInstNodeId(dagInstNodeDO.getId()).isSub(true).build();
        subDagInst.setRelationNode(dagInstNodeDO);
        List<DagNodeInputParam> dagNodeInputParamList = dagInstNodeDO.fetchInputParamList();
        List<DagInputParam> subDagInputParamList = dagDO.fetchInputParamList();
        subDagInputParamList.addAll(dagNodeInputParamList.stream().map(DagNodeInputParam::toDagInputParam).collect(Collectors.toList()));
        dagDO.setInputParamList(subDagInputParamList);
        subDagInst.setTcDagDetail(JSONObject.toJSONString((Object)dagDO));
        this.dagInstDAO.insert(subDagInst);
        this.dagInstNotify.sendDagInstDispatch(DagInstDispatch.builder().dagInstId(subDagInst.getId()).dagInstStatus(DagInstStatus.INIT).build());
        return subDagInst.getId();
    }

    public void doDagInstDispatch(DagInstDispatch dagInstDispatch) {
        long beginTime = System.currentTimeMillis();
        IDagInstDispatcher iDagInstDispatcher = this.handlerList.stream().filter(handler -> handler.registerType() == dagInstDispatch.getDagInstStatus()).findFirst().orElse(null);
        if (Objects.nonNull(iDagInstDispatcher)) {
            DagInstDO dagInstDO = this.dagInstDAO.getDagInstById(dagInstDispatch.getDagInstId(), dagInstDispatch.getDagInstStatus());
            if (Objects.isNull(dagInstDO)) {
                log.info(">>>dagInstNewService|doDagInstDispatch|dagInstDO not exist|dagInstDispatch={}", (Object)dagInstDispatch);
                return;
            }
            DagDO dagDO = dagInstDO.fetchDagDO();
            if (Objects.isNull(dagDO)) {
                log.info(">>>dagInstNewService|doDagInstDispatch|dagDO not exist");
                return;
            }
            iDagInstDispatcher.dispatch(dagInstDO);
        }
        MonitorUtil.instMonitor.addCost(System.currentTimeMillis() - beginTime);
    }

    public void inspectDagInstNode(DagInstDO dagInstDO) {
        DagInstStatus nodeStatus = dagInstDO.fetchStatus();
        if (RUNNING_LIST.contains((Object)nodeStatus)) {
            List<DagInstNodeDO> dagInstNodeList = this.dagInstNodeDAO.listByRunning(dagInstDO.getId());
            for (DagInstNodeDO dagInstNode : dagInstNodeList) {
                DagInstNodeTask dagInstNodeTask = DagInstNodeTask.builder().dagInstId(dagInstNode.getDagInstId()).nodeId(dagInstNode.getNodeId()).nodeTaskType(NodeTaskType.INSPECT).build();
                this.dagInstNodeTaskNotify.sendDagInstNodeTask(dagInstNodeTask);
            }
        }
    }

    public void doDagInstDispatch(DagInstDO dagInstDO) {
        if (Objects.isNull(dagInstDO)) {
            return;
        }
        IDagInstDispatcher iDagInstDispatcher = this.handlerList.stream().filter(handler -> handler.registerType() == dagInstDO.fetchStatus()).findFirst().orElse(null);
        if (Objects.nonNull(iDagInstDispatcher)) {
            iDagInstDispatcher.dispatch(dagInstDO);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public DagInstDispatch initInst(DagInstDO dagInstDO, DagInstStatus dagInstStatus) {
        JSONObject postNode;
        Long dagInstId = dagInstDO.getId();
        JSONObject contentJson = JSONObject.parseObject((String)dagInstDO.fetchDagDO().getContent());
        JSONArray nodeArray = contentJson.getJSONArray("nodes");
        List<DagInstNodeDO> dagInstNodeDOList = new ArrayList<DagInstNodeDO>();
        JSONObject preNode = contentJson.getJSONObject("__pre_node__");
        if (Objects.nonNull(preNode)) {
            preNode.put("id", (Object)"__pre_node__");
            dagInstNodeDOList.add(this.getDagInstNodeDO(dagInstDO, preNode));
        }
        if (Objects.nonNull(postNode = contentJson.getJSONObject("__post_node__"))) {
            postNode.put("id", (Object)"__post_node__");
            dagInstNodeDOList.add(this.getDagInstNodeDO(dagInstDO, postNode));
        }
        for (int i = 0; i < nodeArray.size(); ++i) {
            JSONObject node = nodeArray.getJSONObject(i);
            dagInstNodeDOList.add(this.getDagInstNodeDO(dagInstDO, node));
        }
        JSONArray edgeArray = contentJson.getJSONArray("edges");
        ArrayList<DagInstEdgeDO> dagInstEdgeDOList = new ArrayList<DagInstEdgeDO>();
        for (int i = 0; i < edgeArray.size(); ++i) {
            JSONObject edge = edgeArray.getJSONObject(i);
            dagInstEdgeDOList.add(this.getDagInstEdgeDO(dagInstDO, edge));
        }
        DAG dag = DagUtil.calcDAG(dagInstNodeDOList, dagInstEdgeDOList);
        dagInstNodeDOList = DagInstNewService.topologySortByDag(dagInstNodeDOList, dag);
        this.dagBatchDAO.batchInsertNode(dagInstNodeDOList);
        this.dagBatchDAO.batchInsertEdge(dagInstEdgeDOList);
        DagInstDispatch dagInstDispatch = DagInstDispatch.builder().dagInstId(dagInstId).build();
        if (Objects.nonNull(preNode)) {
            this.freshInstStatus(dagInstDO, dagInstStatus, DagInstStatus.PRE_RUNNING);
            dagInstDispatch.setDagInstStatus(DagInstStatus.PRE_RUNNING);
        } else {
            this.freshInstStatus(dagInstDO, dagInstStatus, DagInstStatus.RUNNING);
            dagInstDispatch.setDagInstStatus(DagInstStatus.RUNNING);
        }
        return dagInstDispatch;
    }

    public void freshInstStatus(DagInstDO dagInstDO, DagInstStatus fromStatus, DagInstStatus toStatus) {
        this.dagInstDAO.updateStatus(dagInstDO.getId(), fromStatus, toStatus);
        this.doOnInstIsEnd(dagInstDO, toStatus);
        this.publishInstStatusEvent(dagInstDO, fromStatus, toStatus);
    }

    public void freshInstStatusWithDetail(DagInstDO dagInstDO, DagInstStatus fromStatus, DagInstStatus toStatus, String statusDetail) {
        this.dagInstDAO.updateStatusWithDetail(dagInstDO.getId(), toStatus, statusDetail);
        this.doOnInstIsEnd(dagInstDO, toStatus);
        this.publishInstStatusEvent(dagInstDO, fromStatus, toStatus);
    }

    private void publishInstStatusEvent(DagInstDO dagInstDO, DagInstStatus fromStatus, DagInstStatus toStatus) {
        if (this.applicationProperties.isJarUseMode()) {
            DagInstStatusEvent dagInstStatusEvent = new DagInstStatusEvent(this, dagInstDO.getId(), fromStatus, toStatus);
            log.info(">>>dagInstNewService|publishInstStatusEvent|dagInstStatusEvent={}", (Object)dagInstStatusEvent);
            this.applicationContext.publishEvent((ApplicationEvent)dagInstStatusEvent);
        }
    }

    private DagInstNodeDO getDagInstNodeDO(DagInstDO dagInstDO, JSONObject node) {
        String nodeId = node.getString("id");
        return DagInstNodeDO.builder().gmtCreate(DateUtil.currentSeconds()).gmtModified(DateUtil.currentSeconds()).gmtStart(999999999999999L).lockId("0").dagInstId(dagInstDO.getId()).tcDagContentNodeSpec(JSONObject.toJSONString((Object)node)).status(DagInstNodeStatus.INIT.toString()).nodeId(nodeId).tcDagOrNodeDetail(this.getDagOrNodeDetail(node)).build();
    }

    private DagInstEdgeDO getDagInstEdgeDO(DagInstDO dagInstDO, JSONObject edge) {
        return DagInstEdgeDO.builder().gmtCreate(DateUtil.currentSeconds()).gmtModified(DateUtil.currentSeconds()).dagInstId(dagInstDO.getId()).source(edge.getString("source")).target(edge.getString("target")).label(edge.getString("label")).shape(edge.getString("shape")).style(edge.getString("style")).data(edge.getString("data")).status(DagInstEdgeStatus.INIT.toString()).build();
    }

    private String getDagOrNodeDetail(JSONObject nodeJson) {
        JSONObject dataJson = nodeJson.getJSONObject("data");
        DagInstNodeType type = DagInstNodeType.valueOf(dataJson.getString("type"));
        Long defId = dataJson.getLong("defId");
        if (type == DagInstNodeType.DAG) {
            DagDO dagDO = this.dagDAO.getDagById(defId);
            return JSONObject.toJSONString((Object)dagDO);
        }
        if (type == DagInstNodeType.NODE) {
            DagNodeDO dagNodeDO = this.dagNodeDAO.getDagNodeById(defId);
            String formatType = dataJson.getString("format_type");
            String formatDetail = dataJson.getString("format_detail");
            Long maxRetryTimes = dataJson.getLong("maxRetryTimes");
            String retryExpression = dataJson.getString("retryExpression");
            Long runTimeout = dataJson.getLong("runTimeout");
            if (StringUtils.isNotEmpty((CharSequence)formatType)) {
                dagNodeDO.setFormatType(formatType);
            }
            if (StringUtils.isNotEmpty((CharSequence)formatDetail)) {
                dagNodeDO.setFormatDetail(formatDetail);
            }
            if (Objects.nonNull(maxRetryTimes)) {
                dagNodeDO.setMaxRetryTimes(maxRetryTimes);
            }
            if (StringUtils.isNotEmpty((CharSequence)retryExpression)) {
                dagNodeDO.setRetryExpression(retryExpression);
            }
            if (Objects.nonNull(runTimeout)) {
                dagNodeDO.setRunTimeout(runTimeout);
            }
            return JSONObject.toJSONString((Object)dagNodeDO);
        }
        return null;
    }

    private void doOnInstIsEnd(DagInstDO dagInstDO, DagInstStatus toStatus) {
        if (toStatus.isEnd()) {
            Long dagInstId = dagInstDO.fetchRelationInstId();
            String nodeId = dagInstDO.fetchRelationNodeId();
            if (Objects.nonNull(dagInstId) && StringUtils.isNotEmpty((CharSequence)nodeId)) {
                DagInstNodeTask dagInstNodeTask = DagInstNodeTask.builder().dagInstId(dagInstId).nodeId(nodeId).nodeTaskType(NodeTaskType.INSPECT).build();
                this.dagInstNodeTaskNotify.sendDagInstNodeTask(dagInstNodeTask);
            }
            log.info(">>>dagInstNewService|doOnInstIsEnd|dagInstId={}, toStatus={}", (Object)dagInstDO.getId(), (Object)toStatus);
        }
    }

    public void freshGlobalData(Long dagInstId) {
        List<DagInstNodeDO> successNodeList = this.dagInstNodeDAO.listBySuccess(dagInstId);
        List nodeIdList = successNodeList.stream().map(dagInstNodeDO -> dagInstNodeDO.getNodeId()).collect(Collectors.toList());
        log.info(">>>dagInstNewService|freshGlobalData|dagInstId={}, nodeIdList={}", (Object)dagInstId, nodeIdList);
        DagInstDO updateDagInst = DagInstDO.builder().id(dagInstId).build();
        for (DagInstNodeDO successNode : successNodeList) {
            this.updateInstGlobalObject(updateDagInst, successNode);
            this.updateInstGlobalParams(updateDagInst, successNode);
            this.updateInstGlobalResult(updateDagInst, successNode);
        }
        updateDagInst.setVersion(CollectionUtils.size(nodeIdList));
        int count = this.dagInstDAO.updateWithVersion(updateDagInst);
        log.info(">>>dagInstNewService|freshGlobalData|exit|dagInstId={}, count={}", (Object)dagInstId, (Object)count);
    }

    private void updateInstGlobalObject(DagInstDO dagInstDO, DagInstNodeDO dagInstNodeDO) {
        String globalObject = dagInstNodeDO.getGlobalObject();
        if (StringUtils.isEmpty((CharSequence)globalObject) || StringUtils.equals((CharSequence)"N.", (CharSequence)globalObject)) {
            return;
        }
        if (DagInstNewService.isDelete(globalObject)) {
            dagInstDO.setGlobalObject("N.");
        } else {
            dagInstDO.setGlobalObject(globalObject);
        }
    }

    private JSONObject mergeJsonObject(JSONObject j1, JSONObject j2) {
        JSONObject retJson = new JSONObject();
        retJson.putAll((Map)j1);
        retJson.putAll((Map)j2);
        for (String key : j1.keySet()) {
            if (!j2.containsKey((Object)key)) continue;
            Object value1 = JSON.toJSON((Object)j1.get((Object)key));
            Object value2 = JSON.toJSON((Object)j2.get((Object)key));
            if (!(value1 instanceof JSONObject) || !(value2 instanceof JSONObject)) continue;
            retJson.put(key, (Object)this.mergeJsonObject((JSONObject)value1, (JSONObject)value2));
        }
        return retJson;
    }

    private void updateInstGlobalParams(DagInstDO dagInstDO, DagInstNodeDO dagInstNodeDO) {
        JSONObject globalParamsJson;
        String globalParams = dagInstNodeDO.getGlobalParams();
        if (DagInstNewService.isDelete(globalParams)) {
            globalParamsJson = new JSONObject();
        } else {
            globalParamsJson = JSONObject.parseObject((String)globalParams);
            if (Objects.isNull(globalParamsJson)) {
                globalParamsJson = new JSONObject();
            }
            globalParamsJson = this.mergeJsonObject(dagInstDO.fetchGlobalParamsJson(), globalParamsJson);
        }
        dagInstDO.setGlobalParams(globalParamsJson.toJSONString());
        if (StringUtils.isNotEmpty((CharSequence)dagInstDO.getGlobalParams())) {
            log.info(">>>dagInstNewService|setGlobalParams|merge node globalParams to inst|dagInstId={}, nodeId={}, md5={}", new Object[]{dagInstNodeDO.getDagInstId(), dagInstNodeDO.getNodeId(), DigestUtils.md5DigestAsHex((byte[])dagInstDO.getGlobalParams().getBytes())});
        }
    }

    private void updateInstGlobalResult(DagInstDO dagInstDO, DagInstNodeDO dagInstNodeDO) {
        JSONObject globalResultJson = dagInstDO.fetchGlobalResultJson();
        globalResultJson.put(dagInstNodeDO.getNodeId(), (Object)JSONObject.parseObject((String)dagInstNodeDO.getGlobalResult()));
        dagInstDO.setGlobalResult(JSONObject.toJSONString((Object)globalResultJson));
    }

    public DagInstDO getDagInstById(Long dagInstId) {
        log.info(">>>dagInstNewService|getDagInstById|externalCall|dagInstId={}", (Object)dagInstId);
        return this.dagInstDAO.getDagInstById(dagInstId);
    }
}

