/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.services;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.model.domain.TcDagInst;
import com.alibaba.tesla.dag.model.domain.TcDagInstNode;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeFormatType;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstRepository;
import com.alibaba.tesla.dag.provider.DagInstProvider;
import com.alibaba.tesla.dag.schedule.status.DagInstNodeStatus;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;
import com.alibaba.tesla.dag.services.AbstractActionNewService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@DependsOn(value={"beanUtil"})
public class DagInstService {
    private static final Logger log = LoggerFactory.getLogger(DagInstService.class);
    @Autowired
    private DagInstProvider dagInstProvider;
    @Autowired
    private TcDagInstNodeRepository dagInstNodeRepository;
    @Autowired
    private TcDagInstRepository dagInstRepository;

    public Long start(String appId, String name, JSONObject globalVariable, String operator, boolean isStandalone) throws Exception {
        JSONObject commonParams = new JSONObject();
        commonParams.put("nameEn", (Object)name);
        commonParams.put("configs", (Object)globalVariable);
        return this.dagInstProvider.submit(appId, operator, "", "", commonParams, isStandalone);
    }

    public Long start(String appId, String name, JSONObject globalVariable, boolean isStandalone) throws Exception {
        return this.start(appId, name, globalVariable, "", isStandalone);
    }

    public Long start(String name, JSONObject globalVariable, boolean isStandalone) throws Exception {
        return this.start("tesla", name, globalVariable, isStandalone);
    }

    public Object getElementOut(Long dagInstNodeId, String elementKey) throws Exception {
        if (this.dagInstNodeRepository.findFirstById(dagInstNodeId) == null) {
            throw new Exception("dagInstNodeId: " + dagInstNodeId + " not exists");
        }
        TcDagInstNode dagInstNode = this.dagInstNodeRepository.findFirstById(dagInstNodeId);
        JSONObject outJson = dagInstNode.outJson();
        JSON json = AbstractActionNewService.getDataData(outJson, JSON.class);
        if (json instanceof JSONObject) {
            return ((JSONObject)json).get((Object)elementKey);
        }
        if (json instanceof JSONArray) {
            JSONArray dataArray = (JSONArray)json;
            List formatDetailJsonList = JSONArray.parseArray((String)dagInstNode.dagNode().getFormatDetail()).toJavaList(JSONObject.class);
            for (int index = 0; index < formatDetailJsonList.size(); ++index) {
                JSONObject dataJson;
                JSONObject formatDetailJson = (JSONObject)formatDetailJsonList.get(index);
                if (!formatDetailJson.getString("type").equals(DagNodeFormatType.CUSTOM.name()) || !(dataJson = dataArray.getJSONObject(index)).containsKey((Object)elementKey)) continue;
                return dataJson.get((Object)elementKey);
            }
            return null;
        }
        throw new Exception("dataData is not JSONObject or JSONArray; dataData: " + JSONObject.toJSONString((Object)json));
    }

    public Object getElementOut(Long dagInstNodeId, int elementIndex) throws Exception {
        if (this.dagInstNodeRepository.findFirstById(dagInstNodeId) == null) {
            throw new Exception("dagInstNodeId: " + dagInstNodeId + " not exists");
        }
        TcDagInstNode dagInstNode = this.dagInstNodeRepository.findFirstById(dagInstNodeId);
        JSONObject outJson = dagInstNode.outJson();
        return AbstractActionNewService.getDataData(outJson, JSONArray.class).get(elementIndex);
    }

    public TcDagInst get(long dagInstId) {
        return this.dagInstRepository.findFirstById(dagInstId);
    }

    public List<Long> listDagInstNodeId(long dagInstId) {
        return this.dagInstNodeRepository.findAllByDagInstId(dagInstId).stream().map(TcDagInstNode::getId).collect(Collectors.toList());
    }

    public void updateGlobalVariable(Long dagInstId, JSONObject globalVariable) {
        if (CollectionUtils.isEmpty((Map)globalVariable)) {
            return;
        }
        TcDagInst dagInst = this.dagInstRepository.findFirstById(dagInstId);
        if (dagInst == null) {
            return;
        }
        JSONObject globalVariableJson = dagInst.globalVariableJson();
        globalVariableJson.putAll((Map)globalVariable);
        this.dagInstRepository.updateGlobalVariable(dagInstId, JSONObject.toJSONString((Object)globalVariableJson, (boolean)true));
        List<TcDagInstNode> nodeList = this.dagInstNodeRepository.findAllByDagInstId(dagInstId);
        for (TcDagInstNode node : nodeList) {
            Long subDagInstId = node.getSubDagInstId();
            if (subDagInstId == null || subDagInstId <= 0L) continue;
            this.updateGlobalVariable(subDagInstId, globalVariable);
        }
    }

    public void rerunDagInstByStatus(Long dagInstId, List<DagInstNodeStatus> statusList) throws Exception {
        TcDagInst dagInst = this.dagInstRepository.findFirstById(dagInstId);
        if (!dagInst.status().isEnd()) {
            throw new Exception("can not rerun dagInst when it's status is " + dagInst.status().toString());
        }
        List<TcDagInstNode> dagInstNodeList = this.dagInstNodeRepository.findAllByDagInstIdAndStatusIn(dagInstId, statusList.stream().map(Enum::toString).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(dagInstNodeList)) {
            return;
        }
        for (TcDagInstNode node : dagInstNodeList) {
            Long subDagInstId = node.getSubDagInstId();
            if (subDagInstId == null || subDagInstId <= 0L) {
                this.dagInstNodeRepository.updateStatusById(DagInstNodeStatus.INIT.toString(), node.getId());
                continue;
            }
            this.rerunDagInstByStatus(subDagInstId, statusList);
        }
        this.dagInstRepository.setStatus(DagInstStatus.RUNNING.toString(), dagInstId);
    }

    public void stop(Long dagInstId) {
        this.dagInstRepository.updateStatus(dagInstId, DagInstStatus.WAIT_STOP.toString());
    }

    public void rerunStoppedExceptionDagInst(Long dagInstId) throws Exception {
        this.rerunDagInstByStatus(dagInstId, Arrays.asList(DagInstNodeStatus.STOPPED, DagInstNodeStatus.SKIP_CAUSE_BY_STOPPED, DagInstNodeStatus.STOPPED, DagInstNodeStatus.SKIP_CAUSE_BY_STOPPED));
    }

    public void rerunStoppedDagInst(Long dagInstId) throws Exception {
        this.rerunDagInstByStatus(dagInstId, Arrays.asList(DagInstNodeStatus.STOPPED, DagInstNodeStatus.SKIP_CAUSE_BY_STOPPED));
    }

    public void rerunExceptionDagInst(Long dagInstId) throws Exception {
        this.rerunDagInstByStatus(dagInstId, Arrays.asList(DagInstNodeStatus.EXCEPTION, DagInstNodeStatus.SKIP_CAUSE_BY_EXCEPTION));
    }

    public boolean isEnd(Long instanceId) {
        return this.dagInstRepository.findFirstById(instanceId).status().isEnd();
    }

    public JSONObject getNativeById(Long dagInstId, boolean withData) throws Exception {
        TcDagInst dagInst = this.dagInstRepository.findFirstById(dagInstId);
        JSONObject jsonObject = new JSONObject();
        JSONObject globalResultJson = dagInst.globalResultJson();
        if (withData) {
            globalResultJson = this.getTotalGlobalResult(dagInstId);
        }
        this.regularGlobalResult(globalResultJson);
        jsonObject.put("globalVariable", (Object)dagInst.globalVariableJson());
        jsonObject.put("globalResult", (Object)globalResultJson);
        jsonObject.put("globalParams", (Object)dagInst.globalParamsJson());
        jsonObject.put("status", (Object)dagInst.status());
        jsonObject.put("channel", (Object)dagInst.getChannel());
        jsonObject.put("env", (Object)dagInst.getEnv());
        return jsonObject;
    }

    private JSONObject getTotalGlobalResult(Long dagInstId) throws Exception {
        JSONObject jsonObject = new JSONObject();
        TcDagInst dagInst = this.dagInstRepository.findFirstById(dagInstId);
        List<TcDagInstNode> dagInstNodeList = dagInst.nodes();
        for (TcDagInstNode dagInstNode : dagInstNodeList) {
            if (dagInstNode.getSubDagInstId() == null) {
                JSONObject outJson = AbstractActionNewService.getData(dagInstNode.outJsonWithCache());
                jsonObject.put(dagInstNode.nodeId(), (Object)outJson);
                continue;
            }
            jsonObject.put(dagInstNode.nodeId(), (Object)this.getTotalGlobalResult(dagInstNode.getSubDagInstId()));
        }
        return jsonObject;
    }

    private void regularGlobalResult(JSONObject globalResult) {
        if (globalResult.containsKey((Object)"result") || globalResult.containsKey((Object)"data")) {
            globalResult.remove((Object)"output");
            globalResult.remove((Object)"chatops");
        }
        for (String key : globalResult.keySet()) {
            Object value = JSON.toJSON((Object)globalResult.get((Object)key));
            if (!(value instanceof JSONObject)) continue;
            this.regularGlobalResult((JSONObject)value);
        }
    }
}

