/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.services;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.model.domain.TcDag;
import com.alibaba.tesla.dag.model.domain.TcDagNode;
import com.alibaba.tesla.dag.model.repository.TcDagNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagRepository;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DagService {
    @Autowired
    TcDagRepository dagRepository;
    @Autowired
    TcDagNodeRepository dagNodeRepository;

    public Long copyDag(Long dagId, String dstAppId, String nameHeader) throws Exception {
        if (StringUtils.isEmpty((CharSequence)nameHeader)) {
            nameHeader = "__COPY" + System.currentTimeMillis() + "__";
        }
        TcDag dag = new TcDag();
        TcDag sourceDag = this.dagRepository.findFirstById(dagId);
        if (sourceDag == null) {
            throw new Exception("sourceDag can not be null");
        }
        BeanUtils.copyProperties((Object)sourceDag, (Object)dag);
        dag.setId(null);
        dag.setAppId(dstAppId);
        dag.setName(nameHeader + sourceDag.getName());
        dag.setLastUpdateBy("");
        List<JSONObject> nodeList = dag.nodes();
        for (JSONObject node : nodeList) {
            Long nodeDefId;
            String nodeType = node.getJSONObject("data").getString("type");
            Long dagNodeId = node.getJSONObject("data").getLongValue("defId");
            if ("DAG".equals(nodeType)) {
                nodeDefId = this.copyDag(dagNodeId, dstAppId, nameHeader);
            } else {
                TcDagNode dagNode = new TcDagNode();
                TcDagNode sourceDagNode = this.dagNodeRepository.findFirstById(dagNodeId);
                if (sourceDagNode == null) {
                    throw new Exception("sourceDagNode is null: " + JSONObject.toJSONString((Object)node));
                }
                String dagNodeName = nameHeader + sourceDagNode.getName();
                TcDagNode dstDagNode = this.dagNodeRepository.findFirstByAppIdAndName(dstAppId, dagNodeName);
                if (dstDagNode != null) {
                    nodeDefId = dstDagNode.getId();
                } else {
                    BeanUtils.copyProperties((Object)sourceDagNode, (Object)dagNode);
                    dagNode.setId(null);
                    dagNode.setAppId(dstAppId);
                    dagNode.setName(dagNodeName);
                    dagNode.setGmtCreate(System.currentTimeMillis() / 1000L);
                    dagNode.setLastUpdateBy("");
                    dagNode.saveWithTime();
                    dagNode.flush();
                    nodeDefId = dagNode.getId();
                }
            }
            node.getJSONObject("data").put("defId", (Object)nodeDefId);
        }
        JSONObject contentJson = dag.contentJson();
        contentJson.put("nodes", nodeList);
        dag.setContent(JSONObject.toJSONString((Object)contentJson));
        dag.setGmtCreate(System.currentTimeMillis() / 1000L);
        TcDag dstDag = this.dagRepository.findFirstByAppIdAndName(dstAppId, dag.getName());
        if (dstDag != null) {
            return dstDag.getId();
        }
        dag.saveWithTime();
        dag.flush();
        return dag.getId();
    }

    public void deleteDagById(Long id) {
        this.dagRepository.deleteById(id);
    }
}

