/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.services;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.local.LocalTaskDO;
import com.alibaba.tesla.dag.local.LocalTaskProducer;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeType;
import com.alibaba.tesla.dag.repository.dao.DagInstNodeStdDAO;
import com.alibaba.tesla.dag.repository.domain.DagInstDO;
import com.alibaba.tesla.dag.repository.domain.DagInstNodeDO;
import com.alibaba.tesla.dag.repository.domain.DagInstNodeStdDO;
import com.alibaba.tesla.dag.schedule.task.TaskStatus;
import com.alibaba.tesla.dag.services.AbstractActionNewService;
import com.alibaba.tesla.dag.util.IPUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocalActionNewService
extends AbstractActionNewService {
    private static final Logger log = LoggerFactory.getLogger(LocalActionNewService.class);
    @Autowired
    private DagInstNodeStdDAO dagInstNodeStdDAO;
    @Autowired
    private LocalTaskProducer localTaskProducer;

    @Override
    public Long start(DagInstDO dagInst, DagInstNodeDO dagInstNode) throws Exception {
        DagInstNodeStdDO dagInstNodeStd = DagInstNodeStdDO.builder().status(TaskStatus.INIT.name()).ip(dagInst.getStandaloneIp()).standaloneIp(dagInst.getStandaloneIp()).lockId(IPUtil.getLockId()).dagInstId(dagInst.getId()).dagInstNodeId(dagInstNode.getId()).build();
        this.dagInstNodeStdDAO.insert(dagInstNodeStd);
        LocalTaskDO localTaskDO = LocalTaskDO.builder().dagInstId(dagInst.getId()).nodeId(dagInstNode.getNodeId()).taskId(dagInstNodeStd.getId()).build();
        this.localTaskProducer.sendLocalTask(localTaskDO);
        return dagInstNodeStd.getId();
    }

    @Override
    public DagNodeType registerNodeType() {
        return DagNodeType.LOCAL;
    }

    @Override
    public TaskStatus status(Long taskId) throws Exception {
        return this.dagInstNodeStdDAO.getDagInstNodeStdById(taskId).fetchStatus();
    }

    @Override
    public JSONObject stdout(Long taskId) throws Exception {
        DagInstNodeStdDO dagInstNodeStd = this.dagInstNodeStdDAO.getDagInstNodeStdById(taskId);
        JSONObject retJson = new JSONObject();
        retJson.put("_global_params", dagInstNodeStd.fetchGlobalParams());
        retJson.put("_data", (Object)dagInstNodeStd.fetchStdout());
        return retJson;
    }

    @Override
    public String stderr(Long taskId) throws Exception {
        return this.dagInstNodeStdDAO.getDagInstNodeStdById(taskId).getStderr();
    }

    @Override
    public Long stop(Long taskId) throws Exception {
        DagInstNodeStdDO updateInstNodeStd = DagInstNodeStdDO.builder().id(taskId).isStop(Boolean.TRUE).stopId(taskId).build();
        this.dagInstNodeStdDAO.update(updateInstNodeStd);
        return updateInstNodeStd.getId();
    }
}

