/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.services;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.ApplicationProperties;
import com.alibaba.tesla.dag.common.Tools;
import com.alibaba.tesla.dag.model.domain.TcDag;
import com.alibaba.tesla.dag.model.domain.TcDagNode;
import com.alibaba.tesla.dag.model.domain.dag.DagInputParam;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeDetailApi;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeDetailFaas;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeDetailTask;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeType;
import com.alibaba.tesla.dag.model.repository.TcDagNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagRepository;
import com.google.common.base.Throwables;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RegisterService {
    private static final Logger log = LoggerFactory.getLogger(RegisterService.class);
    @Autowired
    TcDagNodeRepository dagNodeRepository;
    @Autowired
    TcDagRepository dagRepository;
    @Autowired
    ApplicationProperties applicationProperties;

    public JSONObject dags(JSONArray dagJsonArray) {
        JSONObject metaJson = this.dags(dagJsonArray, 1, new JSONObject());
        this.dagRepository.deleteByNameNotInAndLastUpdateBy(metaJson.getJSONArray("name").toJavaList(String.class), metaJson.getString("updateBy"));
        return metaJson;
    }

    private JSONObject dags(JSONArray dagJsonArray, int index, JSONObject metaJson) {
        if (CollectionUtils.isEmpty((Map)metaJson)) {
            metaJson = new JSONObject();
            metaJson.put("failed", (Object)new JSONArray());
            metaJson.put("name", (Object)new JSONArray());
            metaJson.put("detail", (Object)new StringBuilder());
        }
        StringBuilder sb = (StringBuilder)metaJson.getObject("detail", StringBuilder.class);
        JSONArray failed = metaJson.getJSONArray("failed");
        sb.append("\n##### NO.").append(index).append("#####");
        for (JSONObject dagJson : dagJsonArray.toJavaList(JSONObject.class)) {
            sb.append("\n").append(dagJson.getString("name")).append(": ");
            try {
                this.updateDag(dagJson, metaJson);
            }
            catch (Exception e) {
                sb.append(Throwables.getRootCause((Throwable)e));
                log.error("updateDag: " + JSONObject.toJSONString((Object)dagJson), (Throwable)e);
                failed.add((Object)dagJson);
            }
        }
        if (failed.size() > 0 && failed.size() < dagJsonArray.size()) {
            this.dags(failed, index + 1, metaJson);
        }
        return metaJson;
    }

    public JSONObject nodes(List<JSONObject> nodeJsonList) throws Exception {
        JSONObject metaJson = new JSONObject();
        StringBuilder sb = new StringBuilder();
        JSONArray failed = new JSONArray();
        metaJson.put("failed", (Object)failed);
        metaJson.put("name", (Object)new JSONArray());
        metaJson.put("detail", (Object)sb);
        for (JSONObject nodeJson : nodeJsonList) {
            sb.append("\n").append(nodeJson.getString("name")).append(": ");
            this.updateNode(nodeJson, metaJson);
        }
        this.dagNodeRepository.deleteByNameNotInAndLastUpdateBy(metaJson.getJSONArray("name").toJavaList(String.class), metaJson.getString("updateBy"));
        return metaJson;
    }

    private void updateNode(JSONObject nodeJson, JSONObject metaJson) throws Exception {
        String appId = nodeJson.getString("app_id");
        String faasName = nodeJson.getString("faas_name");
        String moduleFile = nodeJson.getString("module_file");
        String updateBy = String.format("FAAS:%s:%s", appId, faasName);
        if (StringUtils.isNotEmpty((CharSequence)moduleFile)) {
            updateBy = updateBy + ":" + moduleFile;
        }
        String name = nodeJson.getString("name");
        String alias = nodeJson.getString("alias");
        StringBuilder sb = (StringBuilder)metaJson.getObject("detail", StringBuilder.class);
        metaJson.put("updateBy", (Object)updateBy);
        metaJson.getJSONArray("name").add((Object)name);
        TcDagNode dagNode = this.dagNodeRepository.findFirstByAppIdAndName(appId, name);
        if (dagNode == null) {
            dagNode = TcDagNode.builder().gmtCreate(System.currentTimeMillis() / 1000L).build();
        } else if (StringUtils.isNotEmpty((CharSequence)dagNode.getLastUpdateBy()) && !dagNode.getLastUpdateBy().equals(updateBy)) {
            sb.append("conflict update by [").append(dagNode.getLastUpdateBy()).append("]");
            return;
        }
        dagNode.setGmtModified(System.currentTimeMillis() / 1000L);
        dagNode.setAppId(appId);
        dagNode.setName(name);
        dagNode.setAlias(StringUtils.isEmpty((CharSequence)alias) ? name : alias);
        dagNode.setDescription(nodeJson.getString("description"));
        dagNode.setIsShare(nodeJson.getInteger("is_share"));
        dagNode.setIsShow(nodeJson.getInteger("is_show"));
        dagNode.setInputParams(Tools.jsonObjectGetString(nodeJson, "input_params"));
        dagNode.setOutputParams(Tools.jsonObjectGetString(nodeJson, "output_params"));
        DagNodeType nodeType = (DagNodeType)((Object)nodeJson.getObject("type", DagNodeType.class));
        dagNode.setType(nodeType.name());
        switch (nodeType) {
            case API: {
                dagNode.setDetail(DagNodeDetailApi.builder().timeout(nodeJson.getInteger("api_time_out")).urlPath(nodeJson.getString("api_url_path")).build().toJson());
                break;
            }
            case FAAS: {
                dagNode.setDetail(DagNodeDetailFaas.builder().appId(appId).faasName(faasName).name(nodeJson.getString("name")).callUrl(nodeJson.getString("call_url")).build().toJson());
                break;
            }
            case TASK: {
                dagNode.setDetail(DagNodeDetailTask.builder().appId(nodeJson.getString("task_app_id")).bizKey(nodeJson.getString("task_biz_key")).build().toJson());
                break;
            }
        }
        dagNode.setFormatType(nodeJson.getString("format_type"));
        dagNode.setFormatDetail(Tools.jsonObjectGetString(nodeJson, "format_detail"));
        dagNode.setLastUpdateBy(updateBy);
        dagNode.upsertByAppIdAndName();
        dagNode.updateOptions();
        sb.append("OK");
    }

    private void updateDag(JSONObject dagJson, JSONObject metaJson) throws Exception {
        String appId = dagJson.getString("app_id");
        String faasName = dagJson.getString("faas_name");
        String moduleFile = dagJson.getString("module_file");
        String updateBy = String.format("FAAS:%s:%s", appId, faasName);
        if (StringUtils.isNotEmpty((CharSequence)moduleFile)) {
            updateBy = updateBy + ":" + moduleFile;
        }
        String name = dagJson.getString("name");
        String alias = dagJson.getString("alias");
        String exScheduleTaskId = dagJson.getString("ex_schedule_task_id");
        StringBuilder sb = (StringBuilder)metaJson.getObject("detail", StringBuilder.class);
        metaJson.put("updateBy", (Object)updateBy);
        metaJson.getJSONArray("name").add((Object)name);
        TcDag dag = this.dagRepository.findFirstByAppIdAndName(appId, name);
        if (dag == null) {
            dag = TcDag.builder().gmtCreate(System.currentTimeMillis() / 1000L).build();
        } else if (StringUtils.isNotEmpty((CharSequence)dag.getLastUpdateBy()) && !dag.getLastUpdateBy().equals(updateBy)) {
            sb.append("conflict update by [").append(dag.getLastUpdateBy()).append("]");
            return;
        }
        dag.setGmtModified(System.currentTimeMillis() / 1000L);
        dag.setAppId(appId);
        dag.setName(name);
        dag.setAlias(StringUtils.isEmpty((CharSequence)alias) ? name : alias);
        dag.setExScheduleTaskId(exScheduleTaskId);
        dag.setContent(JSONObject.toJSONString((Object)dagJson.getJSONObject("content")));
        dag.setLastUpdateBy(updateBy);
        dag.setHasFeedback(0);
        dag.setHasHistory(1);
        dag.setInputParams(dagJson.getJSONArray("input_params").toJavaList(DagInputParam.class));
        this.fillNodeInDag(dag);
        dag.upsertByAppIdAndName();
        dag.updateOptions();
        sb.append("OK");
    }

    private void fillNode(JSONObject nodeJson) throws Exception {
        JSONObject dataJson = nodeJson.getJSONObject("data");
        dataJson.put("tooltip", (Object)new JSONObject());
        if (dataJson.containsKey((Object)"defIdDetail")) {
            JSONObject defIdDetailJson = dataJson.getJSONObject("defIdDetail");
            String appId = defIdDetailJson.getString("app_id");
            String name = defIdDetailJson.getString("name");
            switch (dataJson.getString("type")) {
                case "NODE": {
                    TcDagNode dagNode = this.dagNodeRepository.findFirstByAppIdAndName(appId, name);
                    if (dagNode == null) {
                        throw new Exception(String.format("can not find node by appId: %s and name: %s", appId, name));
                    }
                    dataJson.put("defId", (Object)dagNode.getId());
                    dataJson.put("label", (Object)dagNode.getAlias());
                    nodeJson.put("label", (Object)dagNode.getAlias());
                    dataJson.put("inputParams", dagNode.inputParamList());
                    dataJson.put("outputParams", dagNode.outputParamList());
                    break;
                }
                case "DAG": {
                    TcDag subDag = this.dagRepository.findFirstByAppIdAndName(appId, name);
                    if (subDag == null) {
                        throw new Exception(String.format("can not find subDag with appId: %s and name: %s", appId, name));
                    }
                    dataJson.put("defId", (Object)subDag.getId());
                    dataJson.put("label", (Object)subDag.getAlias());
                    nodeJson.put("label", (Object)subDag.getAlias());
                    dataJson.put("inputParams", subDag.inputParams());
                    break;
                }
            }
            dataJson.remove((Object)"defIdDetail");
        }
    }

    private void fillNodeInDag(TcDag dag) throws Exception {
        JSONObject postNodeJson;
        JSONObject contentJson = dag.contentJson();
        JSONArray nodeJsonArray = contentJson.getJSONArray("nodes");
        for (JSONObject nodeJson : nodeJsonArray.toJavaList(JSONObject.class)) {
            this.fillNode(nodeJson);
        }
        JSONObject preNodeJson = contentJson.getJSONObject("__pre_node__");
        if (!CollectionUtils.isEmpty((Map)preNodeJson)) {
            this.fillNode(preNodeJson);
        }
        if (!CollectionUtils.isEmpty((Map)(postNodeJson = contentJson.getJSONObject("__post_node__")))) {
            this.fillNode(postNodeJson);
        }
        dag.setContent(JSONObject.toJSONString((Object)contentJson));
    }

    public int deleteNode(String appId, String name) {
        return this.dagNodeRepository.deleteByAppIdAndName(appId, name);
    }

    public int deleteDag(String appId, String name) {
        return this.dagRepository.deleteByAppIdAndName(appId, name);
    }
}

