/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.services;

import com.alibaba.tesla.dag.repository.dao.DagInstDAO;
import com.alibaba.tesla.dag.repository.domain.DagInstDO;
import com.alibaba.tesla.dag.services.DagInstNewService;
import com.alibaba.tesla.dag.util.DateUtil;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskFlowDispatchService {
    private static final Logger log = LoggerFactory.getLogger(TaskFlowDispatchService.class);
    @Autowired
    private DagInstDAO dagInstDAO;
    @Autowired
    private DagInstNewService dagInstNewService;

    public int dispatch(int minutesAgo, int secondsAgo) {
        Long end = DateUtil.currentSeconds() - (long)secondsAgo;
        Long begin = end - (long)(minutesAgo * DateUtil.MINUTE);
        List<DagInstDO> timeOutList = this.dagInstDAO.listTimeOut(begin, end);
        if (CollectionUtils.isNotEmpty(timeOutList)) {
            for (DagInstDO dagInstDO : timeOutList) {
                try {
                    this.dagInstNewService.doDagInstDispatch(dagInstDO);
                    this.dagInstNewService.inspectDagInstNode(dagInstDO);
                }
                catch (Exception e) {
                    log.error(">>>taskFlowDispatchService|dispatch|ERROR|dagInstDO={}, err={}", new Object[]{dagInstDO, e.getMessage(), e});
                }
            }
        }
        return CollectionUtils.size(timeOutList);
    }
}

