/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.algorithm.DAG;
import com.alibaba.tesla.dag.repository.domain.DagInstEdgeDO;
import com.alibaba.tesla.dag.repository.domain.DagInstNodeDO;
import java.util.List;

public class DagUtil {
    public static DAG calcDAG(List<DagInstNodeDO> nodeList, List<DagInstEdgeDO> edgeList) {
        DAG dag = DAG.create();
        for (DagInstNodeDO node : nodeList) {
            dag.addVertex(node.getNodeId());
        }
        for (DagInstEdgeDO edge : edgeList) {
            dag.addEdge(edge.getSource(), edge.getTarget());
        }
        return dag;
    }

    public static DAG calcDAG(String content) {
        JSONObject contentJson = JSONObject.parseObject((String)content);
        DAG dag = DAG.create();
        JSONArray nodeArray = contentJson.getJSONArray("nodes");
        for (int i = 0; i < nodeArray.size(); ++i) {
            JSONObject node = nodeArray.getJSONObject(i);
            dag.addVertex(node.getString("id"));
        }
        JSONArray edgeArray = contentJson.getJSONArray("edges");
        for (int i = 0; i < edgeArray.size(); ++i) {
            JSONObject edge = edgeArray.getJSONObject(i);
            dag.addEdge(edge.getString("source"), edge.getString("target"));
        }
        return dag;
    }
}

