/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.util;

import com.alibaba.tesla.dag.common.Tools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class IPUtil {
    public static boolean isIp(String addr) {
        if (StringUtils.isEmpty((CharSequence)addr) || addr.length() < 7 || addr.length() > 15) {
            return false;
        }
        String regex = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        Pattern pat = Pattern.compile(regex);
        Matcher mat = pat.matcher(addr);
        boolean ipAddress = mat.find();
        return ipAddress;
    }

    public static List<String> toIpList(String addrsString) {
        if (StringUtils.isEmpty((CharSequence)addrsString)) {
            return Collections.emptyList();
        }
        String[] addrs = StringUtils.split((String)addrsString, (String)",");
        ArrayList<String> addrList = new ArrayList<String>(addrs.length);
        for (String addr : addrs) {
            if (!IPUtil.isIp(addr)) {
                return Collections.emptyList();
            }
            addrList.add(addr);
        }
        return addrList;
    }

    public static String getLockId() {
        return "V2_" + Tools.localIp + "_" + UUID.randomUUID().toString().replace("-", "");
    }
}

