package com.alibaba.tesla.common.base;

import com.alibaba.tesla.common.base.constant.TeslaStatusCode;
import lombok.Data;

import java.io.Serializable;

/**
 * Tesla API后台统一的HTTP body JSON结构
 *
 * @author Adonis
 */
@Data
public class TeslaBaseResult implements Serializable {

    public static final long serialVersionUID = 1L;

    public static String SUCCEED_MESG = "SUCCESS";

    /**
     * 返回码
     */
    private int code;

    /**
     * 文本消息描述
     */
    private String message;

    /**
     * request id
     */
    private String requestId;

    /**
     * 时间戳
     */
    private Long timestamp;

    /**
     * 返回的详细数据
     */
    private Object data;

    public TeslaBaseResult() {
        this.code = TeslaStatusCode.SUCCESS;
        this.message = SUCCEED_MESG;
        this.data = null;
    }

    /**
     * 成功返回
     */
    public TeslaBaseResult(Object data) {
        this.code = TeslaStatusCode.SUCCESS;
        this.message = SUCCEED_MESG;
        this.data = data;
    }

    /**
     * 自定义失败返回数据
     */
    public TeslaBaseResult(int code, String message, Object data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public TeslaBaseResult(String message, Object data) {
        this.message = message;
        this.data = data;
    }

}
