package com.alibaba.tesla.common.base;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author qiuqiang.qq@alibaba-inc.com
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TeslaPageInfo<T> implements Serializable {

    /**
     * page number
     */
    private int pageNum;

    /**
     * page size
     */
    private int pageSize;

    /**
     * current page size
     */
    private int size;

    /**
     * total pages
     */
    private int pages;

    /**
     * total record
     */
    private long total;

    /**
     * list
     */
    protected List<T> list;
}
