package com.alibaba.tesla.common.base.exception;

import com.alibaba.tesla.common.base.constant.TeslaStatusCode;

/**
 * 客户端异常基类，包括前端参数非法，用户无权限等, 默认使用400错误码
 *
 * Client端异常一般情况下不需要cause信息和data信息
 */
public class ClientException extends TeslaBaseException {

    /**
     * 无具体出错分类的客户端错误
     */
    public ClientException(String message) {
        super(TeslaStatusCode.CLIENT_ERROR, message);
    }

    public ClientException(int code, String message) {
        super(code, message);
    }

    /**
     * Slot for further extension with data info
     */
    public ClientException(int code, String message, Object data) {
        super(code, message, data);
    }
}
