package com.alibaba.tesla.web.controller;

import com.alibaba.tesla.web.properties.TeslaEnvProperties;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.PostConstruct;
import java.util.Objects;

/**
 * @author qiuqiang.qq@alibaba-inc.com
 */
@Slf4j
@RestController
public class TeslaCommonController {

    @Autowired
    private TeslaEnvProperties envProperties;

    /**
     * TRUE --> online
     * FALSE --> offline
     * default on line
     */
    private volatile Boolean appStatus = Boolean.TRUE;

    @PostConstruct
    public void init(){
        this.appStatus = BooleanUtils.toBooleanDefaultIfNull(envProperties.getAutoOnline(), Boolean.TRUE);
    }



    @GetMapping({"/status.taobao", "/checkpreload.htm"})
    public String status(){
        if(appStatus){
            return "success";
        }
        throw new RuntimeException("app offline");
    }

    @GetMapping("/offline")
    public String offline(@RequestParam String token){
        this.checkToken(token);
        appStatus = Boolean.FALSE;
        return "success";
    }

    @GetMapping("/online")
    public String online(@RequestParam String token){
        this.checkToken(token);
        appStatus = Boolean.TRUE;
        return "success";
    }

    private void checkToken(String token){
        if(!Objects.equals(token, envProperties.getToken())){
            throw new IllegalArgumentException("token is invalid, token=" + token);
        }
    }
}
