package com.alibaba.tesla.web.handler;

import com.alibaba.tesla.common.base.TeslaBaseResult;
import com.alibaba.tesla.common.base.TeslaResultFactory;
import com.alibaba.tesla.web.exception.AppOfflineException;

import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/**
 * @author qiuqiang.qq@alibaba-inc.com
 */
@Slf4j
@ControllerAdvice
public class TeslaWebGlobalExceptionHandler {

    @ExceptionHandler(AppOfflineException.class)
    @ResponseStatus(HttpStatus.BAD_REQUEST)
    @ResponseBody
    public TeslaBaseResult appOfflineException() {
        return TeslaResultFactory.buildResult(
            HttpStatus.BAD_REQUEST.value(), "tesla app will offline, please use other instance");
    }

    @ExceptionHandler({Exception.class})
    @ResponseStatus(HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public TeslaBaseResult handOtherException(Exception e) {
        log.error("Exception", e);
        return TeslaResultFactory.buildResult(
            HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getLocalizedMessage(), null);
    }
}
