package com.alibaba.tesla.web.properties;

import com.alibaba.tesla.common.base.enums.TeslaEnv;
import com.alibaba.tesla.common.base.enums.TeslaRegion;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author qiuqiang.qq@alibaba-inc.com
 */
@Data
@ConfigurationProperties(prefix = "tesla")
public class TeslaEnvProperties {

    /**
     * 默认是日常
     */
    private TeslaEnv env = TeslaEnv.DAILY;

    /**
     * 默认是弹内
     */
    private TeslaRegion region = TeslaRegion.INTERNAL;

    /**
     * 默认token
     */
    private String token = "teslaAdmin";

    /**
     * 自动在线
     */
    private Boolean autoOnline = true;

}
