/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.web.controller;

import com.alibaba.tesla.web.properties.TeslaEnvProperties;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TeslaCommonController {
    private static final Logger log = LoggerFactory.getLogger(TeslaCommonController.class);
    @Autowired
    private TeslaEnvProperties envProperties;
    private volatile Boolean appStatus = Boolean.TRUE;

    @PostConstruct
    public void init() {
        this.appStatus = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.envProperties.getAutoOnline(), (boolean)Boolean.TRUE);
    }

    @GetMapping(value={"/status.taobao", "/checkpreload.htm"})
    public String status() {
        if (this.appStatus.booleanValue()) {
            return "success";
        }
        throw new RuntimeException("app offline");
    }

    @GetMapping(value={"/offline"})
    public String offline(@RequestParam String token) {
        this.checkToken(token);
        this.appStatus = Boolean.FALSE;
        return "success";
    }

    @GetMapping(value={"/online"})
    public String online(@RequestParam String token) {
        this.checkToken(token);
        this.appStatus = Boolean.TRUE;
        return "success";
    }

    private void checkToken(String token) {
        if (!Objects.equals(token, this.envProperties.getToken())) {
            throw new IllegalArgumentException("token is invalid, token=" + token);
        }
    }
}

