/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.web.handler;

import com.alibaba.tesla.common.base.TeslaBaseResult;
import com.alibaba.tesla.common.base.TeslaResultFactory;
import com.alibaba.tesla.web.exception.AppOfflineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class TeslaWebGlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(TeslaWebGlobalExceptionHandler.class);

    @ExceptionHandler(value={AppOfflineException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public TeslaBaseResult appOfflineException() {
        return TeslaResultFactory.buildResult((int)HttpStatus.BAD_REQUEST.value(), (String)"tesla app will offline, please use other instance");
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public TeslaBaseResult handOtherException(Exception e) {
        log.error("Exception", (Throwable)e);
        return TeslaResultFactory.buildResult((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)e.getLocalizedMessage(), null);
    }
}

