package com.alibaba.tesla.web.util;

import com.alibaba.tesla.web.constant.HttpHeaderNames;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;

import java.util.Optional;

/**
 * @author qiuqiang.qq@alibaba-inc.com
 */
public class HttpHeaderResolveUtil {

    private HttpHeaderResolveUtil() {
    }

    /**
     * 根据 Http header 中特定的用户名称头获取用户名
     *
     * @return "" if empty
     */
    public static String getUserName(ServerHttpRequest request) {
        return Optional.ofNullable(request.getHeaders().getFirst(HttpHeaderNames.X_AUTH_USER)).orElse(StringUtils.EMPTY);
    }

    /**
     * 根据 Http header 中特定的用户名称头获取 USER ID
     *
     * @return "" if empty
     */
    public static String getUserId(ServerHttpRequest request) {
        return Optional.ofNullable(request.getHeaders().getFirst(HttpHeaderNames.X_AUTH_USERID)).orElse(StringUtils.EMPTY);
    }

    /**
     * 根据 Http header 中特定的用户名称头获取 APP ID
     *
     * @return "" if empty
     */
    public static String getAppId(ServerHttpRequest request) {
        return Optional.ofNullable(request.getHeaders().getFirst(HttpHeaderNames.X_AUTH_APP)).orElse(StringUtils.EMPTY);
    }

    /**
     * 获取应用唯一标识
     * @return app id
     */
    public static String getBizAppId(ServerHttpRequest request){
        return Optional.ofNullable(request.getHeaders().getFirst(HttpHeaderNames.X_BIZ_APP)).orElse(StringUtils.EMPTY);
    }

    /**
     * 根据 Http header 中特定的头获取用户工号
     *
     * @return "" if empty
     */
    public static String getUserEmployeeId(ServerHttpRequest request) {
        return Optional.ofNullable(request.getHeaders().getFirst(HttpHeaderNames.X_EMPL_ID)).orElse(StringUtils.EMPTY);
    }

    /**
     * 根据 Http header 中特定的头获取用户邮箱
     *
     * @return "" if empty
     */
    public static String getUserEmailAddress(ServerHttpRequest request) {
        return Optional.ofNullable(request.getHeaders().getFirst(HttpHeaderNames.X_EMAIL_ADDR)).orElse(StringUtils.EMPTY);
    }

    /**
     * 根据 Http header 获取唯一标识请求的 trace id
     *
     * @return "" if empty
     */
    public static String getTraceId(ServerHttpRequest request) {
        return Optional.ofNullable(request.getHeaders().getFirst(HttpHeaderNames.X_TRACE_ID)).orElse(StringUtils.EMPTY);
    }
}
