/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.dse;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.stargate.auth.AuthorizationProcessor;
import io.stargate.auth.AuthorizationService;
import io.stargate.core.activator.BaseActivator;
import io.stargate.core.metrics.api.Metrics;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.common.StargateConfigSnitch;
import io.stargate.db.datastore.common.StargateSeedProvider;
import io.stargate.db.dse.impl.DelegatingAuthorizer;
import io.stargate.db.dse.impl.DsePersistence;
import java.io.Closeable;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.PasswordAuthenticator;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.GuardrailsConfig;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.config.YamlConfigurationLoader;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.locator.SimpleSnitch;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.io.FileUtils;

public class DsePersistenceActivator
extends BaseActivator {
    private static final String AUTHZ_PROCESSOR_ID = System.getProperty("stargate.authorization.processor.id");
    private final BaseActivator.ServicePointer<Metrics> metrics = BaseActivator.ServicePointer.create(Metrics.class);
    private final BaseActivator.LazyServicePointer<AuthorizationService> authorizationService = BaseActivator.LazyServicePointer.create(AuthorizationService.class, (String)"AuthIdentifier", (String)System.getProperty("stargate.auth_id", "AuthTableBasedService"));
    private final BaseActivator.ServicePointer<AuthorizationProcessor> authorizationProcessor = BaseActivator.ServicePointer.create(AuthorizationProcessor.class, (String)"AuthProcessorId", (String)AUTHZ_PROCESSOR_ID);
    private DsePersistence dseDB;
    private File baseDir;

    public DsePersistenceActivator() {
        super("DSE Stargate Backend");
    }

    @VisibleForTesting
    public static Config makeConfig(File baseDir) throws IOException {
        long timeout;
        String enableAuth;
        Config c;
        String cassandraConfigPath = System.getProperty("stargate.unsafe.cassandra_config_path", "");
        if (cassandraConfigPath.isEmpty()) {
            c = new Config();
        } else {
            File configFile = new File(cassandraConfigPath);
            c = new YamlConfigurationLoader().loadConfig(configFile.toURI().toURL());
        }
        File commitLogDir = Paths.get(baseDir.getPath(), "commitlog").toFile();
        commitLogDir.mkdirs();
        File dataDir = Paths.get(baseDir.getPath(), "data").toFile();
        dataDir.mkdirs();
        File hintDir = Paths.get(baseDir.getPath(), "hints").toFile();
        hintDir.mkdirs();
        File cdcDir = Paths.get(baseDir.getPath(), "cdc").toFile();
        cdcDir.mkdirs();
        File cacheDir = Paths.get(baseDir.getPath(), "caches").toFile();
        cacheDir.mkdirs();
        File metadataDir = Paths.get(baseDir.getPath(), "metadata").toFile();
        metadataDir.mkdirs();
        String clusterName = System.getProperty("stargate.cluster_name", "stargate-dse");
        String listenAddress = System.getProperty("stargate.listen_address", InetAddress.getLocalHost().getHostAddress());
        String broadcastAddress = System.getProperty("stargate.broadcast_address", listenAddress);
        Integer cqlPort = Integer.getInteger("stargate.cql_port", 9042);
        Integer listenPort = Integer.getInteger("stargate.seed_port", 7000);
        String seedList = System.getProperty("stargate.seed_list", "");
        String snitchClass = System.getProperty("stargate.snitch_classname", StargateConfigSnitch.class.getCanonicalName());
        if (snitchClass.equalsIgnoreCase("SimpleSnitch")) {
            snitchClass = SimpleSnitch.class.getCanonicalName();
        }
        if (snitchClass.equalsIgnoreCase("StargateConfigSnitch")) {
            snitchClass = StargateConfigSnitch.class.getCanonicalName();
        }
        if ((enableAuth = System.getProperty("stargate.enable_auth", "false")).equalsIgnoreCase("true")) {
            c.authenticator = System.getProperty("stargate.authenticator_class_name", PasswordAuthenticator.class.getCanonicalName());
            c.authorizer = DelegatingAuthorizer.class.getName();
        }
        c.cluster_name = clusterName;
        c.num_tokens = Integer.getInteger("stargate.num_tokens", 256);
        c.commitlog_sync = Config.CommitLogSync.periodic;
        c.commitlog_sync_period_in_ms = 10000;
        c.internode_compression = Config.InternodeCompression.none;
        c.commitlog_directory = commitLogDir.getAbsolutePath();
        c.hints_directory = hintDir.getAbsolutePath();
        c.cdc_raw_directory = cdcDir.getAbsolutePath();
        c.saved_caches_directory = cacheDir.getAbsolutePath();
        c.metadata_directory = metadataDir.getAbsolutePath();
        c.data_file_directories = new String[]{dataDir.getAbsolutePath()};
        c.partitioner = Murmur3Partitioner.class.getCanonicalName();
        c.disk_failure_policy = Config.DiskFailurePolicy.best_effort;
        c.start_native_transport = false;
        c.native_transport_port = cqlPort;
        c.rpc_address = "0.0.0.0";
        c.broadcast_rpc_address = listenAddress;
        c.endpoint_snitch = snitchClass;
        c.storage_port = listenPort;
        c.listen_address = listenAddress;
        c.broadcast_address = broadcastAddress;
        c.tpc_cores = FBUtilities.getAvailableProcessors();
        c.seed_provider = new ParameterizedClass(StargateSeedProvider.class.getName(), Collections.singletonMap("seeds", seedList));
        if (Boolean.parseBoolean(System.getProperty("stargate.emulate_dbaas_defaults", "false"))) {
            c.emulate_dbaas_defaults = true;
            GuardrailsConfig guardrailsConfig = new GuardrailsConfig();
            guardrailsConfig.secondary_index_per_table_failure_threshold = 6;
            c.guardrails = guardrailsConfig;
        }
        if (Boolean.getBoolean("stargate.system_keyspaces_filtering")) {
            c.system_keyspaces_filtering = true;
        }
        if ((timeout = Long.getLong("stargate.request_timeout_in_ms", -1L).longValue()) > 0L) {
            c.request_timeout_in_ms = timeout;
        }
        if ((timeout = Long.getLong("stargate.write_request_timeout_in_ms", -1L).longValue()) > 0L) {
            c.write_request_timeout_in_ms = timeout;
        }
        if ((timeout = Long.getLong("stargate.read_request_timeout_in_ms", -1L).longValue()) > 0L) {
            c.read_request_timeout_in_ms = timeout;
        }
        return c;
    }

    protected BaseActivator.ServiceAndProperties createService() {
        this.dseDB = new DsePersistence();
        CassandraMetricsRegistry.actualRegistry = ((Metrics)this.metrics.get()).getRegistry("persistence-dse-68");
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("Identifier", "DsePersistence");
        try {
            this.baseDir = Files.createTempDirectory("stargate-dse", new FileAttribute[0]).toFile();
            this.dseDB.setAuthorizationService(this.authorizationService.get());
            this.dseDB.initialize(DsePersistenceActivator.makeConfig(this.baseDir));
            IAuthorizer authorizer = DatabaseDescriptor.getAuthorizer().implementation();
            if (authorizer instanceof DelegatingAuthorizer) {
                ((DelegatingAuthorizer)authorizer).setProcessor((AuthorizationProcessor)this.authorizationProcessor.get());
            }
            return new BaseActivator.ServiceAndProperties((Object)this.dseDB, Persistence.class, props);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    protected void stopService() {
        try (Closeable ignored = () -> FileUtils.deleteDirectory((File)this.baseDir);){
            if (this.dseDB != null) {
                this.dseDB.destroy();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected List<BaseActivator.ServicePointer<?>> dependencies() {
        ImmutableList.Builder dependencies = ImmutableList.builder();
        dependencies.add(this.metrics);
        if (AUTHZ_PROCESSOR_ID != null) {
            dependencies.add(this.authorizationProcessor);
        }
        return dependencies.build();
    }

    protected List<BaseActivator.LazyServicePointer<?>> lazyDependencies() {
        return Collections.singletonList(this.authorizationService);
    }
}

