/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.dse.impl;

import io.stargate.db.AuthenticatedUser;
import io.stargate.db.Authenticator;
import io.stargate.db.dse.impl.Conversion;
import java.net.InetAddress;
import javax.security.cert.X509Certificate;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.exceptions.CassandraException;

public class AuthenticatorWrapper
implements Authenticator {
    private final IAuthenticator wrapped;

    public AuthenticatorWrapper(IAuthenticator wrapped) {
        this.wrapped = wrapped;
    }

    public String getInternalClassName() {
        return this.wrapped.getClass().getName();
    }

    public boolean requireAuthentication() {
        return this.wrapped.requireAuthentication();
    }

    public Authenticator.SaslNegotiator newSaslNegotiator(InetAddress clientAddress, X509Certificate[] certificates) {
        return new SaslNegotiatorWrapper(this.wrapped.newSaslNegotiator(clientAddress, certificates));
    }

    public static class SaslNegotiatorWrapper
    implements Authenticator.SaslNegotiator {
        private final IAuthenticator.SaslNegotiator wrapped;

        SaslNegotiatorWrapper(IAuthenticator.SaslNegotiator wrapped) {
            this.wrapped = wrapped;
        }

        public byte[] evaluateResponse(byte[] clientResponse) throws org.apache.cassandra.stargate.exceptions.AuthenticationException {
            try {
                return this.wrapped.evaluateResponse(clientResponse);
            }
            catch (AuthenticationException e) {
                throw Conversion.toExternal((CassandraException)e);
            }
        }

        public boolean isComplete() {
            return this.wrapped.isComplete();
        }

        public AuthenticatedUser getAuthenticatedUser() throws org.apache.cassandra.stargate.exceptions.AuthenticationException {
            try {
                return AuthenticatedUser.of((String)this.wrapped.getAuthenticatedUser().getName());
            }
            catch (AuthenticationException e) {
                throw Conversion.toExternal((CassandraException)e);
            }
        }
    }
}

